package com.tydic.dyc.oc.service.saleorder.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocGetSaleOrderItemsServiceRspItemBo
 * 说明:TODO
 * 时间:2022/4/8 10:53
 * 作者:代愿愿
 */
@Data
public class UocGetSaleOrderItemsServiceRspItemBo implements Serializable {
    private static final long serialVersionUID = -2809991130811759272L;


    /**销售明细id*/
    private Long saleOrderItemId;

    /**订单明细id*/
    private Long orderItemId;

    /**明细类型             1 商品sku             2 物资             3 项目*/
    private Integer itemType;

    /**明细类型翻译*/
    private String itemTypeStr;

    /**单品ID*/
    private String skuId;

    /**单品编码*/
    private String skuCode;

    /**单品名称*/
    private String skuName;

    /**商品id*/
    private String commodityId;

    /**商品编码*/
    private String commodityCode;

    /**商品名称*/
    private String commodityName;

    /**供应商ID*/
    private String supplierId;

    /**店铺ID*/
    private String supplierShopId;

    /**采购价格*/
    private BigDecimal purchasePrice;

    /**销售价格*/
    private BigDecimal salePrice;

    /**采购数量*/
    private BigDecimal purchaseCount;

    /**运费*/
    private BigDecimal transFee;

    /**采购金额*/
    private BigDecimal purchaseFee;

    /**销售金额*/
    private BigDecimal saleFee;

    /**应付金额*/
    private BigDecimal payFee;

    /**积分优惠金额*/
    private BigDecimal integralDisFee;

    /**活动优惠金额*/
    private BigDecimal actDisFee;

    /**其它优惠金额*/
    private BigDecimal otherDisFee;

    /**实付金额*/
    private BigDecimal usedFee;

    /**实付积分*/
    private BigDecimal usedIntegral;

    /**币种*/
    private String currencyType;

    /**税金*/
    private String taxPrice;

    /**税率*/
    private String tax;

    /**税务编码*/
    private String taxId;

    /**预计发货时间*/
    private Date preSendTime;

    /**预计交货时间*/
    private Date preOfferTime;

    /**计量单位*/
    private String unitName;

    /**结算计量单位*/
    private String settleUnit;

    /**售后在途数量*/
    private BigDecimal afterServingCount;

    /**外部电商主订单id*/
    private String lmOrderId;

    /**外部电商子订单id*/
    private String lmSubOrderId;

    /**到货周期*/
    private String arrivalTime;

    /**加价率*/
    private Double markUpRate;

    /**商品服务费 */
    private String serPrice;

    /**计划id*/
    private String planId;

    /**计划明细id */
    private String planItemId;

    /**计划明细编号*/
    private String planItemNo;

    /**超验百分比，下单时保存（协议、无协议）*/
    private Integer inspectionExcessPercent;

    /**sku物料编码*/
    private String skuMaterialId;

    /**sku外部单品id*/
    private String skuExtSkuId;

    /**sku品牌id*/
    private Long skuBrandId;

    /**单品品牌名称*/
    private String skuBrandName;

    /**sku明细id*/
    private String skuItemId;

    /**sku物料名称*/
    private String skuMaterialName;

    /**sku物料类型名称*/
    private String skuMaterialTypeName;

    /**sku物料类型id*/
    private String skuMaterialTypeId;

    /**型号*/
    private String model;

    /**规格*/
    private String spec;

    /**材质*/
    private String texture;

    /**图号*/
    private String figure;

    /**一级类目*/
    private Long l1Catalog;

    /**二级类目*/
    private Long l2Catalog;

    /**三级类目*/
    private Long l3Catalog;

    /**一级类目名称*/
    private String l1CatalogName;

    /**二级类目名称*/
    private String l2CatalogName;

    /**三级类目名称*/
    private String l3CatalogName;

    /**退货时间，空代表不支持*/
    private Integer rejectAllowDate;

    /**换货时间，空代表不支持*/
    private Integer exchangeAllowDate;

    /**维修时间，空代表不支持*/
    private Integer maintainAllowDate;

    /**sku单品主图url*/
    private String skuMainPicUrl;

    /**比选单号id*/
    private Long cmpOrderId;

    /**比选单号*/
    private String cmpOrderNo;

    /**铺货单位id*/
    private String distirbutionId;

    /**铺货单位名称*/
    private String distirbutionName;

    /**
     * 租户id
     */
    private Long sysTenantId;
    private String sysTenantName;

}
