package com.tydic.dyc.oc.service.saleorder.bo;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述：
 *
 * @author tgy
 * @date 2022/2/14 13:15
 */
@Data
public class UocOrderSplitToSaleOrderServiceRspSaleItemBo implements Serializable {

    private static final long serialVersionUID = -320563581287928703L;

    @DocField(value = "单品ID")
    private String skuId;

    @DocField(value = "供应商ID")
    private String supplierId;

    @DocField(value = "店铺ID")
    private String supplierShopId;

    @DocField(value = "采购金额")
    private BigDecimal purchasePrice;

    @DocField(value = "采购金额")
    private BigDecimal salePrice;

    @DocField(value = "采购数量")
    private BigDecimal purchaseCount;

    @DocField(value = "运费")
    private BigDecimal transFee;

    @DocField(value = "采购金额")
    private BigDecimal purchaseFee;

    @DocField(value = "应付金额")
    private BigDecimal payFee;

    @DocField(value = "积分优惠金额")
    private BigDecimal integralDisFee;

    @DocField(value = "活动优惠金额")
    private BigDecimal actDisFee;

    @DocField(value = "其它优惠金额")
    private BigDecimal otherDisFee;

    @DocField(value = "实付金额")
    private BigDecimal usedFee;

    @DocField(value = "实付积分")
    private BigDecimal usedIntegral;

    @DocField(value = "币种")
    private String currencyType;

    @DocField(value = "税金")
    private String taxPrice;

    @DocField(value = "税率")
    private String tax;

    @DocField(value = "税务编码")
    private String taxId;

    @DocField(value = "预计发货时间")
    private Date preSendTime;

    @DocField(value = "预计交货时间")
    private Date preOfferTime;

    @DocField(value = "计量单位")
    private String unitName;

    @DocField(value = "结算计量单位")
    private String settleUnit;

    @DocField(value = "到货周期")
    private String arrivalTime;

    @DocField(value = "加价率")
    private Double markUpRate;

    @DocField(value = "商品服务费 ")
    private String serPrice;

    @DocField(value = "计划id")
    private String planId;

    @DocField(value = "计划明细id ")
    private String planItemId;

    @DocField(value = "计划明细编号")
    private String planItemNo;

    @DocField(value = "超验百分比，下单时保存（协议、无协议）")
    private Integer inspectionExcessPercent;

    /**
     * 租户id
     */
    private Long sysTenantId;
    private String sysTenantName;

}


