package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 标题：UocOrderSyncCheckStatusReqBo
 * 说明：订单对账状态更新
 * 时间：2022/4/1 19:33
 *
 * @author 文乐
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class UocOrderSyncCheckStatusReqBo extends BaseReqBo {
    private static final long serialVersionUID = -1846635125943335140L;

    /*
    * 订单ID
    * */
    private Long orderId;

    /*
    * 单据ID
    * */
    private Long objId;

    /*
    * 单据类型
    * */
    private Integer objType;

    /*
    * 对账状态 0未对账 1对账一致 2对账不一致 (验收单对结算单1对多)
    * */
    private Integer checkState;

    //todo 联东修改部分
    /*
     * 操作类型 operType 1修改验收单下游是否已经确认开票
     * */
    private Integer operType;

}
