package com.tydic.dyc.oc.constants;

/**
 * 标题:UocCoreDicConstant
 * 说明:订单-字典编码常量
 * 时间:2022/2/24 9:45
 * 作者:田桂银
 */
public class UocDicConstant {


    /**
     * 是否需要开票
     */
    public static final class NEED_INVOICED {

        /**
         * 字典值
         */
        public static final String P_CODE = "NEED_INVOICED";

        /**
         * 需要开票
         */
        public static final Integer NEED_INVOICED_Y = 1;

        /**
         * 不需要开票
         */
        public static final Integer NEED_INVOICED_N = 0;
    }

    /**
     * 对象类型，1订单   2.销售单   3.执行单   4.发货单   5.收货单   6.售后服务单  7.支付单  8验收单  9审批单 10变更单   99.其他
     */
    public static final class OBJ_TYPE {
        public static final String P_CODE = "UOC_ORDER_OBJ_TYPE";

        public static final Integer ORDER = 1;
        public static final Integer SALE = 2;
        public static final Integer IMPL = 3;
        public static final Integer SHIP = 4;
        public static final Integer RECEIVE = 5;
        public static final Integer AFTER = 6;
        public static final Integer PAY = 7;
        public static final Integer INSPECTION = 8;
        public static final Integer APPROVE = 9;
        public static final Integer CHNG = 10;

        public static final Integer OTHER = 99;

    }

    /**
     * 关联类型 0普通开票 1上游开票 2服务费 3下游撮合开票
     */
    public static final class REL_TYPE {
        public static final String P_CODE = "UOC_ORDER_REL_TYPE";

        public static final Integer COMMON_INVOICE = 0;
        public static final Integer UP_INVOICE = 1;
        public static final Integer SERVICE_CHARGE = 2;
        public static final Integer CH_INVOICE = 3;

    }

    /**
     * 关联状态 0未提交 1已提交 2挂起
     */
    public static final class REL_STATUS {
        public static final String P_CODE = "UOC_ORDER_REL_STATUS";

        public static final Integer UN_SUBMITTED = 0;
        public static final Integer SUBMITTED = 1;
        public static final Integer HANG = 2;

    }

    /**
     * 应付类型，1：账期应付：2：预付款应付；3：成交服务费应付；4：平台使用费应付；5：到货款应付；6：验收款应付；7：质保金应付
     */
    public static final class SHOULD_PAY_TYPE {
        public static final String P_CODE = "SHOULD_PAY_TYPE";

        public static final Integer PAYMENT = 1;
        public static final Integer ADVANCE = 2;
        public static final Integer SERVICE = 3;
        public static final Integer PLATFORM = 4;
        public static final Integer GOODS = 5;
        public static final Integer CHECK = 6;
        public static final Integer GUARANTEE = 7;
    }

    /**
     * 对象类型，流程任务实例id完结状态：0未完结1已完结 2结束任务
     */
    public static final class PROC_TASK_FINISHED {
        public static final Integer FINISHED = 1;
        public static final Integer NO_FINISHED = 0;
        public static final Integer END_TASK = 2;

    }

    /**
     * 供应商订单类型，1:  京配订单 ,2: 厂直订单
     */
    public static final class VENDOR_ORD_TYPE {
        public static final String P_CODE = "VENDOR_ORDER_TYPE";
        public static final Integer JINDONG_DISTRIBUTION_ORDER = 1;
        public static final Integer FACTORY_DIRECT_ORDER = 2;

    }

    /**
     * 附件类型
     */
    public static final class ACCESSORY_TYPE {
        /**
         * 创建销售单
         */
        public static final Integer CREATE_ORDER = 1;

    }

    /**
     * 订单明细类型： 1 商品sku 2 物资 3 项目
     */
    public static final class ORDER_ITEM_TYPE {
        public static final Integer SKU = 1;
        public static final Integer MATERRIAS = 2;
        public static final Integer PROJECT = 3;

    }

    /**
     * 删除标志，1已删除，0未删除
     */
    public static final class DELETE_TAG {
        public static final String P_CODE = "UOC_ORD_DEL_TAG";
        public static final Integer DELETED = 1;
        public static final Integer NO_DEL = 0;

    }


    /**
     * 处理分类，1处理人，2候选人
     */
    public static final class TASK_DEAL_CLASS {
        public static final String ASSIGNEE = "1";
        public static final String CANDIDATE = "2";

    }

    /**
     * 订单状态
     */
    public static final class ORD_STATE {
        public static final String P_CODE = "UOC_ORDER_STATE";
    }

    /**
     * 销售单状态
     */
    public static final class SALE_ORD_STATE {
        public static final String P_CODE = "UOC_SALE_ORDER_STATE";

        /**
         * 无协议
         */
        public static final String P_CODE_NOAGREE = "UOC_SALE_ORDER_NOARGEE_TACHE_CODE";
        /**
         * 协议
         */
        public static final String P_CODE_AGREE = "UOC_SALE_ORDER_ARGEE_TACHE_CODE";
        /**
         * 电商
         */
        public static final String P_CODE_ECOM = "UOC_SALE_ORDER_ECOM_TACHE_CODE";

        /**
         * 协议、无协议、电商
         */
        public static final String P_CODE_ALL_MAIN = "UOC_SALE_ORDER_ALL_TACHE_CODE_MAIN";

        /**
         * 分配-待分配
         */
        public static final String XS_FP_DFP = "XS_FP_DFP";
        /**
         * 分配-分配中
         */
        public static final String XS_FP_FPZ = "XS_FP_FPZ";
        /**
         * 确认-待确认
         */
        public static final String XS_QR_DQR = "XS_QR_DQR";
    }

    /**
     * 执行单类型
     */
    public static final class IMPL_ORD_TYPE {
        /**
         * 字典
         */
        public static final String P_CODE = "UOC_IMPL_ORDER_TYPE";
        /**
         * 待定
         */
        public static final Integer PENDING = 1;
    }

    /**
     * 执行单状态
     */
    public static final class IMPL_ORD_STATE {
        /**
         * 字典
         */
        public static final String P_CODE = "UOC_IMPL_ORDER_STATE";
        /**
         * 待定
         */
        public static final Integer PENDING = 1;
    }

    /**
     * 开票标识
     */
    public static final class INVOICE_TAG {
        /**
         * 字典
         */
        public static final String P_CODE = "UOC_ORD_INVOICE_TAG";
        /**
         * 未开票
         */
        public static final Integer INVOICED = 0;
        /**
         * 1已开票
         */
        public static final Integer NOT_INVOICED = 1;
    }

    /**
     * 流转状态
     */
    public static final class PROC_STATE {
        /**
         * 字典
         */
        public static final String P_CODE = "UOC_ORD_PROC_STATE";
        /**
         * 待定
         */
        public static final Integer PENDING = 1;
    }

    /**
     * 对账状态
     */
    public static final class CHECK_STATE {
        /**
         * 字典
         */
        public static final String P_CODE = "UOC_ORD_CHECK_STATE";
        /**
         * 未对账
         */
        public static final Integer NO_CHECK = 0;
        /**
         * 对账一致
         */
        public static final Integer SUCCESS = 1;
        /**
         * 对账不一致
         */
        public static final Integer FAIL = 2;
    }


    /**
     * 订单来源 1 自营单品  2 电商导入 3 协议生成
     */
    public static final class ORDER_SOURCE {
        public static final String P_CODE = "UOC_SALE_ORDER_SOURCE";

        public static final Integer SELF_SUPPORT_PRODUCT = 1;
        public static final Integer E_COMMERCE_IMPORT = 2;
        public static final Integer AGR_GENERATE = 3;
        public static final String SELF_SUPPORT_PRODUCT_DES = "自营单品";
        public static final String E_COMMERCE_IMPORT_DES = "电商导入";
        public static final String AGR_GENERATE_DES = "协议生成";
    }

    /**
     * 付款方式，0 预付款按比例支付,1 协议分阶段,2 按账期支付
     */
    public static final class PAY_TYPE {
        public static final String P_CODE = "UOC_SALE_ORDER_PAY_TYPE";

        public static final Integer ADVANCE_PAYMENT_PRORATED = 0;
        public static final Integer PAY_BY_AGR_CONSTRAINT = 1;
        public static final Integer PAY_BY_PERIOD = 2;
    }

    /**
     * 支付状态，1400（待支付），1401（已付款），1402（付款失败）
     */
    public static final class PAY_STATE {

        public static final String P_CODE = "UOC_SALE_ORDER_PAY_STATE";
        /**
         * 待支付 1400
         */
        public static final Integer WAIT_PAY = 1400;
        /**
         * 已付款 1401
         */
        public static final Integer PAYED = 1401;
        /**
         * 付款失败 1402
         */
        public static final Integer PAY_FAILED = 1402;
        /**
         * 已退款 1403
         */
        public static final Integer REFUSED = 1403;
        /**
         * 部分付款 1404
         */
        public static final Integer PART_PAY = 1404;
        /**
         * 部分退款 1405
         */
        public static final Integer PART_REFUSED = 1405;
        /**
         * 退款中 1406
         */
        public static final Integer REFUSING = 1406;
        /**
         * 审批中 1407
         */
        public static final Integer APPROVING = 1407;
        /**
         * 审批通过待付款 1408
         */
        public static final Integer APPROVED = 1408;
        /**
         * 待审批 1009
         */
        public static final Integer PENDING = 1009;
        /**
         * 审批通过待付款 1007
         */
        public static final Integer APPROVING_PAY = 1007;
        /**
         * 付款成功待确认 1011
         */
        public static final Integer CONFIRM_PAY = 1011;
        /**
         * 已支付 1008
         */
        public static final Integer ALREADY_PAY = 1008;
        /**
         * 付款失败 1111
         */
        public static final Integer FAILED = 1111;
    }

    /**
     * 售后退款状态
     */
    public static final class PAY_AFTER_STATE {
        public static final String P_CODE = "PAY_AFTER_STATE";

        //更新中
        public static final Integer UPDATEING = 1400;
        //已更新应付金额
        public static final Integer AMOUNT__DUE_UPDATED = 1401;
        //已取消
        public static final Integer CANCELED = 1402;
        //退款中
        public static final Integer RETURNING = 1403;
    }

    /**
     * 支付类型 支付模块的类型
     */
    public static final class PAY_MOD {
        public static final String P_CODE = "UOC_SALE_ORDER_PAY_MOD";
    }

    /**
     * 账期支付结算规则 1:指定账期日 2:账期起算特定业务节点+账期天数
     */
    public static final class PAY_RULE {
        public static final String P_CODE = "PAY_RULE";

        public static final Integer SPECIFIED_ACCOUNT_DATE = 1;
        public static final Integer ACCOUNT_PERIOD_COUNT_BUSI_NODE = 2;
    }

    /**
     * 账期日结算订单规则 1:签收发票开始 2:订单验收 3:订单到货
     */
    public static final class PAY_ACCOUNT_DAY_RULE {
        public static final String P_CODE = "PAY_ACCOUNT_DAY_RULE";

        public static final Integer INVOICE_RECEIPT_BEGIN = 1;
        public static final Integer ORD_ACCEPT = 2;
        public static final Integer ORD_ARRIVE = 3;
    }

    /**
     * 账期起算特定业务节点 1:签收发票开始计算 2:订单验收开始计算 3:订单到货开始计算
     */
    public static final class PAY_NODE_RULE {
        public static final String P_CODE = "PAY_NODE_RULE";

        public static final Integer INVOICE_RECEIPT_BEGIN_CALCULATE = 1;
        public static final Integer ORD_ACCEPT_CALCULATE = 2;
        public static final Integer ORD_ARRIVE_CALCULATE = 3;
    }

    /**
     * 交易模式 1：贸易模式 2：搓合模式
     */
    public static final class TRADE_MODE {
        public static final String P_CODE = "TRADE_MODE";

        public static final Integer TRADE_MODE = 1;
        public static final Integer RUB_MODE = 2;
    }

    /**
     * 竣工标志 1 竣工  0 在途
     */
    public static final class FINISH_FLAG {
        public static final String P_CODE = "UOC_COMMON_FINISH_FLAG";

        public static final Integer FINISHED = 1;
        public static final Integer UN_FINISHED = 0;
    }

    /**
     * 是否已关闭尾差 1是 0否
     */
    public static final class CLOSE_PENNY_DIFF {
        public static final String P_CODE = "CLOSE_PENNY_DIFF";

        public static final Integer YES = 1;
        public static final Integer NO = 0;
    }

    /**
     * 撤单标志:1 已撤单 0 未撤单
     */
    public static final class CANCEL_FLAG {
        public static final String P_CODE = "UOC_COMMON_CANCEL_FLAG";

        public static final Integer CANCELED = 1;
        public static final Integer UN_CANCELED = 0;
    }

    /**
     * 结算模式 2:撮合 1:贸易
     */
    public static final class MODEL_SETTLE {
        public static final String P_CODE = "UOC_COMMON_MODEL_SETTLE";

        public static final Integer TRADE = 1;
        public static final Integer MATCH = 2;
    }

    /**
     * 整单状态字典 0驳回、1通过、2审批中 3已取消
     */
    public static final class ORDER_STATE {
        public static final String P_CODE = "UOC_COMMON_ORDER_STATE";
        /**
         * 0 驳回
         */
        public static final Integer REFUSE = 0;
        /**
         * 1 通过
         */
        public static final Integer PASS = 1;
        /**
         * 2 审批中
         */
        public static final Integer PENDING = 2;
        /**
         * 3 已取消
         */
        public static final Integer CANCEL = 3;
    }

    /**
     * 采购类别1 物资 2 施工 3 服务
     */
    public static final class PURCHASE_TYPE {
        public static final String P_CODE = "UOC_COMMON_PURCHASE_TYPE";

        public static final Integer MATERIAL = 1;
        public static final Integer CONSTRUCTION = 2;
        public static final Integer SERVICE = 3;
    }

    /**
     * 退款/扣款标志    0 扣款   1 退款
     */
    public static final class INTER_TYPE {
        public static final String P_CODE = "INTER_TYPE";

        public static final Integer DEBIT = 0;
        public static final Integer REFUND = 1;
    }

    /**
     * 采购模式 1计划，2非计划
     */
    public static final class PURCHASE_MODE {
        public static final String P_CODE = "UOC_COMMON_PURCHASE_MODE";

        public static final Integer PLAN = 1;
        public static final Integer UN_PLAN = 2;
    }

    /**
     * 发票类型    1 普票   2 专票
     */
    public static final class INVOICE_TYPE {
        public static final String P_CODE = "UOC_ORD_INVOICE_TYPE";

        public static final Integer COMMON_TICKET = 1;
        public static final Integer SPECIAL_TICKET = 2;
    }

    /**
     * 发票类别：1电子，2纸质
     */
    public static final class INVOICE_CATEGORY {
        public static final String P_CODE = "UOC_ORD_INVOICE_CATEGORY";

        public static final Integer COMMON_TICKET = 1;
        public static final Integer SPECIAL_TICKET = 2;
    }

    /**
     * 附件类型 0：合同附件 1：其他附件（供应商可见）2：其他附件（项目单位可见）
     */
    public static final class ATTACHMENT_TYPE {
        public static final String P_CODE = "UOC_ORDER_ACCESSORY_ATTACHMENT_TYPE";

        public static final Integer CONTRACT_ATTACH = 0;
        public static final Integer OTHER_ATTACH_FOR_SUPPLIER = 1;
        public static final Integer OTHER_ATTACH_FOR_PROJECT_UNIT = 2;
    }

    /**
     * 明细类型 1 商品sku  2 物资  3 项目
     */
    public static final class ITEM_TYPE {
        public static final String P_CODE = "UOC_COMMON_ITEM_TYPE";

        public static final Integer COMMODITY_SKU = 1;
        public static final Integer MATERIAL = 2;
        public static final Integer PROJECT = 3;
    }

    /**
     * 明细状态
     */
    public static final class ITEM_STATE {
        public static final String P_CODE = "UOC_COMMON_ITEM_STATE";

    }

    /**
     * 处理对象类型（1-个人，2-岗位）
     */
    public static final class DEAL_TYPE {
        public static final String P_CODE = "UOC_ORDER_TASK_DEAL_TYPE";

        public static final Integer SELF = 1;
        public static final Integer JOB = 2;
    }

    /**
     * 处理分类，1处理人，2候选人
     */
    public static final class DEAL_CLASS {
        public static final String P_CODE = "UOC_ORDER_TASK_DEAL_CLASS";

        public static final Integer HANDLER = 1;
        public static final Integer CANDIDATES = 2;
    }

    /**
     * 审批结果 1通过 0驳回
     */
    public static final class APPROVE_RESULT {
        public static final Integer APPROVED = 1;
        public static final Integer REJECT = 0;

    }


    /**
     * 使用类型：1：采购方；2：平台方
     */
    public static final class USE_TYPE {
        /**
         * 1：采购方
         */
        public static final Integer PUR = 1;
        /**
         * 2：平台方
         */
        public static final Integer PRO = 2;
    }

    public static final class TACHE_CODE_TASK_NAME {
        public static final String P_CODE = "TACHE_CODE_TASK_NAME";
    }

    public static final class TASK_INST_DEAL_TYPE {
        public static final String P_CODE = "TASK_INST_DEAL_TYPE";
    }

    /**
     * 服务类型   退货(10)、换货(20)、维修(30)
     */
    public static final class SERVICE_TYPE {
        public static final String P_CODE = "UOC_ORD_SERVICE_TYPE";

        public static final Integer RETURN_GOODS = 10;
        public static final Integer EXCHANGE_GOODS = 20;
        public static final Integer REPAIR = 30;
    }

    /**
     * 是否可取消    0：否     1：是
     */
    public static final class IS_CANCEL {
        public static final String P_CODE = "UOC_ORD_IS_CANCEL";

        public static final Integer NO = 0;
        public static final Integer YES = 1;
    }

    /**
     * 是否有包装    0：否     1：是
     */
    public static final class IS_HAS_PACKAGE {
        public static final String P_CODE = "UOC_ORD_IS_HAS_PACKAGE";

        public static final Integer NO = 0;
        public static final Integer YES = 1;
    }

    /**
     * 包装描述   0 无包装    10 包装完整  20 包装破损   30 暂不需要
     */
    public static final class PACKAGE_DECRIP {
        public static final String P_CODE = "UOC_ORD_PACKAGE_DECRIP";

        public static final Integer NO_PACKAGE = 0;
        public static final Integer PACKAGE_INTACT = 10;
        public static final Integer PACKAGE_DAMAGED = 20;
        public static final Integer NOT_NEED_YET = 30;
    }

    /**
     * 取消类型   1 申请人取消   2 供货商取消
     */
    public static final class CANCEL_TYPE {
        public static final String P_CODE = "UOC_ORD_CANCEL_TYPE";

        public static final Integer APPLYER_CANCEL = 1;
        public static final Integer SUPPLIER_CANCEL = 2;
    }

    /**
     * 取货服务类型  1：  上门取件   2：客户发货  3：  客户送货
     */
    public static final class PICKWARE_SERVE_TYPE {
        public static final String P_CODE = "UOC_ORD_PICKWARE_SERVE_TYPE";

        public static final Integer PICKWARE_BY_DOOR_TO_DOOR = 1;
        public static final Integer DELIVERY_BY_CUSTOMER = 2;
        public static final Integer SEND_BY_CUSTOMER = 3;
    }

    /**
     * 服务单状态
     * 100     已申请待供方确认
     * 200     供应商确认通过
     * 201     供方标记售后完成
     * 300     售后拒绝
     * 400     已取消
     * 401     买方确认售后完成
     */
    public static final class SERVICE_STATE {
        public static final String P_CODE = "UOC_ORD_SERVICE_STATE";

        public static final Integer SUMIT_APPLICATION = 100;
        public static final Integer APPROVAL_PASS = 200;
        public static final Integer REMARK_COMPLATE = 201;
        public static final Integer APPROVAL_NOT_PASS = 300;
        public static final Integer CANCEL = 400;
        public static final Integer COMPLATE = 401;
    }

    /**
     * 供应商售后服务环节编码
     * 申请阶段(10)             审核不通过(20)             客服审核(21)
     * 商家审核(22)             京东收货(31)             商家收货(32)
     * 京东处理(33)             商家处理(34)             用户确认(40)
     * 完成(50)             取消 (60)
     */
    public static final class SERVICE_STEP {
        public static final String P_CODE = "UOC_ORD_SERVICE_STEP";

        public static final Integer APPLY_STAGE = 10;
        public static final Integer AUDIT_NOT_PASS = 20;
        public static final Integer CUSTOMER_AUDIT = 21;
    }

    /**
     * 快递公司编码
     */
    public static final class LOGISTICS_COMPANY_CODE {
        public static final String P_CODE = "UOC_ORD_LOGISTICS_COMPANY_CODE";
    }

    /**
     * 协议模式 1：平台协议 2：单位协议
     */
    public static final class AGREEMENT_MODE {
        public static final String P_CODE = "UOC_ORD_AGREEMENT_MODE";

        public static final Integer PLATFORM_AGREEMENT = 1;
        public static final Integer UNIT_AGREEMENT = 2;
    }

    /**
     * 调价机制    2：事中
     */
    public static final class ADJUST_PRICE {
        public static final String P_CODE = "UOC_ORD_ADJUST_PRICE";

        public static final Integer IN_THE_THING = 2;
    }

    /**
     * 售后原因
     */
    public static final class AFS_REASON {
        public static final String P_CODE = "AFS_REASON";

    }

    /**
     * 应付单支付状态 是否支付完成：0：未支付；1：支付完成
     */
    public static final class SHOULD_PAY_ORDER_PAY_STATE {
        public static final String P_CODE = "";

        public static final Integer NOT_PAY_COMPLETED = 0;
        public static final Integer PAY_COMPLETED = 1;
    }

    /**
     * 状态变更  1，拒收  2，妥投
     */
    public static final class STATE_CHNG {
        public static final String P_CODE = "";

        public static final String JUSHOU = "1";
        public static final String TUOTOU = "2";
    }

    /**
     * 有无退货  1，有  2，无
     */
    public static final class IS_RETURN_FLAG {
        public static final String P_CODE = "IS_RETURN_FLAG";

        public static final Integer YES = 1;
        public static final Integer NO = 0;
    }

    /**
     * 订单阶段 0：进行中 1：交易成功 2：交易关闭
     */
    public static final class ORDER_STAPE {
        public static final String P_CODE = "ORDER_STAPE";

        public static final Integer IN_PROGRESS = 0;
        public static final Integer TRADE_SUCCESS = 1;
        public static final Integer TRADE_CLOSE = 2;
    }

    /**
     * 评价状态,0未评价，1已评价，可以追评，2已评价，不可以追评，3评价超时，不可以追评，4已追评，5追评超时
     */
    public static final class EVA_ACT {
        public static final String P_CODE = "EVALUATE_STATE";

        public static final Integer NOT_RATED = 0;
        public static final Integer EVALUATED_CAN_REVIEWED = 1;
        public static final Integer EVALUATED_CAN_NOT_REVIEWED = 2;
        public static final Integer EVALUATED_TIME_OUT = 2;
        public static final Integer REVIEWED = 4;
        public static final Integer REVIEWED_TIME_OUT = 5;

    }

    /**
     * 支付配置，使用类型：1：采购方；2：平台方
     */
    public static final class PAY_CONF_USE_TYPE {
        public static final Integer PUR = 1;
        public static final Integer PRO = 2;

    }

    public static final class UOC_INSP_ORDER_PAY_TYPE {
        public static final String P_CODE = "UOC_INSP_ORDER_PAY_TYPE";
    }

    /**
     * 加签标识  0 ：环节任务   1：前加签任务  2：后加签任务  3：存在后加签任务
     */
    public static final class TASK_SING_TAG {
        public static final Integer TACHE_TASK = 0;
        public static final Integer PRE_TASK = 1;
        public static final Integer AF_TASK = 2;
        public static final Integer EXIST_AF_TASK = 3;

    }

    /**
     * 电商销售订单状态-异常变更
     */
    public static final class UOC_PRO_CNNG_ORDER_STATUS {
        public static final String P_CODE = "UOC_PRO_CNNG_ORDER_STATUS";

    }

    /**
     * 订单创建-下单人用户类型
     * 1 外部个人 2 外部企业 3内部个人 4 内部企业
     */
    public static final class ORDER_CREATE_USE_TYPE {
        public static final String P_CODE = "ORDER_CREATE_USE_TYPE";
        public static final Integer EXT_PERSON = 1;
        public static final Integer EXT_COM = 2;
        public static final Integer INT_PERSON = 3;
        public static final Integer INT_COM = 4;
    }
}


