package com.tydic.dyc.oc.service.common.bo;


import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 描述：
 *
 * @author tgy
 * @date 2021/3/1 16:25
 */
@Data
public class UocProUmcReqInfoBo implements Serializable {

    private static final long serialVersionUID = 2180077600579135462L;

    @DocField(value = "会员类型，会员注入：1外部个人 2外部企业 3内部个人用户 4内部企业用户")
    private String memUserType;
    private Integer orgLevel;
    /**
     * 价格体系系数
     */
    private BigDecimal psDiscountRate;
    private String loginSource;

    /**
     * token值
     */
    private String token;
    private String reqNo;
    @DocField(value = "用户id，会员注入")
    private Long userId;
    private String name;
    @DocField(value = "用户名称，会员注入")
    private String username;
    private String password;
    private String orgPath;
    @DocField(value = "会员机构id，会员注入")
    private Long orgId;
    private String orgName;
    private String cellphone;
    private Long tenantId;
    private String tenantName;
    private Long memIdExt;

    /**
     * 所属公司编码
     */
    @DocField(value = "所属公司id")
    private Long companyId;

    /**
     * 所属公司名称
     */
    private String companyName;
    /**
     * 采购账套编号
     */
    private Long purchaserAccountUser;


    /**
     * 组织机构类型
     */
    private String isprofess;


    /*** 供应商名称*/
    private String supName;

    /*** 所属组织机构全称*/
    private String orgFullName;
    /**
     * 会员ID
     */
    private Long memId;
    /**
     * 会员
     */
    private Long memIdIn;
    /**
     * 机构
     */
    private Long orgIdIn;
    /**
     * 用户
     */
    private Long userIdIn;
    /**
     * 支付方式（0： 1：微信 2：支付宝 3：沃支付 4：易支付 5：QQ支付）
     */
    private Integer payTypeIn;
    private Long parentOrgIdIn;
    private Long rootOrgIdIn;
    private List<UocProStationWebBO> umcStationsListWebExt;
    /**
     * 机构ID List
     * 只有机构管理员才有
     */
    private List<Long> mgOrgIdsExt;
    /**
     * 账号类型
     * 0 运营单位
     * 1 采购单位
     * 2 供应商
     */
    private String isProfessionalOrgExt;
    /**
     * 供应商ID
     */
    private Long supId;
    /**
     * 老系统的用户id
     */
    private String oldMemIdIn;
    /**
     * 角色
     */
    private Set<UocProAuthorityInfo> permission = new HashSet<>();
    /**
     * 角色名称信息
     */
    private List<UocProUserRoleBO> umcUserRoleBOList;

    private List<String> selfStationCodes;
    private String institutionalCode;
}


