package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.utils.generatedoc.annotation.DocInterface;
import lombok.extern.ohaotian.HTServiceAPI;

/**
 * 描述：字典服务，前端使用
 *
 * @author tkl
 * @date 2022/3/9 14:20
 * <p>
 **/
@HTServiceAPI
public interface UocProDictionaryService {

    /**
     * 描述: 查字典
     *
     * @param reqBO 入参对象
     * @return UocProDictionaryRspBO
     */
    UocProDictionaryRspBO qryDic(UocProDictionaryReqBO reqBO);

    /**
     * 创建字典值
     *
     * @param reqBO 入参对象
     * @return UocProDictionaryCreateRspBO
     */
    UocProDictionaryCreateRspBO createDic(UocProDictionaryCreateReqBO reqBO);

    /**
     * 修改字典值
     *
     * @param reqBO 入参对象
     * @return UocProDictionaryUpdateRspBO
     */
    UocProDictionaryUpdateRspBO updateDic(UocProDictionaryUpdateReqBO reqBO);

    /**
     * 删除字典值
     *
     * @param reqBO 入参对象
     * @return FscDictionaryDeleteBusiRspBO
     */
    UocProDictionaryDeleteRspBO deleteDic(UocProDictionaryDeleteReqBO reqBO);

}
