package com.tydic.dyc.oc.service.implorder.bo;

import com.tydic.dyc.base.bo.BaseRspBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryTypeDetailBo;
import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述：
 *
 * @author tgy
 * @date 2022/2/13 22:33
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UocGetImplOrderDetailsServiceRspBo extends BaseRspBo {

    private static final long serialVersionUID = -2011667544475282433L;


	@DocField(value = "销售单id")
    private Long saleOrderId;

    @DocField(value = "销售单编号")
    private String saleOrderNo;

    @DocField(value = "销售单状态")
    private String saleOrderState;

    @DocField(value = "销售单状态翻译")
    private String saleOrderStateStr;

    @DocField(value = "订单id")
    private Long orderId;

    @DocField(value = "执行单编码")
    private String implOrderNo;

    @DocField(value = "外部执行单编码")
    private String implOrderNoExt;

    @DocField(value = "执行单名称")
    private String implOrderName;

    @DocField(value = "执行单类型")
    private Integer implOrderType;

    @DocField(value = "执行单类型翻译")
    private String implOrderTypeStr;

    @DocField(value = "执行单状态")
    private String implOrderState;

    @DocField(value = "执行单状态翻译")
    private String implOrderStateStr;

    @DocField(value = "执行单说明")
    private String implOrderDesc;

    @DocField(value = "销售金额")
    private BigDecimal totalSaleFee;

    @DocField(value = "采购金额")
    private BigDecimal totalPurchaseFee;

    @DocField(value = "优惠金额")
    private BigDecimal totalActShareFee;

    @DocField(value = "运费")
    private BigDecimal totalTransFee;

    @DocField(value = "实付金额")
    private BigDecimal usedFee;

    @DocField(value = "实付积分")
    private BigDecimal usedIntegral;

    @DocField(value = "协议编号")
    private String agreementNo;

    @DocField(value = "合同编号")
    private String contractNo;

    @DocField(value = "流转状态")
    private String procState;

    @DocField(value = "流转状态翻译")
    private String procStateStr;

    @DocField(value = "对账状态")
    private String checkState;

    @DocField(value = "对账状态翻译")
    private String checkStateStr;

    @DocField(value = "税率")
    private String taxRate;

    @DocField(value = "采购账套ID")
    private String purAccount;

    @DocField(value = "采购方账套名称")
    private String purAccountName;

    @DocField(value = "采购方联系人")
    private String purContactName;

    @DocField(value = "采购方联系人电话")
    private String purMobile;

    @DocField(value = "采购方下单人用户id")
    private String purUserId;

    @DocField(value = "采购方下单人真实姓名")
    private String purName;

    @DocField(value = "采购方下单人登录名")
    private String purUserName;

    @DocField(value = "采购方公司id")
    private String purCompanyId;

    @DocField(value = "采购公司编码")
    private String purCompanyNo;

    @DocField(value = "采购方公司名称")
    private String purCompanyName;

    @DocField(value = "采购方机构id")
    private String purOrgId;

    @DocField(value = "采购方机构编码")
    private String purOrgNo;

    @DocField(value = "采购方机构名称")
    private String purOrgName;

    @DocField(value = "下单组织机构路径")
    private String purOrgPath;

    @DocField(value = "需方联系人名称")
    private String purNeedName;

    @DocField(value = "需方联系电话")
    private String purNeedMobile;

    @DocField(value = "供应商id")
    private String supId;

    @DocField(value = "供应商编码")
    private String supNo;

    @DocField(value = "供应商名称")
    private String supName;

    @DocField(value = "供应商联系人")
    private String supRelaName;

    @DocField(value = "供应商联系电话")
    private String supRelaMobile;

    @DocField(value = "运营单位机构id")
    private String proId;

    @DocField(value = "运营单位机构编码")
    private String proNo;

    @DocField(value = "运营机构名称")
    private String proName;

    @DocField(value = "运营机构机构树路径")
    private String proOrgPath;

    @DocField(value = "运营机构账户名称")
    private String proAccountName;

    @DocField(value = "运营机构账户")
    private String proAccount;

    @DocField(value = "运营机构联系人")
    private String proRelaName;

    @DocField(value = "运营机构联系电话")
    private String proRelaMobile;

    @DocField(value = "协议经办人id（配送专责）")
    private String proDeliveryId;

    @DocField(value = "协议经办人名字（配送专责）")
    private String proDeliveryName;

    @DocField(value = "竣工标志 1 竣工  0 在途")
    private Integer finishFlag;

    @DocField(value = "竣工标志翻译")
    private String finishFlagStr;

    @DocField(value = "创建时间")
    private Date createTime;

    @DocField(value = "创建工号")
    private String createOperId;

    @DocField(value = "更新时间")
    private Date updateTime;

    @DocField(value = "更新工号")
    private String updateOperId;

    @DocField(value = "撤单时间")
    private Date cancelTime;

    @DocField(value = "撤单工号")
    private String cancelOperId;

    @DocField(value = "取消原因")
    private String cancelReason;

    @DocField(value = "备注")
    private String remark;

    @DocField(value = "竣工时间")
    private Date finishTime;

    @DocField(value = "逾期时间")
    private Date expTime;

    @DocField(value = "结算模式 2:撮合 1:贸易")
    private Integer modelSettle;

    @DocField(value = "结算模式翻译")
    private String modelSettleStr;

    @DocField(value = "采购类别             1 物资             2 施工             3 服务             ")
    private Integer purchaseType;

    @DocField(value = "采购类别翻译")
    private String purchaseTypeStr;

    @DocField(value = "订单备注")
    private String orderRemark;

    @DocField(value = "付款方式，0 预付款按比例支付,1 按协议约束支付,2 按账期支付")
    private String payType;

    @DocField(value = "付款方式翻译")
    private String payTypeStr;

    @DocField(value = "订单来源 1 自营单品  2 电商导入 3 协议生成")
    private Integer orderSource;

    @DocField(value = "订单来源翻译")
    private String orderSourceStr;

    @DocField(value = "执行单明细信息")
    private List<UocGetImplOrderDetailsServiceRspItemBo> implOrderDetailsServiceRspBoList;

    @DocField(value = "执行单拓展信息")
    private List<UocGetImplOrderDetailsServiceRspExtBo> implOrderDetailsServiceRspExtBoList;

    @DocField(value = "收货信息")
    private UocGetImplOrderDetailsServiceRspReceiverAddressBo receiverAddressBo;

    @DocField("附件信息")
    private List<UocBaseOrderAccessoryTypeDetailBo> accessoryDetailBoList;
}


