package com.tydic.dyc.oc.service.domainservice.bo;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocQryChngOrderDetailsRspInfoItemBo
 * 说明:商品明细
 * 时间:2022/3/14 21:37
 * 作者:罗有
 */

@Data
@EqualsAndHashCode(callSuper=false)
public class UocQryChngOrderDetailsRspInfoItemBo implements Serializable {
    private static final long serialVersionUID = -8434860065338516602L;

    //订单id")
    private Long orderId;

    //销售明细ID")
    private Long saleOrderItemId;

    //单品ID")
    private String skuId;

    //单品名称")
    private String skuName;

    //商品id")
    private String commodityId;

    //商品名称")
    private String commodityName;

    //采购单价")
    private BigDecimal purchasePrice;

    //调价后采购单价")
    private BigDecimal purchasePriceRear;

    //销售单价")
    private BigDecimal salePrice;

    //调价后销售单价")
    private BigDecimal salePriceRear;

    //调价率")
    private BigDecimal adjustPriceRate;

    //采购数量")
    private BigDecimal purchaseCount;

    //运费")
    private BigDecimal transFee;

    //销售金额")
    private BigDecimal saleFee;

    //采购金额")
    private BigDecimal purchaseFee;

    //应付金额")
    private BigDecimal payFee;

    //税金")
    private String taxPrice;

    //税率")
    private String tax;

    //税务编码")
    private String taxId;

    //预计发货时间")
    private Date preSendTime;

    //预计交货时间")
    private Date preOfferTime;

    //计量单位")
    private String unitName;

    //结算计量单位")
    private String settleUnit;

    //售后在途数量")
    private BigDecimal afterServingCount;

    //原退货数量")
    private BigDecimal preReturnCount;

    //现退货数量")
    private BigDecimal curReturnCount;

    //验收数量")
    private BigDecimal inspCount;

    //调整数量")
    private BigDecimal chngNum;

    //调整金额")
    private BigDecimal chngFee;

    //变更状态")
    private String chngState;

    //变更状态翻译")
    private String chngStateStr;

    //其他变更")
    private String otherChngValue;

    //其他变更翻译")
    private String otherChngValueStr;

    //外部电商主订单id")
    private String lmOrderId;

    //外部电商子订单id")
    private String lmSubOrderId;

    //到货周期")
    private String arrivalTime;

    //加价率")
    private Double markUpRate;

    //调价后加价率")
    private Double markUpRateRear;

    //sku物料id")
    private String skuMaterialId;

    //sku物料编码")
    private String skuMaterialCode;

    //sku外部单品id")
    private String skuExtSkuId;

    //sku品牌id")
    private Long skuBrandId;

    //单品品牌名称")
    private String skuBrandName;

    //sku明细id")
    private String skuItemId;

    //sku物料名称")
    private String skuMaterialName;

    //sku物料类型名称")
    private String skuMaterialTypeName;

    //sku物料类型id")
    private String skuMaterialTypeId;

    //型号")
    private String model;

    //规格")
    private String spec;

    //材质")
    private String texture;

    //图号")
    private String figure;

    //一级类目")
    private Long l1Catalog;

    //二级类目")
    private Long l2Catalog;

    //三级类目")
    private Long l3Catalog;

    //一级类目名称")
    private String l1CatalogName;

    //二级类目名称")
    private String l2CatalogName;

    //三级类目名称")
    private String l3CatalogName;

    //退货时间，空代表不支持")
    private Integer rejectAllowDate;

    //换货时间，空代表不支持")
    private Integer exchangeAllowDate;

    //维修时间，空代表不支持")
    private Integer maintainAllowDate;

    //sku单品主图url")
    private String skuMainPicUrl;

    //发货明细id")
    private Long shipItemId;

    //单品编码")
    private String skuCode;

    //该商品是否调价")
    private Boolean adjustFlag;

    //供应商ID")
    private String supplierId;

    //店铺ID")
    private String supplierShopId;

    //计量单位")
    private String unitDigit;
    
    
    /**
     * 比选单号
     */
    //比选单号")
    private String cmpOrderNo;

    //验收单编号")
    private String inspOrderNo;

    /**
     * 剩余验收数量
     */
    private BigDecimal remainInspCount;
    /**
     * 增减类型，1：增加验收数量；2：减少验收数量
     */
    private Integer addOrSubtractType;
    /**
     * 初始验收数量
     */
    private BigDecimal initInspCount;
}
