package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelDeleteBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelEditBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryAddBo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.EqualsAndHashCode;

import java.util.Date;
import java.util.List;

/**
 * 描述: 〈领域服务-发货单到货确认/拒收入参〉
 * @author : yuhao
 * @date : 2022/8/24 18:49
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocShipOrderArrivaConfirmOrRefuseReqBo extends BaseReqBo {
    private static final long serialVersionUID = 3398938446971992877L;

    /**
    * 操作 1 到货确认 2到货拒收
    * */
    private Integer opFlag;

    /**
    * 发货单ids
    * */
    private List<Long> shipOrderIdList;

    /**
    * 订单id
    * */
    private Long orderId;

    /**
    * 销售单id
    * */
    private Long saleOrderId;

    /**
    * 收货人
    * */
    private String receiverUser;

    /**
    * 收货备注
    * */
    private String receiverRemark;

    /**
    * 收货联系电话
    * */
    private String receiverContact;

    /**
    * 收货时间
    * */
    private Date receiverTime;

    /**
    * 纵向扩展数据 更新
    * */
    private List<UocBaseExtParallelEditBo> extEditList;

    /**
    * 纵向拓展信息 删除
    * */
    private List<UocBaseExtParallelDeleteBo> extDeleteList;

    /**
    * 附件
    * */
    private List<UocBaseOrderAccessoryAddBo> orderAccessoryBoList;

    /**
    * 任务id
    * */
    private String taskId;

    /**
    * 任务id
    * */
    private List<String> taskIds;

    /**
    * 当前用户id
    * */
    private Long userId;
}
