package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.bo.BaseRspBo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 标题:UocQryOrderCreateResultServiceRspBo
 * 说明:
 * 时间:2022/2/22 10:47
 * 作者:田桂银
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UocQryOrderCreateResultServiceRspBo extends BaseRspBo {

    private static final long serialVersionUID = 336495815737149815L;

    /*
    * 订单处理结果，返回true，代表后端数据处理完成（此时可以去读取successList和failedList），" +
            "如果返回false，可以继续轮询（轮询次数或者时间，由前端根据需求来定），直到返回true为止
    * */
    private Boolean processResult;

    /*
    * 订单id
    * */
    private Long orderId;

    /*
    * 订单编号
    * */
    private String orderNo;

    /*
    * 总销售金额
    * */
    private BigDecimal totalSaleFee;

    /*
    * 需要审批的订单
    * */
    private List<UocQryOrderCreateResultServiceRspProcessDataBo> needApprovedOrders = new ArrayList<>();

    /*
    * 可以立即支付的订单
    * */
    private List<UocQryOrderCreateResultServiceRspProcessDataBo> canPayOrders = new ArrayList<>();
    
    //处理失败的订单，如果有失败，则代表整个订单有处理失败的订单，则需要展示相关原因")
    private List<UocQryOrderCreateResultServiceRspProcessDataBo> failedList = new ArrayList<>();

}


