package com.tydic.dyc.oc.service.bargaining.bo;

import com.tydic.dyc.base.bo.BaseRspBo;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 描述：议价单详情查询出参
 */
@Data
public class UocQryBargainingDetailRspBo extends BaseRspBo implements Serializable {
    private static final long serialVersionUID =  2545116941019966633L;

    /**
     * 议价单id
     */
    private Long bargainingId;
    /**
     * 议价单编码
     */
    private String bargainingNo;
    /**
     * 议价单状态
     * YJ_DBJ 待发起
     * YJ_DBJ 报价中
     * YJ_YBJ 已报价
     * YJ_YZZ 已终止
     * YJ_YXD 已下单
     */
    private String bargainingState;
    /**
     * 议价单状态名称（翻译）
     */
    private String bargainingStateStr;
    /**
     * 议价人ID
     */
    private String bargainingOperId;
    /**
     * 议价人名称
     */
    private String bargainingOperName;
    /**
     * 供应商ID
     */
    private String supId;
    /**
     * 供应商编码
     */
    private String supNo;
    /**
     * 供应商名称
     */
    private String supplierName;


    /**
     * 创建时间
     */
    private Date createTime;
    private Date createTimeStart;
    private Date createTimeEnd;


    /**
     * 终止时间
     */
    private Date cancelTime;
    private Date cancelTimeStart;
    private Date cancelTimeEnd;


    /**
     * 预计收货人地址信息
     */
    private UocBargainingAddressBo bargainingAddress;
    /**
     * 任务id
     */
    private String taskId;
}
