package com.tydic.dyc.oc.service.cmporder.bo;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * UocQryCmpOrderDetailServiceItemBo
 * 2023/3/1
 * Project:dyc-uoc-pro
 * Creator:印昌盛
 * Create Time:2023/3/1-22-09
 * IDE: IntelliJ IDEA
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocQryCmpOrderDetailServiceItemBo implements Serializable {
    private static final long serialVersionUID = -118760370142623495L;
    /**
     * 比选单明细id
     */
    private Long cmpOrderItemId;
    /**
     *比选单id
     */
    private Long cmpOrderId;
    /**
     *单品id
     */
    private String skuId;
    /**
     *商品id
     */
    private String spuId;
    /**
     *供应商id
     */
    private String goodsSupplierId;
    /**
     *所属供应商名称
     */
    private String goodsSupplierName;
    /**
     *店铺id
     */
    private String shopId;
    /**
     *原商品购物车id(比选原商品必传)
     */
    private String cartId;
    /**
     *销售价
     */
    private String skuSalePrice;
    /**
     *总价
     */
    private String totalSalePrice;
    /**
     *销售单位
     */
    private String unitName;
    /**
     *商品名称
     */
    private String skuName;
    /**
     *数量
     */
    private String purchaseCount;
    /**
     *规格
     */
    private String specification;
    /**
     *图片地址
     */
    private String imgUrl;
    /**
     *是否暂无（是的传   暂无）
     */
    private String nothing;
    /**
     *排序（页面第几个
     */
    private Integer skuOrder;
    /**
     *物料id
     */
    private String materialId;
    /**
     *交货时间
     */
    private Date deliveryTime;
    /**
     *交货时间字符串
     */
    //部分电商返回是字符串，用于向前兼容date类型，数据库增加一个String类型的字段
    private String deliveryTimeStr;
    /**
     *品牌
     */
    private String brand;
    /**
     *型号
     */
    private String model;
    /**
     *销量
     */
    private BigDecimal saleCount;
    /**
     *物料名称
     */
    private String materialName;
    /**
     *上架时间
     */
    private Date shelvesTime;
    /**
     *好评率
     */
    private BigDecimal positiveRate;
    /**
     *售后服务政策
     */
    private String afsPolicy;
    /**
     *创建时间
     */
    private Date createTime;
    /**
     *创建时间 开始
     */
    private Date createTimeStart;
    /**
     *创建时间 结束
     */
    private Date createTimeEnd;
    /**
     *创建工号
     */
    private String createOperId;
    /**
     *更新时间
     */
    private Date updateTime;
    /**
     *更新时间 开始
     */
    private Date updateTimeStart;
    /**
     *更新时间 结束
     */
    private Date updateTimeEnd;
    /**
     *更新工号
     */
    private String updateOperId;
    /**
     *备注
     */
    private String remark;
    /**
     *删除标志1已删除
     */
    private Integer delTag;
    /**
     *排序
     */
    private String orderBy;
    /**
     *比选单明细扩展
     */
    private List<UocGetCmpOrderDetailServiceRspItemMapBo> uocCmpItemMapList;
    
    //商品来源， 1 自营单品 2 电商导入 3 协议生成")
    private Integer skuSource;
    
    //供应商id	")
    private String vendorId;
    
    //供应商店铺id	")
    private String supplierShopId;
}
