package com.tydic.dyc.oc.constants;

/**
 * 标题:UocCoreConstant
 * 说明:订单核心常量（内部创建子类）
 * 时间:2022/2/24 9:49
 * 作者:田桂银
 */
public class UocConstant {


    /**
     * 商品来源，1 自营单品   2 电商导入   3 协议生成
     */
    public static final class SkuSource {
        public static final Integer SELF = 1;
        public static final Integer ELC = 2;
        public static final Integer AGR = 3;
    }

    /**
     * 结算模式，1 贸易模式   2 撮合模式
     */
    public static final class ModelSettle {
        public static final Integer MY = 1;
        public static final Integer CH = 2;
    }


    /**
     * 统计单据金额数量
     * 查询类型 1 销售单 2 验收单
     */
    public static final class SearchType {
        public static final Integer SALE = 1;
        public static final Integer INSP = 2;
    }

    /**
     * 开票标识 0未开票 1已开票
     */
    public static final class INVOICE_TAG {
        /**
         * 0 未开票
         */
        public static final Integer NO = 0;
        /**
         * 1 已开票
         */
        public static final Integer YES = 1;
    }

    /**
     * 脱离主体字段名常量
     */
    public static final class ES_MAIN_OTHER {
        /**
         * 销售单编号字段名
         */
        public static final String SALE_ORDER_NO = "saleOrderNo";
        /**
         * 三方信息列表
         */
        public static final String STAKEHOLDERS = "stakeholders";
        /**
         * 采购单位名称
         */
        public static final String PURCHASE_ORG_NAME = "purchaseOrgName";
        /**
         * 采购单位id
         */
        public static final String PURCHASE_ORG_ID = "purchaseOrgId";
        /**
         * 采购单位公司名称
         */
        public static final String PURCHASE_COMPANY_NAME = "purchaseCompanyName";
        /**
         * 采购单位公司id
         */
        public static final String PURCHASE_COMPANY_ID = "purchaseCompanyId";
        /**
         * 下单人
         */
        public static final String PUR_NAME = "purName";
        /**
         * 下单人账号
         */
        public static final String PUR_USER_NAME = "purUserName";
        /**
         * 商品信息
         */
        public static final String COMMODITY_INFOS = "commodityInfos";
        /**
         * 供应商ID列表
         */
        public static final String SUPPLIER_ID_LIST = "supplierIdList";
        /**
         * 外部销售单编码字段名
         */
        public static final String SALE_ORDER_NO_EXT = "saleOrderNoExt";
        /**
         * 发货单编号字段名
         */
        public static final String SHIP_ORDER_NO = "shipOrderNo";
        /**
         * 付款时限
         */
        public static final String PAY_AGING = "payAging";
        /**
         * 异常变更时限
         */
        public static final String CHNG_AGING = "allowChngTime";
        /**
         * 尾差是否关闭标识
         */
        public static final String COLSE_DEFF_FLAF = "closeDeffFlag";
        /**
         * 发货单编号模糊查询
         */
        public static final String SHIP_ORDER_NO_QRY = "shipOrderNoQry";
        /**
         * 发货单Id字段名
         */
        public static final String SHIP_ORDER_ID = "shipOrderId";
        /**
         * 最晚到货时间
         */
        public static final String LAST_ARRIVE_TIME = "lastArriveTime";
        /**
         * 发货单Id模糊查询
         */
        public static final String SHIP_ORDER_ID_QRY = "shipOrderIdQry";
        /**
         * 来源
         */
        public static final String ORDER_SOURCE = "orderSource";
        /**
         * 来源
         */
        public static final String ORDER_SOURCE_STR = "orderSourceStr";
        /**
         * 发货数量
         */
        public static final String SHIP_SEND_COUNT = "sendCount";
        /**
         * 拒收数量
         */
        public static final String SHIP_REFUSE_COUNT = "refuseCount";
        /**
         * 验收编号字段名
         */
        public static final String INSP_ORDER_NO = "inspOrderNo";
        /**
         * 验收编号查询字段名
         */
        public static final String INSP_ORDER_NO_QRY = "inspOrderNoQry";
        /**
         * 验收销售金额
         */
        public static final String INSP_SALE_FEE = "inspSaleFee";
        /**
         * 验收ID字段名
         */
        public static final String INSP_ORDER_ID = "inspOrderId";
        /**
         * 验收时间
         */
        public static final String INSP_TIME_LIST = "inspTimeList";
        /**
         * 验收名字
         */
        public static final String INSP_OPER_NAME_LIST = "inspoperNameList";
        /**
         * 验收ID查询字段名
         */
        public static final String INSP_ORDER_ID_QRY = "inspOrderIdQry";
        /**
         * 执行单编号字段名
         */
        public static final String IMPL_ORDER_NO = "implOrderNo";
        /**
         * 执行单Id字段名
         */
        public static final String IMPL_ORDER_ID = "implOrderId";
        /**
         * 执行单IdList字段名
         */
        public static final String IMPL_ORDER_IDS = "implOrderIdList";
        /**
         * 商品ID字段名
         */
        public static final String COMMODITY_ID = "commodityId";
        /**
         * 验收时间
         */
        public static final String INSP_TIME = "inspTime";
        /**
         * 商品编码字段名
         */
        public static final String COMMODITY_CODE = "commodityCode";
        /**
         * 商品名称字段名
         */
        public static final String COMMODITY_NAME = "commodityName";
        /**
         * 商品类型id
         */
        public static final String COMMODITY_TYPE_ID = "commodityTypeId";
        /**
         * 总销售金额
         */
        public static final String TOTAL_SALE_FEE = "totalSaleFee";
        /**
         * 总销售金额(long)
         */
        public static final String TOTAL_SALE_FEE_LONG = "totalSaleFeeLong";

        /**
         * 总采购金额(long)
         */
        public static final String TOTAL_PURCHASE_FEE_LONG = "totalPurchaseFeeLong";
        /**
         * 下单系统
         */
        public static final String ORD_SYSTEM = "orderSystem";
        /**
         * 收获信息
         */
        public static final String LOGISTICS_RELA = "orderLogisticsRela";
        /**
         * 销售单明细
         */
        public static final String UOC_SALE_ORDER_ITEM = "saleOrderItems";
        /**
         * 售后单明细
         */
        public static final String UOC_AF_ORDER_ITEM = "afOrderItemBoList";
        /**
         * 商品ID字段名
         */
        public static final String SKU_ID = "skuId";
        /**
         * 单品编码
         */
        public static final String SKU_CODE = "skuCode";
        /**
         * 外部商品ID
         */
        public static final String SKU_EXT_SKU_ID = "skuExtSkuId";
        /**
         * 商品名称字段名
         */
        public static final String SKU_NAME = "skuName";
        /**
         * 有无退货
         */
        public static final String IS_RETURN_FLAG = "isReturnFlag";
        /**
         * 有无退货翻译
         */
        public static final String IS_RETURN_FLAG_STR = "isReturnFlagStr";
        /**
         * 计量单位
         */
        public static final String UNIT_NAME = "unitName";
        /**
         * 下单人ID
         */
        public static final String ORDER_CREATE_OPER_ID = "orderCreateOperId";
        /**
         * 下单人名称
         */
        public static final String ORDER_CREATE_OPER_NAME = "orderCreateOperName";
        /**
         * 商品是否可以评价
         */
        public static final String EVA_SIGN = "evaSign";
        /**
         * 下单人账号
         */
        public static final String ORDER_CREATE_LOGIN_NAME = "orderCreateLoginName";
        /**
         * 下单时间
         */
        public static final String ORDER_CREATE_TIME = "orderCreateTime";
        /**
         * 下单人用户类型
         */
        public static final String ORDER_CREATE_USER_TYPE = "orderCreateUserType";
        /**
         * 下单人用户类型翻译
         */
        public static final String ORDER_CREATE_USER_TYPE_STR = "orderCreateUserTypeStr";
        /**
         * 是否存在未完结售后服务单
         */
        public static final String IS_AF_FINISH = "isExistFinishAfOrderExt";
        /**
         * 是否存在未完结售后服务单翻译
         */
        public static final String IS_AF_FINISH_STR = "isExistFinishAfOrderExtStr";

        /**
         * 是否能否发起 状态变更标识
         */
        public static final String ENABLE_STAT_CHNG = "enableStatChng";
        /**
         * 到货登记附件信息
         */
        public static final String ARRIVE_REGIST_ACCESSORY = "arriveRegistAccessoryList";
        /**
         * SKU品牌ID
         */
        public static final String SKU_BRAND_ID = "skuBrandId";
        /**
         * SKU品牌名称
         */
        public static final String SKU_BRAND_NAME = "skuBrandName";
        /**
         * 明细采购单价
         */
        public static final String PUR_PRICE = "purPrice";
        /**
         * 明细采购单价
         */
        public static final String PURCHASE_PRICE = "purchasePrice";
        /**
         * 明细采购数量
         */
        public static final String PUR_COUNT = "purchaseCount";
        /**
         * 明细销售单价
         */
        public static final String SALE_PRICE = "salePrice";
        /**
         * 采购金额
         */
        public static final String PUR_FEE = "purFee";
        /**
         * 销售金额
         */
        public static final String SALE_FEE = "saleFee";
        /**
         * 采购数量
         */
        public static final String PURCHASE_COUNT = "purchaseCount";
        /**
         * 验收销售金额
         */
        public static final String INSP_SALE_MONEY = "inspSaleMoney";
        /**
         * 验收采购金额
         */
        public static final String INSP_PUR_MONEY = "inspPurchaseMoney";
        /**
         * 审批单数据
         */
        public static final String AUDIT_ORDER = "auditOrderBoList";
        /**
         * 整单审批单数据
         */
        public static final String WHOLE_AUDIT_ORDER = "wholeAuditOrderBoList";
        /**
         * 业务流程实例
         */
        public static final String BUSI_PROC_INST = "busiProcInstId";
        /**
         * 业务任务实例
         */
        public static final String BUSI_TASK_INST = "busiTaskList";
        /**
         * 业务环节编码
         */
        public static final String BUSI_PROC_STATE = "busiProcStateList";

        /**
         * 变更单业务流程实例
         */
        public static final String CHNG_BUSI_PROC_INST = "chngBusiProcInstId";
        /**
         * 变更单业务任务实例
         */
        public static final String CHNG_BUSI_TASK_INST = "chngBusiTaskList";
        /**
         * 变更orderId
         */
        public static final String CHNG_ORDER_ID = "chngOrderId";

        /**
         * 变更单退付款类型：1付款，2退款
         */
        public static final String ADD_OR_SUBTRACT_TYPE = "addOrSubtractType";
        /**
         * 审批流程实例 (整单)
         */
        public static final String AUDIT_PROC_INST = "auditProcInstId";

        /**
         * 调价审批流程实例
         */
        public static final String PRICE_AUDIT_PROC_INST = "priceAuditProcInstId";
        /**
         * 审批状态
         */
        public static final String AUDIT_STATUS = "auditOrderStatus";
        /**
         * 审批状态(翻译)
         */
        public static final String AUDIT_STATUS_STR = "auditStatusStr";
        /**
         * 审批流程实例 (销售单)
         */
        public static final String AUDIT_SALE_PROC_INST = "auditSaleOrderProcInstId";
        /**
         * 审批流程实例 (整单)
         */
        public static final String AUDIT_PROC_DEF_ID = "auditProcDefId";
        /**
         * 审批流程实例 (销售单)
         */
        public static final String AUDIT_SALE_PROC_DEF_ID = "auditSaleOrderProcDefId";
        /**
         * 审批任务实例 (整单)
         */
        public static final String AUDIT_TASK_INST = "auditTaskList";
        /**
         * 审批任务实例 (销售单)
         */
        public static final String AUDIT_SALE_TASK_INST = "auditSaleOrderTaskList";
        /**
         * 审批环节编码 (整单)
         */
        public static final String AUDIT_PROC_STATE = "auditProcStateList";

        /**
         * 审批环节编码（销售单）
         */
        public static final String AUDIT_SALE_PROC_STATE = "auditSaleOrderProcStateList";
        /**
         * 订单金额
         */
        public static final String ORDER_TOTAL = "orderTotal";
        /**
         * 订单状态
         */
        public static final String ORDER_STATE = "orderState";
        /**
         * S
         * 订单状态翻译
         */
        public static final String ORDER_STATE_STR = "orderStateStr";
        /**
         * 是否有服务单
         */
        public static final String AFTER_FLAG = "afterFlag";
        /**
         * 是否有服务单详情
         */
        public static final String AFTER_FLAG_DETAIL = "afterDetailFlag";
        /**
         * 显示服务单
         */
        public static final String AFTER_ORDER_FLAG = "afterOrderFlag";
        /**
         * 是否有变更单
         */
        public static final String CHANGE_FLAG = "changeFlag";
        /**
         * 变更对象集合
         */
        public static final String CHNG_ORDER_OBJ_LIST = "uocChngOrderObjList";
        /**
         * 是否有取消申请
         */
        public static final String CANCEL_APPLY_FLAG = "cancelApplyFlag";
        /**
         * 取消申请单变更Id（最新的一个）
         */
        public static final String CANCEL_APPLY_CHNG_ORDER_ID = "cancelApplyChngOrderId";
        /**
         * 调价变更id
         */
        public static final String PRICE_CHNG_ORDER_ID = "priceChngOrderId";
        /**
         * 是否是调价销售单
         */
        public static final String ADJUST_ALREADY_FLAG = "adjustAlreadyFlag";
        /**
         * 调价变更金额
         */
        public static final String PRICE_CHNG_FEE = "priceChngFee";
        /**
         * 是否京东厂直订单
         */
        public static final String JDCZ_FLAG = "jdczFlag";
        /**
         * 评价状态
         */
        public static final String EVALUATE_STATE = "evaluateState";
        /**
         * 售后标识 1售后中 2有售后
         */
        public static final String AFTERORDERFLAG = "afterOrderFlag";
        /**
         * 结算应付ID
         */
        public static final String FSC_SHOULD_PAY_ID = "fscShouldPayId";
        /**
         * 应付金额
         */
        public static final String SHOULD_PAY_AMOUNT = "shouldPayAmount";
        /**
         * 已付金额
         */
        public static final String PAID_AMOUNT = "paidAmount";
        /**
         * 付款方Id
         */
        public static final String PAYER_ID = "payerId";
        /**
         * 应付类型
         */
        public static final String SHOULD_PAY_TYPE = "shouldPayType";
        /**
         * 应付类型翻译
         */
        public static final String SHOULD_PAY_TYPE_STR = "shouldPayTypeStr";
        /**
         * 订单应付集合
         */
        public static final String ORD_SHOULD_PAY_LIST = "orderShouldPayList";
        /**
         * 订单阶段
         */
        public static final String ORD_STAGE = "orderStage";
        /**
         * 预算模式
         */
        public static final String BUDGET_MODEL = "budgetModelCode";
        /**
         * 预算模式名称
         */
        public static final String BUDGET_MODEL_NAME = "budgetModelName";
        /**
         * 订单阶段翻译
         */
        public static final String ORD_STAGE_STR = "orderStageStr";
        /**
         * 评价状态翻译
         */
        public static final String EVALUATE_STATE_STR = "evaluateStateStr";

        /**
         * 一级类目
         */
        public static final String L1_CATALOG = "l1Catalog";

        /**
         * 二级类目
         */
        public static final String L2_CATALOG = "l2Catalog";

        /**
         * 三级类目
         */
        public static final String L3_CATALOG = "l3Catalog";

        /**
         * 一级类目名称
         */
        public static final String L1_CATALOG_NAME = "l1CatalogName";

        /**
         * 二级类目名称
         */
        public static final String L2_CATALOG_NAME = "l2CatalogName";

        /**
         * 三级类目名称
         */
        public static final String L3_CATALOG_NAME = "l3CatalogName";

        /**
         * sku单品主图url
         */
        public static final String SKU_MAIN_PIC_URL = "skuMainPicUrl";

        /**
         * sku物料id
         */
        public static final String SKU_MATERIAL_ID = "skuMaterialId";
        /**
         * sku物料编码
         */
        public static final String SKU_MATERIAL_CODE = "skuMaterialCode";

        /**
         * sku物料名称
         */
        public static final String SKU_MATERIAL_NAME = "skuMaterialName";

        /**
         * sku物料类型编码
         */
        public static final String SKU_MATERIAL_TYPE_ID = "skuMaterialTypeId";

        /**
         * sku物料类型名称
         */
        public static final String SKU_MATERIAL_TYPE_NAME = "skuMaterialTypeName";

        /**
         * 型号
         */
        public static final String MODEL = "model";

        /**
         * 规格
         */
        public static final String SPEC = "spec";

        /**
         * 税金
         */
        public static final String TAX_PRICE = "taxPrice";

        /**
         * 税率
         */
        public static final String TAX = "tax";

        /**
         * 税务编码
         */
        public static final String TAX_ID = "taxId";

        /**
         * 供应商名称
         */
        public static final String SUP_NAME = "supName";

        /**
         * 供应商编码
         */
        public static final String SUP_NO = "supNo";

        /**
         * 供应商ID
         */
        public static final String SUP_ID = "supId";

        /**
         * 供应商ID
         */
        public static final String SUPPLIER_ID = "supplierId";

        /**
         * 店铺ID
         */
        public static final String SUPPLIER_SHOP_ID = "supplierShopId";

        /**
         * 运营单位ID
         */
        public static final String PRO_ID = "proId";

        /**
         * 运营单位名称
         */
        public static final String PRO_NAME = "proName";

        /**
         * 采购方账套id
         */
        public static final String PUR_ACCOUNT = "purAccount";

        /**
         * 采购方账套名称
         */
        public static final String PUR_ACCOUNT_NAME = "purAccountName";

        /**
         * 售后数量
         */
        public static final String RETURN_COUNT = "returnCount";
        /**
         * 售后数量翻译
         */
        public static final String RETURN_COUNT_STR = "returnCountStr";

        /**
         * 发货数量
         */
        public static final String SEND_COUNT = "sendCount";

        /**
         * 可售后数量
         */
        public static final String AVAILABLE_AF_SERV_COUNT = "availableAfServCount";

        /**
         * 发货单状态翻译 字段
         */
        public static final String SHIP_ORDER_STATE_STR = "shipOrderStateStr";

        /**
         * 验收单状态翻译 字段
         */
        public static final String INSP_ORDER_STATE_STR = "inspOrderStateStr";
        /**
         * 采购方公司ID
         */
        public static final String PUR_COMPANY_ID = "purCompanyId";
        /**
         * 采购方公司名称
         */
        public static final String PUR_COMPANY_NAME = "purCompanyName";
        /**
         * 采购方公司编码
         */
        public static final String PUR_COMPANY_NO = "purCompanyNo";
        /**
         * 采购方机构ID
         */
        public static final String PUR_ORG_ID = "purOrgId";
        /**
         * 销售单ID
         */
        public static final String SALE_ORD_ID = "saleOrderId";
        /**
         * 服务单ID
         */
        public static final String AF_ORD_ID = "afOrderId";
        /**
         * 采购方机构名称
         */
        public static final String PUR_ORG_NAME = "purOrgName";
        /**
         * 采购方机构编码
         */
        public static final String PUR_ORG_NO = "purOrgNo";
        /**
         * 验收采购金额
         */
        public static final String INSP_ORDER_ACCESSORY = "inspOrderAccessoryList";
        /**
         * 采购方机构树
         */
        public static final String PUR_ORG_PATH = "purOrgPath";
        /**
         * 供应方机构树
         */
        public static final String SUP_ORG_PATH = "supOrgPath";
        /**
         * 运营方机构树
         */
        public static final String PRO_ORG_PATH = "proOrgPath";


        /**
         * 采购方用户
         */
        public static final String PUR_USER_ID = "purUserId";
        /**
         * 外部电商ID
         */
        public static final String OUT_ORD_ID = "outOrderId";
        /**
         * 供应商订单类型
         */
        public static final String VENDOR_ORD_TYPE = "vendorOrderType";
        /**
         * 供应商订单类型翻译
         */
        public static final String VENDOR_ORD_TYPE_STR = "vendorOrderTypeStr";
        /**
         * 验收人工号
         */
        public static final String INSP_OPER_ID = "inspOperId";
        /**
         * 验收人名称
         */
        public static final String INSP_OPER_NAME = "inspOperName";
        /**
         * 是否可以做到货登记
         */
        public static final String IS_ARRIVAL_REGIST = "isArrivalRegist";
        /**
         * 发货单状态
         */
        public static final String SHIP_ORDER_STATE = "shipOrderState";
        /**
         * 发货单状态
         */
        public static final String SHIP_ORDER_TACHE_CODE = "shipOrderTacheCode";
        /**
         * 是否可以做到货登记翻译
         */
        public static final String IS_ARRIVAL_REGIST_STR = "isArrivalRegistStr";
        /**
         * 销售单信息
         */
        public static final String SALE_ORDER_INFO = "saleOrderInfo";
        /**
         * 销售单状态
         */
        public static final String SALE_ORD_STATE = "saleOrderState";
        /**
         * 销售单状态翻译
         */
        public static final String SALE_ORD_STATE_STR = "saleOrderStateStr";
        /**
         * 供应商是否确认
         */
        public static final String IS_SUPPLIER_CONFIRM = "isSupplierConfirmFlag";
        /**
         * 环节状态
         */
        public static final String SALE_ORD_TACHE_STATE = "saleOrdTacheState";
        /**
         * 执行单状态
         */
        public static final String IMPL_ORD_STATE = "implOrderState";
        /**
         * 执行单状态翻译
         */
        public static final String IMPL_ORD_STATE_STR = "implOrderStateStr";
        /**
         * 执行单类型
         */
        public static final String IMPL_ORD_TYPE = "implOrderType";
        /**
         * 执行单类型翻译
         */
        public static final String IMPL_ORD_TYPE_STR = "implOrderTypeStr";
        /**
         * 开票标识
         */
        public static final String INVOICE_TAG = "invoiceTag";
        /**
         * 开票标识翻译
         */
        public static final String INVOICE_TAG_STR = "invoiceTagStr";
        /**
         * 流转状态
         */
        public static final String PROC_STATE = "procState";
        /**
         * 流转状态翻译
         */
        public static final String PROC_STATE_STR = "procStateStr";
        /**
         * 对账状态
         */
        public static final String CHECK_STATE = "checkState";
        /**
         * 对账状态翻译
         */
        public static final String CHECK_STATE_STR = "checkStateStr";
        /**
         * 订单来源
         */
        public static final String ORD_SOURCE = "orderSource";
        /**
         * 订单来源翻译
         */
        public static final String ORD_SOURCE_STR = "orderSourceStr";
        /**
         * 付款方式
         */
        public static final String PAY_TYPE = "payType";
        /**
         * 付款方式 运营侧
         */
        public static final String PRO_PAY_TYPE = "proPayType";
        /**
         * 收款方ID
         */
        public static final String PAYEE_ID = "payeeId";
        /**
         * 应付创建时间
         */
        public static final String SHOULD_PAY_CREATE_TIME = "shouldPayCreateTime";
        /**
         * 收款方名称
         */
        public static final String PAYEE_NAME = "payeeName";
        /**
         * 支付信息
         */
        public static final String ORD_PAY_CONFIG = "saleOrderPayConfList";
        /**
         * 付款方式翻译
         */
        public static final String PAY_TYPE_STR = "payTypeStr";
        /**
         * 支付状态
         */
        public static final String PAY_STATE = "payState";
        /**
         * 支付状态翻译
         */
        public static final String PAY_STATE_STR = "payStateStr";
        /**
         * 竣工标志
         */
        public static final String FINISH_FLAG = "finishFlag";
        /**
         * 竣工标志翻译
         */
        public static final String FINISH_FLAG_STR = "finishFlagStr";
        /**
         * 撤单标志
         */
        public static final String CANCEL_FLAG = "cancelFlag";
        /**
         * 撤单标志翻译
         */
        public static final String CANCEL_FLAG_STR = "cancelFlagStr";
        /**
         * 结算模式
         */
        public static final String MODEL_SETTLE = "modelSettle";
        /**
         * 结算模式翻译
         */
        public static final String MODEL_SETTLE_STR = "modelSettleStr";
        /**
         * 交易模式
         */
        public static final String TRADE_MODE = "tradeMode";
        /**
         * 交易模式翻译
         */
        public static final String TRADE_MODE_STR = "tradeModeStr";
        /**
         * 结算计量单位
         */
        public static final String SETTLE_UNIT = "settleUnit";
        /**
         * 采购类别
         */
        public static final String PURCHASE_TYPE = "purchaseType";
        /**
         * 采购类别翻译
         */
        public static final String PURCHASE_TYPE_STR = "purchaseTypeStr";
        /**
         * 采购模式
         */
        public static final String PURCHASE_MODE = "purchaseMode";
        /**
         * 采购模式翻译
         */
        public static final String PURCHASE_MODE_STR = "purchaseModeStr";
        /**
         * 单据号
         */
        public static final String ORDER_NO = "orderNo";
        /**
         * 单据id
         */
        public static final String ORDER_ID = "orderId";
        /**
         * 任务名称
         */
        public static final String TASK_NAME = "taskName";
        /**
         * 流程名称
         */
        public static final String PROC_NAME = "procName";
        /**
         * 对象类型
         */
        public static final String OBJ_TYPE_STR = "objTypeStr";
        /**
         * 对象名称
         */
        public static final String OBJ_NAME = "objName";
        /**
         * 对象名称
         */
        public static final String PROC_INST_ID = "procInstId";
        /**
         * 协议模式
         */
        public static final String AGR_CODE = "agreementCode";
        /**
         * 协议模式翻译
         */
        public static final String AGR_CODE_STR = "agreementCodeStr";
        /**
         * 平台协议编号
         */
        public static final String PLA_AGR_CODE = "plaAgreementCode";
        /**
         * 协议名称
         */
        public static final String AGR_NAME = "agreementName";
        /**
         * 协议ID
         */
        public static final String AGR_ID = "agreementId";
        /**
         * 关联id
         */
        public static final String REL_ID = "relId";
        /**
         * 关联对象id
         */
        public static final String OBJ_ID = "objId";
        /**
         * 铺货单位id
         */
        public static final String DISTRIBUTION_ID = "distributionId";
        /**
         * 铺货单位name
         */
        public static final String DISTRIBUTION_NAME = "distributionName";
        /**
         * 关联对象类型
         */
        public static final String OBJ_TYPE = "objType";
        /**
         * 关联类型
         */
        public static final String REL_TYPE = "relType";
        /**
         * 关联状态和类型：状态在前,分隔
         */
        public static final String REL_INFO = "relInfo";
        /**
         * 关联信息
         */
        public static final String FSC_REL_INFO_BOS = "fscRelInfoBos";
        /**
         * 关联类型翻译
         */
        public static final String REL_TYPE_STR = "relTypeStr";
        /**
         * 关联对象状态
         */
        public static final String REL_STATUS = "relStatus";
        /**
         * 关联对象状态翻译
         */
        public static final String REL_STATUS_STR = "relStatusStr";
        /**
         * 成交服务费金额
         */
        public static final String SER_PRICE_MONEY = "serPriceMoney";
        /**
         * 成交服务费生成规则
         */
        public static final String SUP_NO_RULE = "supNoRule";
        /**
         * 成交服务费 订单明细
         */
        public static final String ORDER_ITEM = "orderItem";
        /**
         * 成交服务费 订单明细商品数量
         */
        public static final String ITEM_COUNT = "itemCount";
        /**
         * 销售单明细id
         */
        public static final String SALE_ORDER_ITEM_ID = "saleOrderItemId";
        /**
         * 验收数量
         */
        public static final String INSP_COUNT = "inspCount";
        /**
         * 是否收取月度成交服务费 1 收取 0 不收取
         */
        public static final String MONTH_SERVICE_FEE = "monthServiceFee";
        /**
         * 成交服务费费率
         */
        public static final String SERVICE_FEE_RATE = "serviceFeeRate";
        /**
         * 违约金额比例
         */
        public static final String PAY_BREAK_SCALE = "payBreakScale";
        /**
         * 违约金额比例 运营侧
         */
        public static final String PRO_PAY_BREAK_SCALE = "proPayBreakScale";
        /**
         * 账期支付结算规则
         */
        public static final String PAY_RULE = "payRule";
        /**
         * 账期支付结算规则 运营侧
         */
        public static final String PRO_PAY_RULE = "proPayRule";
        /**
         * 账期日结算订单规则
         */
        public static final String PAY_ACCOUNT_DAY_RULE = "payAccountDayRule";
        /**
         * 账期日结算订单规则 运营侧
         */
        public static final String PRO_PAY_ACCOUNT_DAY_RULE = "proPayAccountDayRule";
        /**
         * 指定账期日
         */
        public static final String PAY_ACCOUNT_DAY = "payAccountDay";
        /**
         * 指定账期日 运营侧
         */
        public static final String PRO_PAY_ACCOUNT_DAY = "proPayAccountDay";
        /**
         * 账期起算特定业务节点
         */
        public static final String PAY_NODE_RULE = "payNodeRule";
        /**
         * 账期起算特定业务节点 运营侧
         */
        public static final String PRO_PAY_NODE_RULE = "proPayNodeRule";
        /**
         * 账期支付结算规则翻译
         */
        public static final String PAY_RULE_STR = "payRuleStr";
        /**
         * 账期支付结算规则翻译 运营侧
         */
        public static final String PRO_PAY_RULE_STR = "proPayRuleStr";
        /**
         * 账期日结算订单规则翻译
         */
        public static final String PAY_ACCOUNT_DAY_RULE_STR = "payAccountDayRuleStr";
        /**
         * 账期日结算订单规则翻译 运营侧
         */
        public static final String PRO_PAY_ACCOUNT_DAY_RULE_STR = "proPayAccountDayRuleStr";
        /**
         * 账期起算特定业务节点翻译 运营侧
         */
        public static final String PRO_PAY_NODE_RULE_STR = "proPayNodeRuleStr";
        /**
         * 账期起算特定业务节点翻译
         */
        public static final String PAY_NODE_RULE_STR = "payNodeRuleStr";
        /**
         * 账期天数
         */
        public static final String PAYMENT_DAYS = "paymentDays";
        /**
         * 账期天数 运营侧
         */
        public static final String PRO_PAYMENT_DAYS = "proPaymentDays";
        /**
         * 成交服务费单据时间
         */
        public static final String OBJ_TIME = "objTime";
        /**
         * 支付类型
         */
        public static final String PAY_MOD = "payMod";
        /**
         * 支付类型翻译
         */
        public static final String PAY_MOD_STR = "payModStr";
        /**
         * 实付金额
         */
        public static final String USED_FEE = "usedFee";
        /**
         * 更新时间
         */
        public static final String UPDATE_TIME = "updateTime";
        /**
         * 取消时间
         */
        public static final String CANCEL_TIME = "cancelTime";
        /**
         * 更新工号
         */
        public static final String UPDATE_OPER_ID = "updateOperId";
        /**
         * 撤单原因
         */
        public static final String CANCEL_REASON = "cancelReason";
        /**
         * 未支付状态应付订单列表
         */
        public static final String ORDER_SHOULD_PAY_LIST = "orderShouldPayList";

        /**
         * 调价采购金额
         */
        public static final String ADJUST_PURCHASE_PRICE = "adjustPurchasePrice";

        /**
         * 调价销售金额
         */
        public static final String ADJUST_SALE_PRICE = "adjustSalePrice";
        /**
         * 已办任务List
         */
        public static final String DONE_TASK_TACHE_CODE = "doneTaskTacheCode";

        /**
         * 是否维护发运信息翻译
         */
        public static final String WAYBILLFLAGSTR = "waybillFlagStr";
        /**
         * 购买人/公司
         */
        public static final String BUYER_NAME = "buyerName";
        /**
         * 订单发票
         */
        public static final String INVOICE = "invoice";
        /**
         * 订单核实信息
         */
        public static final String VERIFY_INFO = "verifyInfo";
        /**
         * 是否调价
         */
        public static final String IS_ADJUST_PRICE = "isAdjustPrice";
        /**
         * 订单号-销售单号 用来同时匹配
         */
        public static final String ORDER_NO_AND_SALE_ORDER_NO = "orderNoAndSaleOrderNo";
        /**
         * 验收单存在变更单标识
         */
        public static final String INSP_CHNG_FLAG = "inspChngFlag";
        /**
         * 该发货单是否存在在途变更标识
         */
        public static final String PROGRESS_CHNG_FLAG = "progressChngFlag";
        /**
         * 收货人地址信息
         */
        public static final String RECEIVER_ADDRESS_BO = "receiverAddressBO";

        /**
         * 计量单位位数
         */
        public static final String UNIT_DIGIT = "unitDigit";
        /**
         * 退货时间，空代表不支持
         */
        public static final String REJECT_ALLOW_DATE = "rejectAllowDate";
        /**
         * 换货时间，空代表不支持
         */
        public static final String EXCHANGE_ALLOW_DATE = "exchangeAllowDate";
        /**
         * 维修时间，空代表不支持
         */
        public static final String MAINTAIN_ALLOW_DATE = "maintainAllowDate";

        /**
         * 电商预计送达时间
         */
        public static final String PRE_OFFER_TIME = "arrivalTime";

        /**
         * 验收来源，1it工作台，0商城
         */
        public static final String ACCEPT_SOURCE = "acceptSource";

        /**
         * 验收来源字符串
         */
        public static final String ACCEPT_SOURCE_STR = "acceptSourceStr";

    }

    /**
     * 业务类型
     */
    public static final class BUSI_TYPE {
        /**
         * 异常变更 数量变更 1
         */
        public static final Integer NUM = 1;
        /**
         * 订单调价：销售价调价 2
         */
        public static final Integer PRICE_CHG = 2;
        /**
         * 销售单取消申请 3
         */
        public static final Integer SALE_ORDER_CANCEL = 3;
        /**
         * 异常变更：状态变更 4
         */
        public static final Integer STATE = 4;
        /**
         * 订单调价：采购价调价 5
         */
        public static final Integer STATE_FIVE = 5;
    }

    /**
     * 订单类型
     */
    public static final class ORD_TYPE {
        /**
         * 1 父订单或者子订单
         */
        public static final Integer PORD_OR_CORD = 1;
        /**
         * 2 发货单
         */
        public static final Integer SHIP_ORD = 2;
    }


    /**
     * http请求出参字段
     */
    public static final class RESPONSE_PARAMS {
        /**
         * 配送信息
         */
        public static final String ORDER_TRACK = "orderTrack";
        /**
         * 订单编号
         */
        public static final String ORDER_ID = "orderId";
        /**
         * 运单编码
         */
        public static final String WAY_BILL_CODE = "waybillCode";
        /**
         * 物流公司
         */
        public static final String CARRIER = "carrier";
        /**
         * 运单号
         */
        public static final String DELIVERY_ORDER_ID = "deliveryOrderId";

    }

    /**
     * 纵向扩展属性 操作类型  1新增 2更新
     */
    public static final class MAP_OP_FLAG {
        /**
         * 新增
         */
        public static final Integer ADD = 1;

        /**
         * 更新
         */
        public static final Integer UPDATE = 2;
    }

    /**
     * 是否已关闭尾差 1是 0否
     */
    public static final class CLOSE_PENNY_DIFF {
        /**
         * 是
         */
        public static final Integer YES = 1;

        /**
         * 否
         */
        public static final Integer NO = 0;
    }

    /**
     * 是否调价 1是 0否
     */
    public static final class ADJUST_FLAG {
        /**
         * 是
         */
        public static final Integer YES = 1;

        /**
         * 否
         */
        public static final Integer NO = 0;
    }

    /**
     * 调价模式：0：不调价，1：事前调价，2：事中调价
     */
    public static final class ADJUST_PRICE {
        /**
         * 不调价
         */
        public static final Integer NO_ADJUST = 0;
        /**
         * 事前调价
         */
        public static final Integer BEFORE_ADJUST = 1;
        /**
         * 事中调价
         */
        public static final Integer MIDDLE_ADJUST = 2;
    }

    /**
     * 审批对象业务类型
     */
    public static final class OBJ_BUSI_TYPE {
        /**
         * 调价
         */
        public static final Integer PRICE = 1;
        /**
         * 订单审批
         */
        public static final Integer ORDER = 2;
    }

    /**
     * 审批日志finish类型
     */
    public static final class AUDIT_LOG_FINISH {
        /**
         * 是
         */
        public static final Integer YES = 1;
        /**
         * 否
         */
        public static final Integer NO = 0;
    }

    /**
     * 返回单据类型，
     */
    public static final class OBJECT_TYPE {
        /**
         * 1：采购订单
         */
        public static final Integer ORDER = 1;
        /**
         * 2：通用结算单
         */
        public static final Integer COMMON = 2;
        /**
         * 3：成交服务费结算单
         */
        public static final Integer SERVICE = 3;
        /**
         * 4：平台使用费结算单
         */
        public static final Integer PLATFORM = 4;
        /**
         * 5：销售订单
         */
        public static final Integer SALE = 5;
        /**
         * 6：验收单
         */
        public static final Integer CHECK = 6;
        /**
         * 7：发货单
         */
        public static final Integer GOODS = 7;

    }

    /**
     * 审批
     */
    public static final class AUDIT_TYPE {
        public static final String P_CODE = "UOC_AUDIT_TYPE";
        /**
         * 通过
         */
        public static final Integer PASS = 0;
        /**
         * 驳回
         */
        public static final Integer REFUSE = 1;
        /**
         * 提交
         */
        public static final Integer CREATE = 2;
    }


    /**
     * 取货服务类型
     */
    public static final class AFTERORDER_PICKWARETYPE {
        /**
         * 上门取件
         */
        public static final Integer UPDOORPICK = 1;

        /**
         * 客户发货
         */
        public static final Integer CUSTOMSHIP = 2;

        /**
         * 客户送货
         */
        public static final Integer CUSTOMSEND = 3;
    }

    /**
     * 售后服务类型
     */
    public static final class AFTERORDER_SERVTYPE {
        /**
         * 退货
         */
        public static final Integer RETURN = 10;

        /**
         * 换货
         */
        public static final Integer CHANGE = 20;

        /**
         * 维修
         */
        public static final Integer FIX = 30;
    }

    /**
     * 非正常完结环节标记
     */
    public static final class FINISH_OTHER_TAG {
        /**
         * -F 和环节编码拼接，生成结束的环节代办
         */
        public static final String FINISH = "-F";
    }

    /**
     * 下单成功收取成交服务费
     */
    public static final String CREATE_ORDER_CHARGE_SERVICE_FEE = "1";

    /**
     * 时效配置编码
     */
    public static final String EFFECTIVE_CODE = "EFFECTIVE_CODE";
    /**
     * 来源编码
     */
    public static final String SOURCE_CODE = "SOURCE_CODE";

    /**
     * 来源编码
     */
    public static final class SourceCode {
        /**
         * 系统
         */
        public static final String SYSTEM = "0";
    }

    /**
     * 应用单位编码
     */
    public static final class ApplicationUnitNo {
        /**
         * 集团
         */
        public static final String GROUP = "0";
    }

    /**
     * 时效配置编码
     */
    public static final class EffectiveCode {
        /**
         * 电商预占库存时限
         */
        public static final String E_COMMERCE_INVENTORY_TIME_LIMIT = "1";
        /**
         * 订单确认付款时限
         */
        public static final String ORDER_CONFIRMATION_PAYMENT_TIME_LIMIT = "2";
        /**
         * 自动到货确认时限
         */
        public static final String AUTOMATIC_ARRIVAL_CONFIRMATION_TIME_LIMIT = "3";
        /**
         * 自动验收时限
         */
        public static final String AUTOMATIC_ACCEPTANCE_TIME_LIMIT = "4";
        /**
         * 订单异常变更时限
         */
        public static final String TIME_LIMIT_FOR_ABNORMAL_ORDER_CHANGES = "5";

        /**
         * 账期支付付款时间
         */
        public static final String PAYMENT_PERIOD = "11";
    }

    /**
     * 超验业务类型
     */
    public static final String INSPECTION_BUSI_TYPE = "INSPECTION_BUSI_TYPE";
    /**
     * 超验类型
     */
    public static final String INSPECTION_TYPE = "INSPECTION_TYPE";
    /**
     * 超验类型：按全品类统一设置
     */
    public static final Integer INSPECTION_TYPE_ALL = 0;

    /**
     * 超验类型：按不同商品类型设置
     */
    public static final Integer INSPECTION_TYPE_COMMODITY = 1;

    /**
     * 超验-业务类型：协议
     */
    public static final Integer INSPECTION_BUSI_TYPE_AGE = 1;

    /**
     * 超验-业务类型：无协议
     */
    public static final Integer INSPECTION_BUSI_TYPE_NO_AGE = 3;

    /**
     * 收取成交服务费
     */
    public static final String CHARGE_MONTH_SERVICE_FEE = "1";
    /**
     * 收取成交服务费节点 下单时收取
     */
    public static final String MONTH_SERVICE_NODE = "1";
    /**
     * 收取成交服务费节点
     */
    public static final String MONTH_SERVICE_NODE_PARAM = "monthReceiveNode";

    /**
     * es同步flag
     */
    public static final class ES_SYNC_OP_FLAG {
        /**
         * 1保存数据(新增/覆盖)
         */
        public static final Integer SAVE = 1;
        /**
         * 2部分字段更新数据(by id)
         */
        public static final Integer UPDATE = 2;
        /**
         * 3删除(by id)
         */
        public static final Integer DELETE = 3;
    }

    /**
     * 发货单竣工标识
     */
    public static final class SHIP_ORDER_FINISH_FLAG {
        /**
         * 1竣工
         */
        public static final Integer FINISH = 1;
        /**
         * 0 在途
         */
        public static final Integer NOT_FINISH = 0;

    }

    /**
     * 下单结果
     */
    public static final class CREATED_RESULT {
        /**
         * 下单处理中
         */
        public static final Integer PROCESSING = 0;
        /**
         * 下单成功
         */
        public static final Integer SUCCESS = 1;
        /**
         * 下单失败
         */
        public static final Integer FAILED = 2;
    }

    /**
     * 售后单同步销售单售后字段
     */
    public static final class SALEORDER_SYN_AFTERORDER {
        /**
         * 售后取消
         */
        public static final Integer CANCEL = 0;
        /**
         * 售后中
         */
        public static final Integer ING = 1;
        /**
         * 有售后
         */
        public static final Integer DONE = 2;
    }

    /**
     * 订单是否审批配置
     */
    public static final class CONF_AUDIT_FLAG {
        /**
         * 1 是
         */
        public static final Integer YES = 1;
        /**
         * 0 否
         */
        public static final Integer NO = 0;
    }


    /**
     * 待办配置标记
     */
    public static final class WATITDONE_FLAG {

        public static final Integer ON = 1;

        public static final Integer OFF = 0;
    }

    /**
     * 订单审批方式 1整单审批 2拆单审批
     */
    public static final class CONF_AUDIT_TYPE {
        /**
         * 1 整单审批
         */
        public static final Integer WHOLE = 1;
        /**
         * 2 拆单审批
         */
        public static final Integer SPLIT = 2;
    }

    /**
     * 订单系统属性
     */
    public static final class SYS_ATTR {
        /**
         * 系统
         */
        public static final String SYSTEM = "1";
        /**
         * 自定义
         */
        public static final String CUSTOMIZE = "2";
    }

    /**
     * 接单结果：1：确认 0：拒绝
     */
    public static final class CONFIRM_RESULT {
        /**
         * 确认
         */
        public static final Integer ACCEPT = 1;
        /**
         * 拒绝
         */
        public static final Integer REFUSE = 0;

        /**
         * 采购员拒单
         */
        public static final Integer PUR_REFUSE = 2;
    }


    /**
     * 应付类型1：账期应付：2：预付款应付；3：成交服务费应付；4：平台使用费应付；5：到货款应付；6：验收款应付；7：质保金应付
     */
    public static final class SHOULD_PAY_TYPE {
        /**
         * 1：账期应付
         */
        public static final Integer ACOUNT_DAY = 1;
        /**
         * 2：预付款应付
         */
        public static final Integer PRE_PAY = 2;
        /**
         * 3：成交服务费应付
         */
        public static final Integer SERVICE = 3;
        /**
         * 4：平台使用费应付
         */
        public static final Integer PLATFORM = 4;
        /**
         * 5：到货款应付
         */
        public static final Integer SHIP = 5;
        /**
         * 6：验收款应付
         */
        public static final Integer INSP = 6;
        /**
         * 7：质保金应付
         */
        public static final Integer GOODS = 7;

    }

    /**
     * （记录表）操作类型1 发起议价,2 议价单终止,3 供应商已报价,4. 重新议价,5. 下单成功
     */
    public static final class BARGAINING_OPER_TYPE {
        /**
         * 1：发起议价
         */
        public static final Integer CREATE = 1;
        /**
         * 2：议价单终止
         */
        public static final Integer CANCEL = 2;
        /**
         * 3：供应商已报价
         */
        public static final Integer QUOTATION = 3;
        /**
         * 4：重新议价
         */
        public static final Integer RE_QUOTATION = 4;
        /**
         * 5：下单成功
         */
        public static final Integer ORDER = 5;
    }

    /**
     * 议价单字段名常量
     */
    public static final class ES_BARGAINING_FIELD {
        /**
         * 议价单状态
         */
        public static final String BARGAINING_STATE = "bargainingState";
        /**
         * 议价单状态翻译
         */
        public static final String BARGAINING_STATE_STR = "bargainingStateStr";
    }
}


