package com.tydic.dyc.oc.service.bargaining;

import com.tydic.dyc.base.bo.BasePageRspBo;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 报价记录详情分页信息Bo
 */
@Data
public class UocBargainingItemPageBo extends BasePageRspBo implements Serializable {
    private static final long serialVersionUID = 621195808653038239L;


    /**
     * 议价单明细id
     */
    private Long bargainingItemId;
    /**
     * 议价单id
     */
    private Long bargainingId;
    /**
     * 单品ID
     */
    private String skuId;
    /**
     * 单品名称
     */
    private String skuName;
    /**
     * 外部单品ID
     */
    private String extSkuId;
    /**
     * 单品编码
     */
    private String skuCode;

    /**
     * 采购用途ID
     */
    private String purPurposeId;
    /**
     * 采购用途名称
     */
    private String purPurposeName;

    /**
     * 税率
     */
    private String tax;

    /**
     * 计量单位
     */
    private String unitName;
    /**
     * 结算计量单位
     */
    private String settleUnit;

    /**
     * sku单品主图url
     */
    private String skuMainPicUrl;
    /**
     * 采购金额
     */
    private BigDecimal purchasePrice;

    /**
     * 采购数量
     */
    private BigDecimal purchaseCount;

    /**
     * 采购金额小计
     */
    private BigDecimal purchaseFee;


    /**
     * 规格
     */
    private String spec;

    /**
     * 排序
     */
    private String orderBy;


    /**
     * 报价
     */
    private BigDecimal confirmedPrice;

    /**
     * 专属报价小计,报价*报价数量
     */
    private BigDecimal confirmedPriceSub;
    /**
     * 店铺ID
     */
    private String supplierShopId;
    /**
     * 店铺名称
     */
    private String supplierShopName;
    /**
     * 商品ID
     */
    private String commodityId;
    /**
     * 商品名称
     */
    private String commodityName;


}
