package com.tydic.dyc.oc.service.bargaining.bo;

import com.tydic.dyc.base.bo.BaseRspBo;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocQryQuotationDetailReqBo
 * 说明:
 * 时间:2023/9/19 14:16
 * 作者:Dum
 */
@Data
public class UocQryQuotationDetailRspBo extends BaseRspBo {
    /**
     * 报价单id
     */
    private Long quotationId;
    /**
     * 议价单id
     */
    private Long bargainingId;
    /**
     * 报价截止日期
     */
    private Date quotationExpiryTime;
    private Date quotationExpiryTimeStart;
    private Date quotationExpiryTimeEnd;
    /**
     * 报价轮次
     */
    private Integer quotationRound;
    /**
     * 议价前商品总金额
     */
    private BigDecimal totalOriginalPrice;
    /**
     * 报价总金额
     */
    private BigDecimal totalConfirmedPrice;
    /**
     * 节省金额
     */
    private BigDecimal savedPrice;
    /**
     * 总价折扣率
     */
    private BigDecimal totalDiscountRate;
    /**
     * 报价状态
     0未报价
     1已报价
     2: 多轮报价中
     */
    private String quotationStatus;
    /**
     * 报价人ID
     */
    private Long quotationOperId;
    /**
     * 报价人姓名
     */
    private String quotationOperName;
    /**
     * 报价时间
     */
    private Date quotationTime;
    private Date quotationTimeStart;
    private Date quotationTimeEnd;
    /**
     * 发起人id
     */
    private Long createOperId;
    /**
     * 发起人姓名
     */
    private String createOperName;
    /**
     * 创建时间
     */
    private Date createTime;
    private Date createTimeStart;
    private Date createTimeEnd;
    /**
     * 未报价原因
     */
    private String quotationReason;
    /**
     * 价格有效期 预留
     */
    private Date validityTime;
    private Date validityTimeStart;
    private Date validityTimeEnd;
    /**
     * 最新有效报价标志
     0 非最新
     1 最新报价
     */
    private String newestFlag;
    /**
     * 采购议价单编号 预留
     */
    private String purQuotationNo;
    /**
     * 商机单号（京东侧）
     */
    private String biddingCode;
    /**
     * 	商机状态
     */
    private String biddingStatus;
    /**
     * 下单截止时间
     */
    private Date orderDeadLine;
    /**
     * 供应商ID
     */
    private String supId;
    /**
     * 供应商编码
     */
    private String supNo;
    /**
     * 供应商名称
     */
    private String supplierName;
    /**
     * 议价单状态
     *  YJ_DBJ 待发起
     *  YJ_DBJ 报价中
     *  YJ_YBJ 已报价
     *  YJ_YZZ 已终止
     *  YJ_YXD 已下单
     */
    private String bargainingState;
}
