package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocCreateOrderServiceReqPayConfBo
 * 说明:
 * 时间:2022/2/23 18:03
 * 作者:田桂银
 */
@Data
public class UocCreateOrderServiceReqPayConfBo implements Serializable {

    private static final long serialVersionUID = -460642090735099897L;


    /**
     * 结算模式 2:撮合 1:贸易
     */
    private Integer modelSettle;

    /**
     * 付款方式 0 预付款按比例支付,1 按协议约束支付,2 按账期支付
     */
    private Integer payType;

    /**
     * 预付款(比例)
     */
    private BigDecimal prePaySup;

    /**
     * 到货款(比例)
     */
    private BigDecimal verPaySup;

    /**
     * 验收款(比例)
     */
    private BigDecimal pilPaySup;

    /**
     * 质保金(比例)
     */
    private BigDecimal quaPaySup;

    /**
     * 账期天数
     */
    private Integer paymentDays;

    /**
     * 指定账期日
     */
    private Integer payAccountDay;

    /**
     * 使用类型：1：采购方；2：平台方
     */
    private Integer userType;

    /**
     * 账期支付结算规则 1:指定账期日 2:账期起算特定业务节点+账期天数
     */
    private Integer payRule;

    /**
     * 违约金额比例
     */
    private BigDecimal payBreakScale;

    /**
     * 账期日结算订单规则 1:签收发票开始 2:订单验收 3:订单到货
     */
    private Integer payAccountDayRule;

    /**
     * 账期起算特定业务节点 1:签收发票开始计算 2:订单验收开始计算 3:订单到货开始计算
     */
    private Integer payNodeRule;

    /**
     * 合同ID
     */
    private String modelContractId;

    /**
     * 备注
     */
    private String remark;


}


