package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题:UocOverallProgressOrderItemBO
 * 说明:整体进度订单明细BO
 * 时间:2022-02-21 19:11
 * 作者:tkl
 **/
@Data
public class UocOverallProgressSaleOrderItemBO implements Serializable {
	private static final long serialVersionUID = -4240936877686012371L;

	@DocField("skuId")
	private String skuId;

	@DocField("外部商品Id")
	private String skuExtSkuId;

	@DocField("sku名称")
	private String skuName;

	@DocField("计量单位")
	private String unitName;

	@DocField("采购数量")
	private BigDecimal purchaseCount;

	@DocField(value = "sku单品主图url")
	private String skuMainPicUrl;

	@DocField("销售单价")
	private BigDecimal salePrice;

	@DocField("总销售金额")
	private BigDecimal totalSaleFee;

	@DocField("税率")
	private String tax;

	@DocField("物料编码")
	private String skuMaterialId;

	@DocField("物料名称")
	private String skuMaterialName;

	@DocField("物料类型")
	private String skuMaterialTypeId;

	@DocField("物料类型名称")
	private String skuMaterialTypeName;

	@DocField("比选单号")
	private String cmpOrderNo;

	@DocField("到货时间")
	private Date arriveTime;

	@DocField("生产厂家")
	private String manufacturer;

	@DocField("技术参数")
	private String technicalParameters;

	@DocField("国产/进口")
	private String domestic;

	@DocField("库龄")
	private String storageAge;

	@DocField("自提时间")
	private String selfMentionTime;

	@DocField("自提地址")
	private String selfMentionAddress;

	@DocField("发货数量")
	private BigDecimal sendCount;

	@DocField("验收数量")
	private BigDecimal acceptanceCount;
}
