package com.tydic.dyc.oc.service.order.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import lombok.Data;

@Data
public class UocQryOutOrderIndexServiceReqBo extends BaseReqBo {
    
    private static final long serialVersionUID = -2933088800129036968L;
    
    /**
     * ID主键(必填项)
     */
    private Long id;
    
    /**
     * 单据ID
     * 单据类型为1=订单时，不填
     */
    private Long objId;
    
    /**
     * 单据类型
     * 1订单
     * 2.销售单
     * 3 发货单
     * 4.收货单
     * 5.售后服务单
     * 99.其他(必填项)
     */
    private Integer objType;
    
    /**
     * 订单ID(必填项)
     */
    private Long orderId;
    
    /**
     * 外部订单(必填项)
     */
    private String outOrderNo;
    
    /**
     * 订单来源系统(必填项)
     */
    private String orderSystem;
    
    /**
     * 排序
     */
    private String orderBy;
    
    /**
     * 消息类型/** type=101 代表拆分发货单  发货单号+京东订单编号 type=102：售后服务单完成   成功/失败\t0同意并处理中1代表处理完成 2代表失败 type=5       妥投状态\t    1是妥投，2是拒收 type=6       添加/删除\t1添加，2删除 type=7       当前状态  \t1全部开票 2 驳回 3 部分开票 4 发票寄出（可调用查询发票运单号接口，获取运单号）
     */
    private Long type;
    
    private String supNo;
}
