package com.tydic.dyc.oc.service.checkorder.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@Data
public class UocCheckOrderErrorItemBo implements Serializable {
    private static final long serialVersionUID = -686394458629239657L;
    
    /**
     * 对账错误明细id
     */
    private Long checkErrorItemId;
    
    /**
     * 对账ID
     */
    private Long checkId;
    
    /**
     * 对账类型：
     1：订单创建对账
     2：订单妥投对账
     3：订单拒收对账
     4：订单售后完成对账
     */
    private Integer checkType;
    
    /**
     * 供应商:
     JD:京东
     SN:苏宁
     STB:史泰博
     LXWL:领先未来
     DL:得力
     */
    private String supplier;
    
    /**
     * 内部单据id
     */
    private Long internalObjId;
    
    /**
     * 内部单据编号
     */
    private String internalObjNo;
    
    /**
     * 内部单据类型：
     1：销售单
     2：发货单
     3：售后单
     */
    private Integer internalObjType;
    
    /**
     * 内部单据金额
     */
    private BigDecimal internalObjPrice;
    
    /**
     * 电商订单id
     */
    private String outOrderId;
    
    /**
     * 电商订单金额
     */
    private BigDecimal outOrderPrice;
    
    /**
     * 对账日
     */
    private String checkDate;
    
}
