package com.tydic.dyc.oc.service.saleorder.bo;

import lombok.Data;
import lombok.EqualsAndHashCode;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 标题：UocCancelSaleOrderBo
 * 说明：
 * 时间：2022/4/2 16:05
 * 作者： 周中贤
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocCancelSaleOrderBo implements Serializable {
    private static final long serialVersionUID = -4426367425357512016L;

    /**
     * 销售单对应的应付单IDs
     */
    private List<Long> shouldPayIds;

    /**
     * 销售单付款方式
     */
    private Integer payType;

    /**
     * 供应商ID
     */
    private Long supId;

    /**
     * 采购单位Id
     */
    private Long creditOrgId;

    /**
     * 扣减金额
     */
    private BigDecimal amount;

    /**
     * 销售单号
     */
    private String saleOrderNo;

    /**
     * 销售单id
     */
    private Long saleOrderId;

    /**
     * 使用类型：1：采购方；2：平台方
     */
    private Integer userType;
}
