package com.tydic.dyc.oc.service.order.bo;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

@Data
@EqualsAndHashCode(callSuper=false)
public class UocQryOutOrderIndexBo implements Serializable {

    private static final long serialVersionUID = 6903259955456464041L;
    
    /**
     * ID主键(必填项)
     */
    private Long id;

    /**
     * 单据ID
     * 单据类型为1=订单时，不填
     */
    private Long objId;

    /**
     * 单据类型
     * 1订单
     * 2.销售单
     * 3 发货单
     * 4.收货单
     * 5.售后服务单
     * 99.其他(必填项)
     */
    private Integer objType;

    /**
     * 订单ID(必填项)
     */
    private Long orderId;

    /**
     * 订单来源系统(必填项)
     */
    private String orderSystem;

    /**
     * 排序
     */
    private String orderBy;

   /**
    * @Author lsl
    * @Description //TODO 外部单号
    * @Date 11:01 2022/4/14
    * @Param
    * @return
    */
    private String outObjId;
}
