package com.tydic.dyc.oc.service.domainservice.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.EqualsAndHashCode;

/**
 * 描述: 〈领域服务-销售单评价回调入参〉
 * @author : yuhao
 * @date : 2022/9/9 14:47
 */
@Data
@EqualsAndHashCode(callSuper=false)
public class UocEvaluateDealServiceReqBo extends BaseReqBo {

    private static final long serialVersionUID = -3607834189541244182L;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 销售单id
     */
    private Long saleOrderId;

    /**
     * 默认为0，评价状态,0未评价，1已评价，可以追评，2已评价，不可以追评，3评价超时，不可以追评，4已追评，5追评超时
     */
    private Integer evaluateState;

    /**
     * 销售单编码
     */
    private String saleOrderNo;
    /**
     * 当前登录用户id
     */
    private Long userId;
}


