package com.tydic.dyc.oc.service.order.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * 标题：UocProOrderQuotaAllocationDealReqBo
 * 说明：订单下单限额配置处理API 入参
 * 时间：2021/4/2 17:00
 * 作者 何秀全
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class UocProOrderQuotaAllocationDealReqBo  extends BaseReqBo {

    private static final long serialVersionUID = -1159781393470514309L;

    /**
     * ID主键(必填项)
     */
    private Long confId;

    /**
     * 供应商ID
     */
    private Long supNo;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 订单超限额度
     */
    private BigDecimal orderQuota;

    /**
     * 业务类型编码
     */
    private String businessTypeCode;

    /**
     * 操作类型
     * 1：新增；2：修改；3：删除
     */
    private Integer operateType;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 账户名
     */
    private String username;
    
    //用户名
    private String name;

}
