/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocConfEffectiveQryBo;
import com.tydic.dyc.oc.model.order.sub.UocConfEffective;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.service.domainservice.UocSaleShipOrderService;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleShipOrderReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleShipOrderReqItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocSaleShipOrderRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocSaleShipOrderService"})
public class UocSaleShipOrderServiceImpl
implements UocSaleShipOrderService {
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    private static final String OP_FLAG_YES = "1";
    private static final String OP_FLAG_NO = "0";
    private static final String EC_IMPORT = "2";
    private static final String SUP_NO = "\u5168\u90e8";

    @PostMapping(value={"dealImplShipOrder"})
    public UocSaleShipOrderRspBo dealImplShipOrder(@RequestBody UocSaleShipOrderReqBo reqBo) {
        this.validateArg(reqBo);
        Date now = new Date();
        List<UocSaleOrderItem> uocSaleOrderItemList = this.getUocSaleOrderItemList(reqBo);
        UocSaleOrderDo uocSaleOrderDo = this.getUocSaleOrderDo(reqBo);
        UocShipOrderDo uocShipOrderDo = this.convertShipOrderDo(reqBo, now, uocSaleOrderItemList, uocSaleOrderDo);
        this.iUocShipOrderModel.createShipOrder(uocShipOrderDo);
        this.iUocSaleOrderModel.modifyBatchItemSendCount(this.convertSaleOrderDo(reqBo, now));
        UocSaleShipOrderRspBo uocImplShipOrderRspBo = UocRu.success(UocSaleShipOrderRspBo.class);
        boolean finish = this.checkSaleOrderIsFinish(reqBo);
        String saleOrderState = "XS_FH_FHZ";
        String opFlag = OP_FLAG_NO;
        if (finish) {
            saleOrderState = "XS_FH_FHWC";
            opFlag = OP_FLAG_YES;
        }
        if (!saleOrderState.equals(uocSaleOrderDo.getSaleOrderState())) {
            this.modifySaleState(reqBo, saleOrderState);
        }
        uocImplShipOrderRspBo.setFinish(Boolean.valueOf(finish));
        uocImplShipOrderRspBo.setOpFlag(opFlag);
        uocImplShipOrderRspBo.setShipOrderId(uocShipOrderDo.getShipOrderId());
        uocImplShipOrderRspBo.setShipOrderNo(uocShipOrderDo.getShipOrderNo());
        return uocImplShipOrderRspBo;
    }

    private void modifySaleState(UocSaleShipOrderReqBo reqBo, String saleOrderState) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        uocSaleOrderDo.setSaleOrderState(saleOrderState);
        this.iUocSaleOrderModel.updateSaleStatusAndProCode(uocSaleOrderDo);
    }

    private boolean checkSaleOrderIsFinish(UocSaleShipOrderReqBo reqBo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.getCollectCountImplOrderItem(uocSaleOrderItemQryBo);
        if (CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException("101003", "\u67e5\u8be2\u6570\u91cf\u6c47\u603b\u4e3a\u7a7a");
        }
        UocSaleOrderItem uocSaleOrderItem = uocSaleOrderDo.getSaleOrderItems().get(0);
        if (null == uocSaleOrderItem) {
            throw new BaseBusinessException("101003", "\u67e5\u8be2\u6570\u91cf\u6c47\u603b\u4e3a\u7a7a");
        }
        return uocSaleOrderItem.getPurchaseCount().compareTo(uocSaleOrderItem.getSendCount().add(uocSaleOrderItem.getReturnCount())) == 0;
    }

    private UocSaleOrderDo convertSaleOrderDo(UocSaleShipOrderReqBo reqBo, Date now) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setSaleOrderItems(reqBo.getShipOrderItemBoList().stream().map(uocImplShipOrderReqItemBo -> {
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setSaleOrderItemId(uocImplShipOrderReqItemBo.getSaleOrderItemId());
            uocSaleOrderItem.setSendCount(uocImplShipOrderReqItemBo.getSendCount());
            return uocSaleOrderItem;
        }).collect(Collectors.toList()));
        return uocSaleOrderDo;
    }

    private UocShipOrderDo convertShipOrderDo(UocSaleShipOrderReqBo reqBo, Date now, List<UocSaleOrderItem> uocImplOrderItemList, UocSaleOrderDo uocSaleOrderDo) {
        Map<Long, UocSaleOrderItem> uocSaleOrderItemMap = uocImplOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        UocShipOrderDo uocShipOrderDo = UocRu.js(reqBo, UocShipOrderDo.class);
        uocShipOrderDo.setShipOrderState("FH_FH_FH");
        uocShipOrderDo.setShipOperId(reqBo.getUserId().toString());
        uocShipOrderDo.setCreateOperId(reqBo.getUserId().toString());
        uocShipOrderDo.setCreateTime(now);
        uocShipOrderDo.setShipOrderId(IdUtil.nextId());
        uocShipOrderDo.setSupNo(uocImplOrderItemList.get(0).getSupplierId());
        uocShipOrderDo.setShipOrderNo(this.getShipOrderNo(reqBo, uocSaleOrderDo));
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtParallelBoList())) {
            uocShipOrderDo.getExtParallelBoList().forEach(uocShipOrderMap -> {
                uocShipOrderMap.setId(IdUtil.nextId());
                uocShipOrderMap.setOrderId(reqBo.getOrderId());
                uocShipOrderMap.setSaleOrderId(reqBo.getSaleOrderId());
                uocShipOrderMap.setShipOrderId(uocShipOrderDo.getShipOrderId());
                uocShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
                uocShipOrderMap.setCreateTime(now);
            });
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrderAccessoryBoList())) {
            List<UocOrderAccessory> uocOrderAccessoryList = UocRu.jsl(reqBo.getOrderAccessoryBoList(), UocOrderAccessory.class);
            uocOrderAccessoryList.forEach(uocOrderAccessory -> {
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setCreateTime(now);
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
                uocOrderAccessory.setObjId(uocShipOrderDo.getShipOrderId());
            });
            uocShipOrderDo.setOrderAccessoryBoList(uocOrderAccessoryList);
        }
        uocShipOrderDo.getShipOrderItemBoList().forEach(uocShipOrderItem -> {
            UocSaleOrderItem uocSaleOrderItem = (UocSaleOrderItem)uocSaleOrderItemMap.get(uocShipOrderItem.getSaleOrderItemId());
            if (uocShipOrderItem.getSendCount().add(uocSaleOrderItem.getSendCount()).compareTo(uocSaleOrderItem.getPurchaseCount()) > 0) {
                throw new BaseBusinessException("101002", "\u5b58\u5728\u5df2\u53d1\u8d27\u5b8c\u6210\u7684\u5546\u54c1\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5546\u54c1\u53d1\u8d27");
            }
            uocShipOrderItem.setShipOrderId(uocShipOrderDo.getShipOrderId());
            uocShipOrderItem.setOrderId(uocShipOrderDo.getOrderId());
            uocShipOrderItem.setSaleOrderId(uocShipOrderDo.getSaleOrderId());
            uocShipOrderItem.setSaleOrderItemId(uocSaleOrderItem.getSaleOrderItemId());
            uocShipOrderItem.setUnitName(uocSaleOrderItem.getUnitName());
            uocShipOrderItem.setCreateOperId(reqBo.getUserId().toString());
            uocShipOrderItem.setCreateTime(now);
            uocShipOrderItem.setShipOrderItemId(IdUtil.nextId());
            if (!CollectionUtils.isEmpty(uocShipOrderItem.getItemExtParallelBoList())) {
                uocShipOrderItem.getItemExtParallelBoList().forEach(uocShipItemMap -> {
                    uocShipItemMap.setId(IdUtil.nextId());
                    uocShipItemMap.setOrderId(reqBo.getOrderId());
                    uocShipItemMap.setSaleOrderId(reqBo.getSaleOrderId());
                    uocShipItemMap.setShipOrderItemId(uocShipOrderItem.getShipOrderItemId());
                    uocShipItemMap.setShipOrderId(uocShipOrderItem.getShipOrderId());
                    uocShipItemMap.setId(IdUtil.nextId());
                    uocShipItemMap.setCreateTime(now);
                    uocShipItemMap.setCreateOperId(reqBo.getUserId().toString());
                });
            }
        });
        this.setShipAllowChngTime(reqBo, uocShipOrderDo);
        return uocShipOrderDo;
    }

    private void setShipAllowChngTime(UocSaleShipOrderReqBo reqBo, UocShipOrderDo uocShipOrderDo) {
        UocSaleOrderQryBo saleOrderQryBo = new UocSaleOrderQryBo();
        saleOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        saleOrderQryBo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.qrySaleOrder(saleOrderQryBo);
        UocConfEffectiveQryBo uocConfEffectiveQryBo = new UocConfEffectiveQryBo();
        uocConfEffectiveQryBo.setEffectiveCode("5");
        List rows = this.iUocOrderModel.qryListPageConfEffective(uocConfEffectiveQryBo).getRows();
        Date allowChngTime = null;
        String supId = "";
        String orderSource = "";
        if (ObjectUtil.isNotEmpty((Object)rows)) {
            Map confEffectiveMap = rows.stream().collect(Collectors.toMap(o -> o.getBusinessTypeCode() + o.getEffectiveCode(), Function.identity()));
            if (ObjectUtil.isNotNull((Object)saleOrderMain) && ObjectUtil.isNotNull((Object)saleOrderMain.getStakeholder())) {
                orderSource = saleOrderMain.getOrderSource().toString();
                supId = saleOrderMain.getStakeholder().getSupId();
            } else {
                orderSource = EC_IMPORT;
                supId = reqBo.getSupId().toString();
            }
            allowChngTime = ObjectUtil.isNotNull(confEffectiveMap.get(orderSource + supId)) ? new Date(((UocConfEffective)confEffectiveMap.get(orderSource + supId)).getAging()) : new Date(((UocConfEffective)confEffectiveMap.get(orderSource + SUP_NO)).getAging());
        }
        uocShipOrderDo.setAllowChngTime(allowChngTime);
    }

    private List<UocSaleOrderItem> getUocSaleOrderItemList(UocSaleShipOrderReqBo reqBo) {
        List<Long> saleOrderItemIds = reqBo.getShipOrderItemBoList().stream().map(UocSaleShipOrderReqItemBo::getSaleOrderItemId).collect(Collectors.toList());
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIds);
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.getListSaleOrderItem(uocSaleOrderItemQryBo);
        List<UocSaleOrderItem> saleOrderItems = uocSaleOrderDo.getSaleOrderItems();
        if (CollectionUtils.isEmpty(saleOrderItems)) {
            throw new BaseBusinessException("101002", "\u83b7\u53d6\u9500\u552e\u5355\u660e\u7ec6\u4e3a\u7a7a");
        }
        return saleOrderItems;
    }

    private String getShipOrderNo(UocSaleShipOrderReqBo reqBo, UocSaleOrderDo uocSaleOrderDo) {
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderSource(uocSaleOrderDo.getOrderSource());
        uocShipOrderDo = this.iUocShipOrderModel.getShipOrderNo(uocShipOrderDo);
        return uocShipOrderDo.getShipOrderNo();
    }

    private UocSaleOrderDo getUocSaleOrderDo(UocSaleShipOrderReqBo reqBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("101002", "\u67e5\u8be2\u9a8c\u6536\u5355\u4e3a\u7a7a");
        }
        return uocSaleOrderDo;
    }

    private void validateArg(UocSaleShipOrderReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getShipCompanyNo()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u914d\u9001\u5355\u53f7\u4e3a\u7a7a");
        }
        if (null == reqBo.getShipName()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u8054\u7cfb\u4eba\u4e3a\u7a7a");
        }
        if (null == reqBo.getShipPhone()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8054\u7cfb\u4eba\u7535\u8bdd\u4e3a\u7a7a");
        }
        if (null == reqBo.getShipTime()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u65e5\u671f\u4e3a\u7a7a");
        }
        if (null == reqBo.getEstimateArrivalTime()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9884\u8ba1\u5230\u8d27\u65e5\u671f\u4e3a\u7a7a");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u7528\u6237ID\u4e3a\u7a7a");
        }
    }
}

