/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.order;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderRelQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.order.UocOrderRelUpdateService;
import com.tydic.dyc.oc.service.order.bo.UocOrderRelUpdateReqBo;
import com.tydic.dyc.oc.service.order.bo.UocOrderRelUpdateRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.order.UocOrderRelUpdateService"})
public class UocOrderRelUpdateServiceImpl
implements UocOrderRelUpdateService {
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private UocEsSyncManager uocEsSyncManager;
    @Autowired
    private UocIndexConfig uocIndexConfig;

    @PostMapping(value={"dealRelUpdate"})
    public UocOrderRelUpdateRspBo dealRelUpdate(@RequestBody UocOrderRelUpdateReqBo reqBo) {
        this.validateArg(reqBo);
        UocOrderRelQryBo uocOrderRelQryBo = new UocOrderRelQryBo();
        uocOrderRelQryBo.setObjId(reqBo.getObjId());
        uocOrderRelQryBo.setObjType(reqBo.getObjType());
        uocOrderRelQryBo.setRelType(reqBo.getRelType());
        UocOrderRel qryRelInfo = this.iUocOrderModel.qryRelInfo(uocOrderRelQryBo);
        UocOrderRel uocOrderRel = new UocOrderRel();
        if (null != qryRelInfo) {
            uocOrderRel.setId(qryRelInfo.getId());
            uocOrderRel.setRelStatus(reqBo.getRelState());
            uocOrderRel.setRelId(reqBo.getRelId());
            this.iUocOrderModel.dealRelUpdate(uocOrderRel);
        } else {
            uocOrderRel = UocRu.js(reqBo, UocOrderRel.class);
            uocOrderRel.setRelStatus(reqBo.getRelState());
            uocOrderRel.setId(IdUtil.nextId());
            this.iUocOrderModel.createRelInfo(uocOrderRel);
        }
        uocOrderRel.setRelType(reqBo.getRelType());
        uocOrderRel.setObjId(reqBo.getObjId());
        uocOrderRel.setObjType(reqBo.getObjType());
        this.syncEs(uocOrderRel);
        return UocRu.success(UocOrderRelUpdateRspBo.class);
    }

    private void validateArg(UocOrderRelUpdateReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e0d\u4e3a\u7a7a");
        }
        if (null == reqBo.getObjId()) {
            throw new BaseBusinessException("100001", "ObjId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getObjType()) {
            throw new BaseBusinessException("100001", "ObjType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getRelState()) {
            throw new BaseBusinessException("100001", "relState\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getRelType()) {
            throw new BaseBusinessException("100001", "relType\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private Map<String, Map<String, String>> getDic() {
        ArrayList<String> pCodes = new ArrayList<String>();
        pCodes.add("UOC_ORDER_REL_TYPE");
        pCodes.add("UOC_ORDER_REL_STATUS");
        return this.iUocSysDictionaryModel.getDictionaryMap(pCodes);
    }

    private void syncEs(UocOrderRel uocOrderRel) {
        UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
        uocEsSyncManagerSaveDataReqBo.setObjId(uocOrderRel.getObjId());
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("relType", (Object)uocOrderRel.getRelType());
        jsonObj.put("relStatus", (Object)uocOrderRel.getRelStatus());
        jsonObj.put("relInfo", (Object)(uocOrderRel.getRelStatus() + "," + uocOrderRel.getRelType()));
        jsonObj.put("relId", (Object)uocOrderRel.getRelId());
        Map<String, Map<String, String>> dic = this.getDic();
        Map<String, String> relTypeMap = dic.get("UOC_ORDER_REL_TYPE");
        Map<String, String> relStatusMap = dic.get("UOC_ORDER_REL_STATUS");
        jsonObj.put("relStatusStr", (Object)relStatusMap.get(Convert.toStr((Object)uocOrderRel.getRelStatus())));
        jsonObj.put("relTypeStr", (Object)relTypeMap.get(Convert.toStr((Object)uocOrderRel.getRelType())));
        uocEsSyncManagerSaveDataReqBo.setJsonObj(jsonObj);
        if (UocDicConstant.REL_TYPE.SERVICE_CHARGE.equals(uocOrderRel.getRelType())) {
            uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getTransactionIndex());
        } else {
            uocEsSyncManagerSaveDataReqBo.setIndexName(this.uocIndexConfig.getInspOrderIndex());
        }
        this.uocEsSyncManager.updateData(uocEsSyncManagerSaveDataReqBo);
    }
}

