/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.saleorder.UocDistSaleOrderService;
import com.tydic.dyc.oc.service.saleorder.bo.UocDistSaleOrderReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocDistSaleOrderRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.saleorder.UocDistSaleOrderService"})
public class UocDistSaleOrderServiceImpl
implements UocDistSaleOrderService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @PostMapping(value={"distSaleOrder"})
    public UocDistSaleOrderRspBo distSaleOrder(@RequestBody UocDistSaleOrderReqBo reqBo) {
        this.validateArg(reqBo);
        UocSaleOrderDo uocSaleOrderUpdateDo = new UocSaleOrderDo();
        uocSaleOrderUpdateDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderUpdateDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderUpdateDo.setProDeliveryId(reqBo.getProDeliveryId());
        uocSaleOrderUpdateDo.setProDeliveryName(reqBo.getProDeliveryName());
        uocSaleOrderUpdateDo.setUpdateTime(new Date());
        uocSaleOrderUpdateDo.setUpdateOperId(reqBo.getUserId().toString());
        uocSaleOrderUpdateDo.setUpdateOperName(reqBo.getName());
        this.iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderUpdateDo);
        if (ObjectUtil.isNotEmpty((Object)reqBo.getAccessoryAddBoList())) {
            List<UocOrderAccessory> uocOrderAccessoryList = UocRu.jsl(reqBo.getAccessoryAddBoList(), UocOrderAccessory.class);
            uocOrderAccessoryList.forEach(each -> {
                each.setId(IdUtil.nextId());
                each.setObjId(reqBo.getSaleOrderId());
                each.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                each.setOrderId(reqBo.getOrderId());
                each.setCreateTime(new Date());
                each.setCreateOperId(reqBo.getUserId().toString());
            });
            this.iUocOrderModel.createOrderAccessory(uocOrderAccessoryList);
        }
        return UocRu.success(UocDistSaleOrderRspBo.class);
    }

    private void validateArg(UocDistSaleOrderReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61[uocDistSaleOrderReqBo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getUserId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010userId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getProDeliveryId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010proDeliveryId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getProDeliveryName())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010proDeliveryName\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010orderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u3010saleOrderId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

