/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.config.UocInitConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.service.saleorder.UocSaleOrderRefuseService;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderRefuseReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderRefuseRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.saleorder.UocSaleOrderRefuseService"})
public class UocSaleOrderRefuseServiceImpl
implements UocSaleOrderRefuseService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private UocInitConfig uocInitConfig;
    private static final Integer OP_FLAG_CONFIRM = 1;
    private static final Integer OP_FLAG_REFUSE = 0;

    @PostMapping(value={"dealSaleOrderRefuse"})
    public UocSaleOrderRefuseRspBo dealSaleOrderRefuse(@RequestBody UocSaleOrderRefuseReqBo reqBo) {
        if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
            return UocRu.success(UocSaleOrderRefuseRspBo.class);
        }
        this.validateArg(reqBo);
        Date now = new Date();
        this.iUocSaleOrderModel.modifySaleOrderMain(this.convertSaleOrderDo(reqBo, now));
        if (ObjectUtil.isNotEmpty((Object)reqBo.getOrderAccessoryList())) {
            this.iUocOrderModel.createOrderAccessory(this.convertSaleOrderAccessory(reqBo, now));
        }
        this.dealMap(reqBo, now);
        return UocRu.success(UocSaleOrderRefuseRspBo.class);
    }

    private List<UocOrderAccessory> convertSaleOrderAccessory(UocSaleOrderRefuseReqBo reqBo, Date now) {
        List<UocOrderAccessory> uocOrderAccessoryList = UocRu.jsl(reqBo.getOrderAccessoryList(), UocOrderAccessory.class);
        uocOrderAccessoryList.forEach(each -> {
            each.setId(IdUtil.nextId());
            each.setObjId(reqBo.getSaleOrderId());
            each.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            each.setOrderId(reqBo.getOrderId());
            each.setCreateTime(now);
            each.setCreateOperId(reqBo.getUserId().toString());
        });
        return uocOrderAccessoryList;
    }

    private UocSaleOrderDo convertSaleOrderDo(UocSaleOrderRefuseReqBo reqBo, Date now) {
        UocSaleOrderDo uocSaleOrderDo = UocRu.js(reqBo, UocSaleOrderDo.class);
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        uocSaleOrderDo.setRejectReason(reqBo.getRejectReason());
        uocSaleOrderDo.setRejectTime(ObjectUtil.isNotEmpty((Object)reqBo.getRejectTime()) ? reqBo.getRejectTime() : now);
        return uocSaleOrderDo;
    }

    private void dealMap(UocSaleOrderRefuseReqBo reqBo, Date now) {
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtDeleteList())) {
            UocSaleOrderDo delSaleOrderDo = new UocSaleOrderDo();
            ArrayList<UocSaleOrderMap> extParallelBoList = new ArrayList<UocSaleOrderMap>();
            reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                UocSaleOrderMap uocSaleOrderMap = new UocSaleOrderMap();
                uocSaleOrderMap.setOrderId(reqBo.getOrderId());
                uocSaleOrderMap.setSaleOrderId(uocBaseExtParallelDeleteBo.getObjId());
                uocSaleOrderMap.setFieldCode(uocBaseExtParallelDeleteBo.getFieldCode());
                uocSaleOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                uocSaleOrderMap.setUpdateTime(now);
                extParallelBoList.add(uocSaleOrderMap);
            });
            delSaleOrderDo.setSaleOrderMapList(extParallelBoList);
            this.iUocSaleOrderModel.updateInvalid(delSaleOrderDo);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtEditList())) {
            UocSaleOrderDo add = new UocSaleOrderDo();
            UocSaleOrderDo modify = new UocSaleOrderDo();
            ArrayList<UocSaleOrderMap> addList = new ArrayList<UocSaleOrderMap>();
            ArrayList<UocSaleOrderMap> modifyList = new ArrayList<UocSaleOrderMap>();
            reqBo.getExtEditList().forEach(uocBaseExtParallelEditBo -> {
                if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelEditBo.getOpFlag())) {
                    UocSaleOrderMap addShipOrderMap = new UocSaleOrderMap();
                    addShipOrderMap.setSaleOrderId(uocBaseExtParallelEditBo.getObjId());
                    addShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                    addShipOrderMap.setFieldName(uocBaseExtParallelEditBo.getFieldName());
                    addShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                    addShipOrderMap.setOrderId(reqBo.getOrderId());
                    addShipOrderMap.setId(IdUtil.nextId());
                    addShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
                    addShipOrderMap.setCreateTime(now);
                    addList.add(addShipOrderMap);
                } else {
                    UocSaleOrderMap updateShipOrderMap = new UocSaleOrderMap();
                    updateShipOrderMap.setSaleOrderId(uocBaseExtParallelEditBo.getObjId());
                    updateShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                    updateShipOrderMap.setOrderId(reqBo.getOrderId());
                    updateShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                    updateShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                    updateShipOrderMap.setUpdateTime(now);
                    modifyList.add(updateShipOrderMap);
                }
            });
            if (!CollectionUtils.isEmpty(addList)) {
                add.setSaleOrderMapList(addList);
                this.iUocSaleOrderModel.addSaleOrderMap(add);
            }
            if (!CollectionUtils.isEmpty(modifyList)) {
                modify.setSaleOrderMapList(modifyList);
                this.iUocSaleOrderModel.updateBatchValue(modify);
            }
        }
    }

    private void validateArg(UocSaleOrderRefuseReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOpFlag()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!OP_FLAG_REFUSE.equals(reqBo.getOpFlag()) && !OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
            throw new BaseBusinessException("100001", "\u64cd\u4f5c\u53ea\u80fd\u662f\u63a5\u5355\u6216\u62d2\u5355");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag()) && StringUtils.isBlank((CharSequence)reqBo.getRejectReason())) {
            throw new BaseBusinessException("100001", "\u62d2\u5355\u65f6\uff0c\u62d2\u5355\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtDeleteList())) {
            reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                    throw new BaseBusinessException("100001", "\u8981\u5220\u9664\u7684\u6269\u5c55\u5c5e\u6027\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                    throw new BaseBusinessException("100001", "\u8981\u5220\u9664\u7684\u6269\u5c55\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtEditList())) {
            reqBo.getExtEditList().forEach(uocBaseExtParallelDeleteBo -> {
                if (null == uocBaseExtParallelDeleteBo.getOpFlag()) {
                    throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u7f16\u8f91\u64cd\u4f5c\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (!UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag()) && !UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u7f16\u8f91\u64cd\u4f5c\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4ec5\u652f\u6301\u65b0\u589e\u548c\u4fee\u6539");
                }
                if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
                if (UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldValue())) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
            });
        }
    }
}

