/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalLogQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalLog;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.model.sysdictionary.UocSysDictionaryDo;
import com.tydic.dyc.oc.model.sysdictionary.qrybo.UocSysDictionaryQryBo;
import com.tydic.dyc.oc.service.domainservice.UocApprovalLogQryService;
import com.tydic.dyc.oc.service.domainservice.bo.UocApprovalLogItemBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocApprovalLogQryReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApprovalLogQryRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocApprovalLogQryService"})
public class UocApprovalLogQryServiceImpl
implements UocApprovalLogQryService {
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;

    @PostMapping(value={"qryApprovalLog"})
    public UocApprovalLogQryRspBo qryApprovalLog(@RequestBody UocApprovalLogQryReqBo reqBo) {
        this.validateArg(reqBo);
        UocApprovalLogQryBo uocApprovalLogQryBo = new UocApprovalLogQryBo();
        uocApprovalLogQryBo.setAuditOrderId(reqBo.getAuditOrderId());
        UocAuditOrderDo uocAuditOrderDo = this.iUocAuditOrderModel.qryApprovalLog(uocApprovalLogQryBo);
        UocApprovalLogQryRspBo success = UocRu.success(UocApprovalLogQryRspBo.class);
        List<UocApprovalLog> uocApprovalLogList = uocAuditOrderDo.getUocApprovalLogList();
        if (CollectionUtils.isEmpty(uocApprovalLogList)) {
            return success;
        }
        UocSysDictionaryQryBo dictionaryQryBo = new UocSysDictionaryQryBo();
        dictionaryQryBo.setPCode("UOC_AUDIT_TYPE");
        List<UocSysDictionaryDo> uocSysDictionaryDos = this.iUocSysDictionaryModel.qryDicList(dictionaryQryBo);
        Map<String, String> auditDicMap = uocSysDictionaryDos.stream().collect(Collectors.toMap(UocSysDictionaryDo::getCode, UocSysDictionaryDo::getTitle));
        List uocApprovalLogs = uocApprovalLogList.stream().sorted(Comparator.comparing(UocApprovalLog::getCreateTime)).collect(Collectors.toList());
        ArrayList<UocApprovalLogItemBO> uocApprovalLogItemBOS = new ArrayList<UocApprovalLogItemBO>(uocApprovalLogs.size());
        for (int i = 0; i < uocApprovalLogs.size(); ++i) {
            UocApprovalLogItemBO approvalLogItemBO = UocRu.js(uocApprovalLogs.get(i), UocApprovalLogItemBO.class);
            approvalLogItemBO.setAuditResultStr(auditDicMap.get(Convert.toStr((Object)approvalLogItemBO.getAuditResult())));
            if (i == 0) {
                approvalLogItemBO.setAuditDiachronic(null);
            } else {
                long between = DateUtil.between((Date)((UocApprovalLog)uocApprovalLogs.get(i - 1)).getCreateTime(), (Date)((UocApprovalLog)uocApprovalLogs.get(i)).getCreateTime(), (DateUnit)DateUnit.SECOND);
                approvalLogItemBO.setAuditDiachronic(UocApprovalLogQryServiceImpl.secondToTime(between));
            }
            uocApprovalLogItemBOS.add(approvalLogItemBO);
        }
        success.setAuditLogItems(uocApprovalLogItemBOS);
        return success;
    }

    public static String secondToTime(long second) {
        long days = second / 86400L;
        long hours = (second %= 86400L) / 3600L;
        long minutes = (second %= 3600L) / 60L;
        second %= 60L;
        if (days > 0L) {
            return days + "\u5929" + hours + "\u5c0f\u65f6" + minutes + "\u5206" + second + "\u79d2";
        }
        return hours + "\u5c0f\u65f6" + minutes + "\u5206" + second + "\u79d2";
    }

    private void validateArg(UocApprovalLogQryReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getAuditOrderId()) {
            throw new BaseBusinessException("100001", "auditOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

