/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocChngOrderConfirmOrRefuseService;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseReqItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseSaleTaskInstBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseShipTaskInstBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocChngOrderConfirmOrRefuseService"})
public class UocChngOrderConfirmOrRefuseServiceImpl
implements UocChngOrderConfirmOrRefuseService {
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    private static final Integer OP_FLAG_CONFIRM = 1;
    private static final Integer OP_FLAG_REFUSE = 0;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    @PostMapping(value={"dealConfirmOrRefuse"})
    public UocChngOrderConfirmOrRefuseRspBo dealConfirmOrRefuse(@RequestBody UocChngOrderConfirmOrRefuseReqBo reqBo) {
        UocChngOrderConfirmOrRefuseRspBo rsp = UocRu.success(UocChngOrderConfirmOrRefuseRspBo.class);
        this.validateArg(reqBo);
        String operId = reqBo.getUserId().toString();
        Date now = new Date();
        List<UocChngOrderItemObj> uocChngOrderItemObjList = this.getListChngOrderItemObj(reqBo);
        for (UocChngOrderItemObj uocChngOrderItemObj : uocChngOrderItemObjList) {
            Integer chngType = uocChngOrderItemObj.getChngType();
            if (UocConstant.BUSI_TYPE.NUM.equals(chngType)) {
                this.iUocChngOrderModel.modifyBatchChngOrderState(this.convertChngOrderDo(reqBo, now, operId));
                if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
                    this.confirm(reqBo, operId, now, uocChngOrderItemObjList);
                }
                if (!OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) continue;
                this.refuse(reqBo, operId, now, uocChngOrderItemObjList);
                continue;
            }
            if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
                this.confirmStat(reqBo, operId, now, uocChngOrderItemObjList);
                this.getSaleOrderInfo(reqBo, rsp);
            }
            if (!OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) continue;
            this.refuse(reqBo, operId, now, uocChngOrderItemObjList);
        }
        reqBo.getChngOrderList().forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
            UocCommonDo uocCommonDo = new UocCommonDo();
            ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(uocChngOrderConfirmOrRefuseReqItemBo.getTaskId());
            taskBos.add(taskBo);
            uocCommonDo.setCompleteTaskInfos(taskBos);
            uocCommonDo.setUserId(11111L);
            uocCommonDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
            this.iUocCommonModel.dealTask(uocCommonDo);
        });
        this.dealMap(reqBo, now);
        this.buildSyncRsp(reqBo, rsp, uocChngOrderItemObjList);
        return rsp;
    }

    private void buildSyncRsp(UocChngOrderConfirmOrRefuseReqBo reqBo, UocChngOrderConfirmOrRefuseRspBo rspBo, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        List<Long> saleOrderItemIds = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getSaleOrderItemId).collect(Collectors.toList());
        List<Long> shipOrderItemIds = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getShipOrderItemId).collect(Collectors.toList());
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIds);
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        rspBo.getSaleOrderIdList().addAll(saleOrderItemList.stream().map(x -> x.getSaleOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList()));
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderItemIdList(shipOrderItemIds);
        List<UocShipOrderItem> shipOrderItemList = this.iUocShipOrderModel.getShipOrderItemList(uocShipOrderItemQryBo);
        rspBo.getShipOrderIdList().addAll(shipOrderItemList.stream().map(x -> x.getShipOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList()));
        reqBo.getChngOrderList().forEach(x -> rspBo.getChngOrderIdList().add(x.getChngOrderId() + "-" + x.getOrderId()));
    }

    private void getSaleOrderInfo(UocChngOrderConfirmOrRefuseReqBo reqBo, UocChngOrderConfirmOrRefuseRspBo rsp) {
        ArrayList<UocChngOrderConfirmOrRefuseSaleTaskInstBo> saleOrderTaskInstBoList = new ArrayList<UocChngOrderConfirmOrRefuseSaleTaskInstBo>();
        List<Long> chngOrderIds = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getChngOrderId).collect(Collectors.toList());
        UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
        uocChngOrderObjQryBo.setChngOrderIdList(chngOrderIds);
        UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
        uocChngOrderItemObjQryBo.setChngOrderIdList(chngOrderIds);
        List<UocChngOrderItemObj> listChngOrderItemObj = this.iUocChngOrderModel.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
        Map<Long, List<UocChngOrderItemObj>> chngOrderItemMaps = listChngOrderItemObj.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getChngOrderId));
        List<UocChngOrderObj> listChngOrderObjWithOutItem = this.iUocChngOrderModel.getListChngOrderObjWithOutItem(uocChngOrderObjQryBo);
        if (CollectionUtil.isEmpty(listChngOrderObjWithOutItem)) {
            throw new BaseBusinessException("101008", "\u67e5\u8be2\u53d8\u66f4\u5bf9\u8c61\u4e3a\u7a7a");
        }
        for (UocChngOrderObj uocChngOrderObj : listChngOrderObjWithOutItem) {
            String procState;
            Long saleOrderId = uocChngOrderObj.getSaleOrderId();
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setSaleOrderId(saleOrderId);
            uocSaleOrderDo.setOrderId(uocChngOrderObj.getOrderId());
            UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
            if (!UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(saleOrderMain.getOrderSource()) || !UocConstant.BUSI_TYPE.STATE.equals(uocChngOrderObj.getChngType())) continue;
            Boolean flag = null;
            UocOrderTaskInst uocSaleOrderTaskInst = new UocOrderTaskInst();
            uocSaleOrderTaskInst.setOrderId(uocChngOrderObj.getOrderId());
            uocSaleOrderTaskInst.setObjId(saleOrderId);
            uocSaleOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            uocSaleOrderTaskInst.setFinishTag(0);
            List<UocOrderTaskInst> uocSaleOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(uocSaleOrderTaskInst);
            if (CollectionUtil.isEmpty(uocSaleOrderTaskInsts)) {
                return;
            }
            UocOrderTaskInst uocSaleOrderTaskInst1 = uocSaleOrderTaskInsts.get(0);
            List<UocChngOrderItemObj> uocChngOrderItemObjs = chngOrderItemMaps.get(uocChngOrderObj.getChngOrderId());
            if (CollectionUtil.isEmpty(uocChngOrderItemObjs)) break;
            if ("1".equals(uocChngOrderItemObjs.get(0).getOtherChngValue())) {
                UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
                uocShipOrderQryBo.setSaleOrderId(saleOrderId);
                uocShipOrderQryBo.setOrderId(uocChngOrderObj.getOrderId());
                List<UocShipOrderDo> listShipOrder = this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
                if (CollectionUtil.isEmpty(listShipOrder)) {
                    throw new BaseBusinessException("100001", "\u901a\u8fc7\u9500\u552e\u5355\u67e5\u8be2\u53d1\u8d27\u5355\u5217\u8868\u4e3a\u7a7a");
                }
                for (UocShipOrderDo uocShipOrderDo : listShipOrder) {
                    UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
                    uocOrderTaskInst.setOrderId(uocChngOrderObj.getOrderId());
                    uocOrderTaskInst.setObjId(uocShipOrderDo.getShipOrderId());
                    uocOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
                    uocOrderTaskInst.setFinishTag(0);
                    List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
                    if (CollectionUtil.isEmpty(uocOrderTaskInsts)) {
                        return;
                    }
                    UocOrderTaskInst uocOrderTaskInst1 = uocOrderTaskInsts.get(0);
                    String procState2 = uocOrderTaskInst1.getProcState();
                    if ("XS_YS_YS".equals(procState2)) {
                        flag = true;
                        continue;
                    }
                    flag = false;
                    break;
                }
                Optional.ofNullable(flag).orElse(Boolean.FALSE);
                if (flag.booleanValue()) {
                    String taskId = uocSaleOrderTaskInst1.getTaskInstId();
                    UocChngOrderConfirmOrRefuseSaleTaskInstBo saleTaskinfo = new UocChngOrderConfirmOrRefuseSaleTaskInstBo();
                    saleTaskinfo.setTaskId(taskId);
                    saleTaskinfo.setStepId(uocSaleOrderTaskInst1.getProcState());
                    saleTaskinfo.setSaleOrderId(saleOrderId);
                    saleTaskinfo.setOrderId(uocChngOrderObj.getOrderId());
                    saleOrderTaskInstBoList.add(saleTaskinfo);
                }
            }
            if (!"2".equals(uocChngOrderItemObjs.get(0).getOtherChngValue()) || !"XS_DH_JS".equals(procState = uocSaleOrderTaskInst1.getProcState())) continue;
            String taskId = uocSaleOrderTaskInst1.getTaskInstId();
            UocChngOrderConfirmOrRefuseSaleTaskInstBo saleTaskinfo = new UocChngOrderConfirmOrRefuseSaleTaskInstBo();
            saleTaskinfo.setTaskId(taskId);
            saleTaskinfo.setStepId(uocSaleOrderTaskInst1.getProcState());
            saleTaskinfo.setSaleOrderId(saleOrderId);
            saleTaskinfo.setOrderId(uocChngOrderObj.getOrderId());
            saleOrderTaskInstBoList.add(saleTaskinfo);
        }
        rsp.setSaleOrderTaskInstList(saleOrderTaskInstBoList);
    }

    private void getShipTaskInsts(UocChngOrderConfirmOrRefuseReqBo reqBo, UocChngOrderConfirmOrRefuseRspBo rsp) {
        ArrayList shipTaskInstBoList = new ArrayList();
        List<Long> chngOrderIds = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getChngOrderId).collect(Collectors.toList());
        UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
        uocChngOrderObjQryBo.setChngOrderIdList(chngOrderIds);
        List<UocChngOrderObj> listChngOrderObjWithOutItem = this.iUocChngOrderModel.getListChngOrderObjWithOutItem(uocChngOrderObjQryBo);
        listChngOrderObjWithOutItem.forEach(x -> {
            UocOrderTaskInst uocOrderTaskInst = new UocOrderTaskInst();
            uocOrderTaskInst.setOrderId(x.getOrderId());
            uocOrderTaskInst.setObjId(x.getShipOrderId());
            uocOrderTaskInst.setObjType(UocDicConstant.OBJ_TYPE.SHIP);
            uocOrderTaskInst.setFinishTag(0);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocSaleOrderModel.qryTaskInstList(uocOrderTaskInst);
            if (CollectionUtil.isEmpty(uocOrderTaskInsts)) {
                throw new BaseBusinessException("100001", "\u67e5\u8be2\u53d1\u8d27\u5355\u4efb\u52a1\u4fe1\u606f\u4e3a\u7a7a");
            }
            UocOrderTaskInst uocOrderTaskInst1 = uocOrderTaskInsts.get(0);
            String taskInstId = uocOrderTaskInst1.getTaskInstId();
            String procState = uocOrderTaskInst1.getProcState();
            UocChngOrderConfirmOrRefuseShipTaskInstBo uocChngOrderConfirmOrRefuseShipTaskInstBo = new UocChngOrderConfirmOrRefuseShipTaskInstBo();
            uocChngOrderConfirmOrRefuseShipTaskInstBo.setShipOrderId(x.getShipOrderId());
            uocChngOrderConfirmOrRefuseShipTaskInstBo.setTaskId(taskInstId);
            uocChngOrderConfirmOrRefuseShipTaskInstBo.setStepId(procState);
            uocChngOrderConfirmOrRefuseShipTaskInstBo.setChngOrderId(x.getChngOrderId());
            uocChngOrderConfirmOrRefuseShipTaskInstBo.setOrderId(x.getOrderId());
            shipTaskInstBoList.add(uocChngOrderConfirmOrRefuseShipTaskInstBo);
        });
        rsp.setShipTaskInstList(shipTaskInstBoList);
    }

    private void confirmStat(UocChngOrderConfirmOrRefuseReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        UocSaleOrderDo uocSaleOrderDo;
        UocShipOrderDo uocShipOrderDo;
        Map<String, List<UocChngOrderItemObj>> chngOrderItemMaps = uocChngOrderItemObjList.stream().collect(Collectors.groupingBy(UocChngOrderItemObj::getOtherChngValue));
        List<UocChngOrderItemObj> uocChngOrderItemObjsJS = chngOrderItemMaps.get("1");
        List<UocChngOrderItemObj> uocChngOrderItemObjsTT = chngOrderItemMaps.get("2");
        if (CollectionUtil.isNotEmpty(uocChngOrderItemObjsJS)) {
            uocShipOrderDo = this.convertShipOrderDo(reqBo, now, operId, uocChngOrderItemObjsJS);
            uocSaleOrderDo = this.convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjsJS);
            this.iUocSaleOrderModel.modifyItemRefuseCountConfirm(uocSaleOrderDo);
            this.iUocShipOrderModel.modifyItemRefuseCountConfirm(uocShipOrderDo);
        }
        if (CollectionUtil.isNotEmpty(uocChngOrderItemObjsTT)) {
            uocShipOrderDo = this.convertShipOrderDo(reqBo, now, operId, uocChngOrderItemObjsTT);
            uocSaleOrderDo = this.convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjsTT);
            this.iUocSaleOrderModel.modifyItemArriveCountConfirm(uocSaleOrderDo);
            this.iUocShipOrderModel.modifyItemArriveCountConfirm(uocShipOrderDo);
        }
        List<Long> shipItemIdList = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getShipOrderItemId).distinct().collect(Collectors.toList());
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setShipOrderItemIdList(shipItemIdList);
        List<UocShipOrderItem> shipOrderItemList = this.iUocShipOrderModel.getShipOrderItemList(uocShipOrderItemQryBo);
        if (CollectionUtil.isNotEmpty(shipOrderItemList)) {
            Map<Long, Long> shipItemToShipIdMaps = shipOrderItemList.stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, UocShipOrderItem::getShipOrderId));
            uocChngOrderItemObjList.forEach(uocChngOrderItemObj -> {
                UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
                Long shipOrderItemId = uocChngOrderItemObj.getShipOrderItemId();
                Long shipOrderId = (Long)shipItemToShipIdMaps.get(shipOrderItemId);
                uocShipOrderDo.setOrderId(uocChngOrderItemObj.getOrderId());
                uocShipOrderDo.setShipOrderId(shipOrderId);
                this.iUocShipOrderModel.modifyStatChngShipStatus(uocShipOrderDo);
            });
        }
    }

    private void refuse(UocChngOrderConfirmOrRefuseReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        this.iUocShipOrderModel.modifyItemChngCountRefuse(this.convertShipOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
        this.iUocSaleOrderModel.modifyBatchItemChngCountRefuse(this.convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
    }

    private void confirm(UocChngOrderConfirmOrRefuseReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        this.iUocShipOrderModel.modifyItemReturnCountConfirm(this.convertShipOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
        this.iUocSaleOrderModel.modifyBatchItemReturnCountConfirm(this.convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
    }

    private UocSaleOrderDo convertSaleOrderDo(UocChngOrderConfirmOrRefuseReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setUpdateOperId(operId);
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setOrderIdList(reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList()));
        uocSaleOrderDo.setSaleOrderItemsIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getSaleOrderItemId).collect(Collectors.toList()));
        return uocSaleOrderDo;
    }

    private UocShipOrderDo convertShipOrderDo(UocChngOrderConfirmOrRefuseReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList());
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setShipOrderItemIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getShipOrderItemId).collect(Collectors.toList()));
        uocShipOrderDo.setOrderIdList(orderIdList);
        uocShipOrderDo.setUpdateTime(now);
        uocShipOrderDo.setUpdateOperId(operId);
        return uocShipOrderDo;
    }

    private List<UocChngOrderDo> convertChngOrderDo(UocChngOrderConfirmOrRefuseReqBo reqBo, Date now, String operId) {
        String state = this.getState(reqBo);
        return reqBo.getChngOrderList().stream().map(uocChngOrderConfirmOrRefuseReqItemBo -> {
            UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
            uocChngOrderDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
            uocChngOrderDo.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
            uocChngOrderDo.setChngOrderState(state);
            uocChngOrderDo.setUpdateTime(now);
            uocChngOrderDo.setUpdateOperId(operId);
            uocChngOrderDo.setUpdateOperName(reqBo.getName());
            uocChngOrderDo.setRejectReason(reqBo.getRejectRemark());
            return uocChngOrderDo;
        }).collect(Collectors.toList());
    }

    private String getState(UocChngOrderConfirmOrRefuseReqBo reqBo) {
        if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            return "CHNG_CHNG_JJ";
        }
        return "CHNG_CHNG_QR";
    }

    private List<UocChngOrderItemObj> getListChngOrderItemObj(UocChngOrderConfirmOrRefuseReqBo reqBo) {
        List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getOrderId).collect(Collectors.toList());
        UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
        uocChngOrderItemObjQryBo.setChngOrderIdList(reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseReqItemBo::getChngOrderId).collect(Collectors.toList()));
        uocChngOrderItemObjQryBo.setOrderIdList(orderIdList);
        List<UocChngOrderItemObj> uocChngOrderItemObjList = this.iUocChngOrderModel.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
        if (CollectionUtils.isEmpty(uocChngOrderItemObjList)) {
            throw new BaseBusinessException("101008", "\u67e5\u8be2\u53d8\u66f4\u660e\u7ec6\u5bf9\u8c61\u4e3a\u7a7a");
        }
        return uocChngOrderItemObjList;
    }

    private void dealMap(UocChngOrderConfirmOrRefuseReqBo reqBo, Date now) {
        List chngOrderList = reqBo.getChngOrderList();
        chngOrderList.forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
            if (!CollectionUtils.isEmpty((Collection)uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList())) {
                UocChngOrderDo delChngOrderDo = new UocChngOrderDo();
                ArrayList<UocChngOrderMap> extParallelBoList = new ArrayList<UocChngOrderMap>();
                uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                    UocChngOrderMap uocChngOrderMap = new UocChngOrderMap();
                    uocChngOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
                    uocChngOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
                    uocChngOrderMap.setFieldCode(uocBaseExtParallelDeleteBo.getFieldCode());
                    uocChngOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                    uocChngOrderMap.setUpdateTime(now);
                    extParallelBoList.add(uocChngOrderMap);
                });
                delChngOrderDo.setUocChngOrderMapList(extParallelBoList);
                this.iUocChngOrderModel.updateInvalid(delChngOrderDo);
            }
            if (!CollectionUtils.isEmpty((Collection)uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList())) {
                UocChngOrderDo add = new UocChngOrderDo();
                UocChngOrderDo modify = new UocChngOrderDo();
                ArrayList<UocChngOrderMap> addList = new ArrayList<UocChngOrderMap>();
                ArrayList<UocChngOrderMap> modifyList = new ArrayList<UocChngOrderMap>();
                uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList().forEach(uocBaseExtParallelEditBo -> {
                    if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelEditBo.getOpFlag())) {
                        UocChngOrderMap addShipOrderMap = new UocChngOrderMap();
                        addShipOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
                        addShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                        addShipOrderMap.setFieldName(uocBaseExtParallelEditBo.getFieldName());
                        addShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                        addShipOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
                        addShipOrderMap.setId(IdUtil.nextId());
                        addShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
                        addShipOrderMap.setCreateTime(now);
                        addList.add(addShipOrderMap);
                    } else {
                        UocChngOrderMap updateShipOrderMap = new UocChngOrderMap();
                        updateShipOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
                        updateShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                        updateShipOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
                        updateShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                        updateShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                        updateShipOrderMap.setUpdateTime(now);
                        modifyList.add(updateShipOrderMap);
                    }
                });
                if (!CollectionUtils.isEmpty(addList)) {
                    add.setUocChngOrderMapList(addList);
                    this.iUocChngOrderModel.addChngOrderMap(add);
                }
                if (!CollectionUtils.isEmpty(modifyList)) {
                    modify.setUocChngOrderMapList(modifyList);
                    this.iUocChngOrderModel.updateBatchValue(modify);
                }
            }
            UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
            uocChngOrderDo.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
            uocChngOrderDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
            uocChngOrderDo.setChngOrderState(OP_FLAG_CONFIRM.equals(reqBo.getOpFlag()) ? "CHNG_CHNG_QR" : "CHNG_CHNG_JJ");
            uocChngOrderDo.setUpdateTime(now);
            uocChngOrderDo.setUpdateOperId(reqBo.getUserId().toString());
            this.iUocChngOrderModel.updateChngOrderMain(uocChngOrderDo);
        });
    }

    private void validateArg(UocChngOrderConfirmOrRefuseReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!OP_FLAG_CONFIRM.equals(reqBo.getOpFlag()) && !OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u53ea\u652f\u6301\u786e\u8ba4\u6216\u62d2\u7edd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getChngOrderList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u4fe1\u606f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBo.getChngOrderList().forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
            if (null == uocChngOrderConfirmOrRefuseReqItemBo.getOrderId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u4fe1\u606f\u7684\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u4fe1\u606f\u7684\u53d8\u66f4\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List chngOrderList = reqBo.getChngOrderList();
        chngOrderList.forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
            if (!CollectionUtils.isEmpty((Collection)uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList())) {
                uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException("100001", "\u8981\u5220\u9664\u7684\u6269\u5c55\u5c5e\u6027\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException("100001", "\u8981\u5220\u9664\u7684\u6269\u5c55\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                });
            }
            if (!CollectionUtils.isEmpty((Collection)uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList())) {
                uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList().forEach(uocBaseExtParallelDeleteBo -> {
                    if (null == uocBaseExtParallelDeleteBo.getOpFlag()) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u7f16\u8f91\u64cd\u4f5c\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag()) && !UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u7f16\u8f91\u64cd\u4f5c\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4ec5\u652f\u6301\u65b0\u589e\u548c\u4fee\u6539");
                    }
                    if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                        if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                            throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                            throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                    }
                    if (UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                        if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                            throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                            throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldValue())) {
                            throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                    }
                });
            }
        });
    }
}

