/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocNumChngOrderCreateHRService;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateHRReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateHRReqInspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateHRReqInspItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocNumChngOrderCreateHRRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocNumChngOrderCreateHRService"})
public class UocNumChngOrderCreateHRServiceImpl
implements UocNumChngOrderCreateHRService {
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocInspOrderModel uocInspOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @PostMapping(value={"createNumChng"})
    public UocNumChngOrderCreateHRRspBo createNumChng(@RequestBody UocNumChngOrderCreateHRReqBo reqBo) {
        this.validateArg(reqBo);
        String operId = reqBo.getUserId().toString();
        Date now = new Date();
        List<UocInspOrderItem> inspOrderItemList = this.getInspOrderList(reqBo);
        this.checkChngingCount(reqBo, inspOrderItemList);
        List<UocSaleOrderItem> saleOrderItems = this.getSaleOrderItemList(reqBo);
        UocChngOrderDo uocChngOrderDo = this.convertChngOrderDo(reqBo, operId, now, inspOrderItemList, saleOrderItems);
        this.iUocChngOrderModel.createChngOrder(uocChngOrderDo);
        for (UocNumChngOrderCreateHRReqInspBo uocNumChngOrderCreateReqInspBo : reqBo.getChngItemList()) {
            this.uocInspOrderModel.modifyInspOrderItemChngingCount(this.convertInspOrderDo(reqBo, uocNumChngOrderCreateReqInspBo, operId, now));
            this.iUocSaleOrderModel.modifyBatchItemChngingCount(this.convertSaleOrderDo(reqBo, uocNumChngOrderCreateReqInspBo, inspOrderItemList, operId, now));
        }
        UocNumChngOrderCreateHRRspBo uocNumChngOrderCreateRspBo = UocRu.success(UocNumChngOrderCreateHRRspBo.class);
        uocNumChngOrderCreateRspBo.setChngOrderId(uocChngOrderDo.getChngOrderId());
        uocNumChngOrderCreateRspBo.getInspOrderIdList().addAll(reqBo.getChngItemList().stream().map(UocNumChngOrderCreateHRReqInspBo::getInspOrderId).collect(Collectors.toList()));
        return uocNumChngOrderCreateRspBo;
    }

    private UocSaleOrderDo convertSaleOrderDo(UocNumChngOrderCreateHRReqBo reqBo, UocNumChngOrderCreateHRReqInspBo uocNumChngOrderCreateReqInspBo, List<UocInspOrderItem> inspOrderItemList, String operId, Date now) {
        Map<Long, UocInspOrderItem> inspOrderItemMap = inspOrderItemList.stream().collect(Collectors.toMap(UocInspOrderItem::getInspOrderItemId, o -> o));
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setUpdateOperId(operId);
        ArrayList<UocSaleOrderItem> saleOrderItems = new ArrayList<UocSaleOrderItem>();
        uocNumChngOrderCreateReqInspBo.getInspOrderItemList().forEach(x -> {
            UocInspOrderItem uocInspOrderItem = (UocInspOrderItem)inspOrderItemMap.get(x.getInspOrderItemId());
            Long saleOrderItemId = uocInspOrderItem.getSaleOrderItemId();
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setSaleOrderItemId(saleOrderItemId);
            uocSaleOrderItem.setChngingCount(x.getChngCount());
            uocSaleOrderItem.setUpdateTime(now);
            uocSaleOrderItem.setUpdateOperId(operId);
            saleOrderItems.add(uocSaleOrderItem);
        });
        uocSaleOrderDo.setSaleOrderItems(saleOrderItems);
        return uocSaleOrderDo;
    }

    private UocInspOrderDo convertInspOrderDo(UocNumChngOrderCreateHRReqBo reqBo, UocNumChngOrderCreateHRReqInspBo uocNumChngOrderCreateReqInspBo, String operId, Date now) {
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setInspOrderId(uocNumChngOrderCreateReqInspBo.getInspOrderId());
        uocInspOrderDo.setOrderId(reqBo.getOrderId());
        uocInspOrderDo.setUpdateOperId(operId);
        uocInspOrderDo.setUpdateTime(now);
        ArrayList<UocInspOrderItem> uocInspOrderItemList = new ArrayList<UocInspOrderItem>();
        uocNumChngOrderCreateReqInspBo.getInspOrderItemList().forEach(inspItemBo -> {
            UocInspOrderItem uocInspOrderItem = new UocInspOrderItem();
            uocInspOrderItem.setInspOrderItemId(inspItemBo.getInspOrderItemId());
            uocInspOrderItem.setChngingCount(inspItemBo.getChngCount());
            uocInspOrderItem.setUpdateOperId(operId);
            uocInspOrderItem.setUpdateTime(now);
            uocInspOrderItemList.add(uocInspOrderItem);
        });
        uocInspOrderDo.setUocInspOrderItemList(uocInspOrderItemList);
        return uocInspOrderDo;
    }

    private String getChngOrderNo(UocNumChngOrderCreateHRReqBo reqBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("101002", "\u67e5\u8be2\u9a8c\u6536\u5355\u4e3a\u7a7a");
        }
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setBusiType(UocConstant.BUSI_TYPE.NUM);
        uocChngOrderQryBo.setOrderSource(uocSaleOrderDo.getOrderSource());
        UocChngOrderDo uocChngOrderDo = this.iUocChngOrderModel.getChngOrderNo(uocChngOrderQryBo);
        return uocChngOrderDo.getChngOrderNo();
    }

    private UocChngOrderDo convertChngOrderDo(UocNumChngOrderCreateHRReqBo reqBo, String operId, Date now, List<UocInspOrderItem> inspOrderItemList, List<UocSaleOrderItem> saleOrderItems) {
        Map<Long, UocInspOrderItem> inspOrderItemMap = inspOrderItemList.stream().collect(Collectors.toMap(UocInspOrderItem::getInspOrderItemId, o -> o));
        Map<Long, UocSaleOrderItem> saleOrderItemMap = saleOrderItems.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
        uocChngOrderDo.setChngOrderId(IdUtil.nextId());
        uocChngOrderDo.setChngOrderState("CHNG_CHNG_QRZ");
        uocChngOrderDo.setCreateOperId(operId);
        uocChngOrderDo.setTenantId(reqBo.getTenantId());
        uocChngOrderDo.setCreateTime(now);
        uocChngOrderDo.setCreateOperName(reqBo.getName());
        uocChngOrderDo.setCreateOperMobile(reqBo.getCellphone());
        uocChngOrderDo.setOrderId(reqBo.getOrderId());
        uocChngOrderDo.setBusiType(UocConstant.BUSI_TYPE.NUM);
        uocChngOrderDo.setRemark(reqBo.getRemark());
        uocChngOrderDo.setChngOrderNo(this.getChngOrderNo(reqBo));
        ArrayList<UocChngOrderObj> uocChngOrderObjList = new ArrayList<UocChngOrderObj>();
        for (UocNumChngOrderCreateHRReqInspBo uocNumChngOrderCreateHRReqInspBo : reqBo.getChngItemList()) {
            UocChngOrderObj uocChngOrderObj = new UocChngOrderObj();
            uocChngOrderObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
            uocChngOrderObj.setOrderId(reqBo.getOrderId());
            uocChngOrderObj.setSaleOrderId(reqBo.getSaleOrderId());
            uocChngOrderObj.setInspOrderId(uocNumChngOrderCreateHRReqInspBo.getInspOrderId());
            uocChngOrderObj.setChngOrderObjId(IdUtil.nextId());
            uocChngOrderObj.setChngType(UocConstant.BUSI_TYPE.NUM);
            uocChngOrderObj.setCreateOperId(operId);
            uocChngOrderObj.setCreateTime(now);
            ArrayList<UocChngOrderItemObj> uocChngOrderItemObjList = new ArrayList<UocChngOrderItemObj>();
            uocChngOrderObj.setChngNum(BigDecimal.ZERO);
            uocChngOrderObj.setChngFee(BigDecimal.ZERO);
            uocNumChngOrderCreateHRReqInspBo.getInspOrderItemList().forEach(x -> {
                UocInspOrderItem uocInspOrderItem = (UocInspOrderItem)inspOrderItemMap.get(x.getInspOrderItemId());
                UocSaleOrderItem saleOrderItem = (UocSaleOrderItem)saleOrderItemMap.get(uocInspOrderItem.getSaleOrderItemId());
                UocChngOrderItemObj uocChngOrderItemObj = new UocChngOrderItemObj();
                uocChngOrderItemObj.setChngNum(x.getChngCount());
                uocChngOrderItemObj.setInspOrderItemId(x.getInspOrderItemId());
                uocChngOrderItemObj.setChngFee(x.getChngCount().multiply(saleOrderItem.getSalePrice()));
                uocChngOrderItemObj.setChngOrderId(uocChngOrderObj.getChngOrderId());
                uocChngOrderItemObj.setChngOrderObjId(uocChngOrderObj.getChngOrderObjId());
                uocChngOrderItemObj.setSaleOrderItemId(uocInspOrderItem.getSaleOrderItemId());
                uocChngOrderItemObj.setChngType(UocConstant.BUSI_TYPE.NUM);
                uocChngOrderItemObj.setOrderId(reqBo.getOrderId());
                uocChngOrderItemObj.setId(IdUtil.nextId());
                uocChngOrderItemObj.setCreateOperId(operId);
                uocChngOrderItemObj.setCreateTime(now);
                uocChngOrderItemObjList.add(uocChngOrderItemObj);
                uocChngOrderObj.setChngNum(uocChngOrderObj.getChngNum().add(x.getChngCount()));
                uocChngOrderObj.setChngFee(uocChngOrderObj.getChngNum().multiply(saleOrderItem.getSalePrice()));
            });
            uocChngOrderObj.setUocChngOrderItemObjList(uocChngOrderItemObjList);
            uocChngOrderObjList.add(uocChngOrderObj);
        }
        uocChngOrderDo.setUocChngOrderObjList(uocChngOrderObjList);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtParallelBoList())) {
            List<UocChngOrderMap> uocChngOrderMapList = UocRu.jsl(reqBo.getExtParallelBoList(), UocChngOrderMap.class);
            uocChngOrderMapList.forEach(uocChngOrderMap -> {
                uocChngOrderMap.setChngOrderId(uocChngOrderDo.getChngOrderId());
                uocChngOrderMap.setOrderId(uocChngOrderDo.getOrderId());
                uocChngOrderMap.setCreateOperId(operId);
                uocChngOrderMap.setCreateTime(now);
                uocChngOrderMap.setId(IdUtil.nextId());
            });
            uocChngOrderDo.setUocChngOrderMapList(uocChngOrderMapList);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOrderAccessoryBoList())) {
            List<UocOrderAccessory> uocOrderAccessoryList = UocRu.jsl(reqBo.getOrderAccessoryBoList(), UocOrderAccessory.class);
            uocOrderAccessoryList.forEach(uocOrderAccessory -> {
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setCreateTime(now);
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
                uocOrderAccessory.setAttachmentType(1);
                uocOrderAccessory.setObjId(uocChngOrderDo.getChngOrderId());
            });
            uocChngOrderDo.setOrderAccessoryBoList(uocOrderAccessoryList);
        }
        return uocChngOrderDo;
    }

    private List<UocSaleOrderItem> getSaleOrderItemList(UocNumChngOrderCreateHRReqBo reqBo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (CollectionUtils.isEmpty(saleOrderItemList)) {
            throw new BaseBusinessException("101006", "\u67e5\u8be2\u9500\u552e\u5355\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a");
        }
        return saleOrderItemList;
    }

    private void checkChngingCount(UocNumChngOrderCreateHRReqBo reqBo, List<UocInspOrderItem> inspOrderItemList) {
        if (CollectionUtil.isNotEmpty(inspOrderItemList)) {
            Map<Long, UocInspOrderItem> inspOrderItemMap = inspOrderItemList.stream().collect(Collectors.toMap(UocInspOrderItem::getInspOrderItemId, o -> o));
            reqBo.getChngItemList().forEach(chngOrderCreateHRReqInspBo -> chngOrderCreateHRReqInspBo.getInspOrderItemList().forEach(uocNumChngOrderCreateHRReqInspItemBo -> {
                Long inspOrderItemId = uocNumChngOrderCreateHRReqInspItemBo.getInspOrderItemId();
                UocInspOrderItem uocInspOrderItem = (UocInspOrderItem)inspOrderItemMap.get(inspOrderItemId);
                if (uocNumChngOrderCreateHRReqInspItemBo.getChngCount().compareTo(BigDecimal.ZERO) < 0 || uocNumChngOrderCreateHRReqInspItemBo.getChngCount().compareTo(uocInspOrderItem.getInspCount()) > 0) {
                    throw new BaseBusinessException("101008", "\u53d8\u66f4\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\u9a8c\u6536\u6570\u91cf");
                }
                UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
                uocChngOrderItemObjQryBo.setInspOrderItemId(inspOrderItemId);
                uocChngOrderItemObjQryBo.setChngType(UocConstant.BUSI_TYPE.NUM);
                List<UocChngOrderItemObj> listChngOrderItemObj = this.iUocChngOrderModel.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
                if (CollectionUtil.isNotEmpty(listChngOrderItemObj)) {
                    String chngOrderState;
                    Long chngOrderId = listChngOrderItemObj.get(0).getChngOrderId();
                    UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
                    uocChngOrderQryBo.setChngOrderId(chngOrderId);
                    uocChngOrderQryBo.setOrderId(reqBo.getOrderId());
                    UocChngOrderDo chngOrder = this.iUocChngOrderModel.getChngOrder(uocChngOrderQryBo);
                    if (ObjectUtil.isNotEmpty((Object)chngOrder) && !"CHNG_CHNG_JJ".equals(chngOrderState = chngOrder.getChngOrderState())) {
                        throw new BaseBusinessException("101008", "\u5df2\u5b58\u5728\u5f02\u5e38\u53d8\u66f4");
                    }
                }
            }));
        }
    }

    private List<UocInspOrderItem> getInspOrderList(UocNumChngOrderCreateHRReqBo reqBo) {
        ArrayList<UocInspOrderItem> inspOrderItemList = new ArrayList<UocInspOrderItem>();
        for (UocNumChngOrderCreateHRReqInspBo uocNumChngOrderCreateReqShipBo : reqBo.getChngItemList()) {
            UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
            uocInspOrderItemQryBo.setInspOrderItemIdList(uocNumChngOrderCreateReqShipBo.getInspOrderItemList().stream().map(UocNumChngOrderCreateHRReqInspItemBo::getInspOrderItemId).collect(Collectors.toList()));
            uocInspOrderItemQryBo.setOrderId(reqBo.getOrderId());
            uocInspOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
            UocInspOrderDo uocInspOrderDo = this.uocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
            if (CollectionUtils.isEmpty(uocInspOrderDo.getUocInspOrderItemList())) {
                throw new BaseBusinessException("101006", "\u67e5\u8be2\u9a8c\u6536\u5355\u660e\u7ec6\u5217\u8868\u4e3a\u7a7a");
            }
            inspOrderItemList.addAll(uocInspOrderDo.getUocInspOrderItemList());
        }
        return inspOrderItemList;
    }

    private void validateArg(UocNumChngOrderCreateHRReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getChngItemList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u4fe1\u606f\u5217\u8868\u4e3a\u7a7a");
        }
        reqBo.getChngItemList().forEach(uocNumChngOrderCreateReqItemBo -> {
            if (null == uocNumChngOrderCreateReqItemBo.getInspOrderId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u9a8c\u6536\u5355ID\u4e3a\u7a7a");
            }
            if (null == uocNumChngOrderCreateReqItemBo.getInspOrderItemList()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u9a8c\u6536\u5bf9\u8c61\u4e3a\u7a7a");
            }
            uocNumChngOrderCreateReqItemBo.getInspOrderItemList().forEach(x -> {
                if (null == x.getInspOrderItemId()) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u9a8c\u6536\u5355\u660e\u7ec6ID\u4e3a\u7a7a");
                }
                if (null == x.getChngCount()) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u6570\u91cf\u4e3a\u7a7a");
                }
            });
        });
    }
}

