/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.saleorder.UocGetSaleOrderItemsService;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderItemsServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderItemsServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderItemsServiceRspItemBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.saleorder.UocGetSaleOrderItemsService"})
public class UocGetSaleOrderItemsServiceImpl
implements UocGetSaleOrderItemsService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @PostMapping(value={"getSaleOrderItems"})
    public UocGetSaleOrderItemsServiceRspBo getSaleOrderItems(@RequestBody UocGetSaleOrderItemsServiceReqBo reqBo) {
        this.validateParam(reqBo);
        UocGetSaleOrderItemsServiceRspBo rspBo = new UocGetSaleOrderItemsServiceRspBo();
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = UocRu.js(reqBo, UocSaleOrderItemQryBo.class);
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (!CollectionUtils.isEmpty(saleOrderItemList)) {
            List<UocGetSaleOrderItemsServiceRspItemBo> saleOrderItems = UocRu.jsl(saleOrderItemList, UocGetSaleOrderItemsServiceRspItemBo.class);
            rspBo.setSaleOrderItems(saleOrderItems);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void validateParam(UocGetSaleOrderItemsServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getSaleOrderId() == null) {
            throw new BaseBusinessException("100001", "\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException("100001", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

