/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocChngOrderConfirmOrRefuseHRService;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseHRReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseHRReqItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseHRRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocChngOrderConfirmOrRefuseHRService"})
public class UocChngOrderConfirmOrRefuseHRServiceImpl
implements UocChngOrderConfirmOrRefuseHRService {
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    private static final Integer OP_FLAG_CONFIRM = 1;
    private static final Integer OP_FLAG_REFUSE = 0;
    @Autowired
    private IUocCommonModel iUocCommonModel;

    @PostMapping(value={"dealConfirmOrRefuse"})
    public UocChngOrderConfirmOrRefuseHRRspBo dealConfirmOrRefuse(@RequestBody UocChngOrderConfirmOrRefuseHRReqBo reqBo) {
        UocChngOrderConfirmOrRefuseHRRspBo rsp = UocRu.success(UocChngOrderConfirmOrRefuseHRRspBo.class);
        this.validateArg(reqBo);
        String operId = reqBo.getUserId().toString();
        Date now = new Date();
        List<UocChngOrderItemObj> uocChngOrderItemObjList = this.getListChngOrderItemObj(reqBo);
        this.iUocChngOrderModel.modifyBatchChngOrderState(this.convertChngOrderDo(reqBo, now, operId));
        if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
            this.confirm(reqBo, operId, now, uocChngOrderItemObjList);
        }
        if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            this.refuse(reqBo, operId, now, uocChngOrderItemObjList);
        }
        reqBo.getChngOrderList().forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
            UocCommonDo uocCommonDo = new UocCommonDo();
            ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(uocChngOrderConfirmOrRefuseReqItemBo.getTaskId());
            taskBos.add(taskBo);
            uocCommonDo.setCompleteTaskInfos(taskBos);
            uocCommonDo.setUserId(11111L);
            uocCommonDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
            this.iUocCommonModel.dealTask(uocCommonDo);
        });
        this.dealMap(reqBo, now);
        this.buildSyncRsp(reqBo, rsp, uocChngOrderItemObjList);
        return rsp;
    }

    private void buildSyncRsp(UocChngOrderConfirmOrRefuseHRReqBo reqBo, UocChngOrderConfirmOrRefuseHRRspBo rspBo, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        List<Long> saleOrderItemIds = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getSaleOrderItemId).collect(Collectors.toList());
        List<Long> inspOrderItemIds = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getInspOrderItemId).collect(Collectors.toList());
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIds);
        List<UocSaleOrderItem> saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        rspBo.getSaleOrderIdList().addAll(saleOrderItemList.stream().map(x -> x.getSaleOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList()));
        UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
        uocInspOrderItemQryBo.setInspOrderItemIdList(inspOrderItemIds);
        UocInspOrderDo uocInspOrderDo = this.iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
        rspBo.getInspOrderIdList().addAll(uocInspOrderDo.getUocInspOrderItemList().stream().map(x -> x.getInspOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList()));
        reqBo.getChngOrderList().forEach(x -> rspBo.getChngOrderIdList().add(x.getChngOrderId() + "-" + x.getOrderId()));
    }

    private void refuse(UocChngOrderConfirmOrRefuseHRReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        this.iUocInspOrderModel.modifyItemChngCountRefuse(this.convertInspOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
        this.iUocSaleOrderModel.modifyItemChngCountRefuse(this.convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
    }

    private void confirm(UocChngOrderConfirmOrRefuseHRReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        this.iUocInspOrderModel.modifyItemChngCountConfirm(this.convertInspOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
        this.iUocSaleOrderModel.modifyItemChngCountConfirm(this.convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
    }

    private UocSaleOrderDo convertSaleOrderDo(UocChngOrderConfirmOrRefuseHRReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setUpdateOperId(operId);
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setOrderIdList(reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseHRReqItemBo::getOrderId).collect(Collectors.toList()));
        uocSaleOrderDo.setSaleOrderItemsIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getSaleOrderItemId).collect(Collectors.toList()));
        return uocSaleOrderDo;
    }

    private UocInspOrderDo convertInspOrderDo(UocChngOrderConfirmOrRefuseHRReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseHRReqItemBo::getOrderId).collect(Collectors.toList());
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setInspOrderItemsIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getInspOrderItemId).collect(Collectors.toList()));
        uocInspOrderDo.setOrderIdList(orderIdList);
        uocInspOrderDo.setUpdateTime(now);
        uocInspOrderDo.setUpdateOperId(operId);
        return uocInspOrderDo;
    }

    private List<UocChngOrderDo> convertChngOrderDo(UocChngOrderConfirmOrRefuseHRReqBo reqBo, Date now, String operId) {
        String state = this.getState(reqBo);
        return reqBo.getChngOrderList().stream().map(uocChngOrderConfirmOrRefuseReqItemBo -> {
            UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
            uocChngOrderDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
            uocChngOrderDo.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
            uocChngOrderDo.setChngOrderState(state);
            uocChngOrderDo.setUpdateTime(now);
            uocChngOrderDo.setUpdateOperId(operId);
            uocChngOrderDo.setUpdateOperName(reqBo.getName());
            uocChngOrderDo.setRejectReason(reqBo.getRejectRemark());
            return uocChngOrderDo;
        }).collect(Collectors.toList());
    }

    private String getState(UocChngOrderConfirmOrRefuseHRReqBo reqBo) {
        if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            return "CHNG_CHNG_JJ";
        }
        return "CHNG_CHNG_QR";
    }

    private List<UocChngOrderItemObj> getListChngOrderItemObj(UocChngOrderConfirmOrRefuseHRReqBo reqBo) {
        List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseHRReqItemBo::getOrderId).collect(Collectors.toList());
        UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
        uocChngOrderItemObjQryBo.setChngOrderIdList(reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseHRReqItemBo::getChngOrderId).collect(Collectors.toList()));
        uocChngOrderItemObjQryBo.setOrderIdList(orderIdList);
        List<UocChngOrderItemObj> uocChngOrderItemObjList = this.iUocChngOrderModel.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
        if (CollectionUtils.isEmpty(uocChngOrderItemObjList)) {
            throw new BaseBusinessException("101008", "\u67e5\u8be2\u53d8\u66f4\u660e\u7ec6\u5bf9\u8c61\u4e3a\u7a7a");
        }
        return uocChngOrderItemObjList;
    }

    private void dealMap(UocChngOrderConfirmOrRefuseHRReqBo reqBo, Date now) {
        List chngOrderList = reqBo.getChngOrderList();
        chngOrderList.forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
            if (!CollectionUtils.isEmpty((Collection)uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList())) {
                UocChngOrderDo delChngOrderDo = new UocChngOrderDo();
                ArrayList<UocChngOrderMap> extParallelBoList = new ArrayList<UocChngOrderMap>();
                uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                    UocChngOrderMap uocChngOrderMap = new UocChngOrderMap();
                    uocChngOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
                    uocChngOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
                    uocChngOrderMap.setFieldCode(uocBaseExtParallelDeleteBo.getFieldCode());
                    uocChngOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                    uocChngOrderMap.setUpdateTime(now);
                    extParallelBoList.add(uocChngOrderMap);
                });
                delChngOrderDo.setUocChngOrderMapList(extParallelBoList);
                this.iUocChngOrderModel.updateInvalid(delChngOrderDo);
            }
            if (!CollectionUtils.isEmpty((Collection)uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList())) {
                UocChngOrderDo add = new UocChngOrderDo();
                UocChngOrderDo modify = new UocChngOrderDo();
                ArrayList<UocChngOrderMap> addList = new ArrayList<UocChngOrderMap>();
                ArrayList<UocChngOrderMap> modifyList = new ArrayList<UocChngOrderMap>();
                uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList().forEach(uocBaseExtParallelEditBo -> {
                    if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelEditBo.getOpFlag())) {
                        UocChngOrderMap addShipOrderMap = new UocChngOrderMap();
                        addShipOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
                        addShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                        addShipOrderMap.setFieldName(uocBaseExtParallelEditBo.getFieldName());
                        addShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                        addShipOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
                        addShipOrderMap.setId(IdUtil.nextId());
                        addShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
                        addShipOrderMap.setCreateTime(now);
                        addList.add(addShipOrderMap);
                    } else {
                        UocChngOrderMap updateShipOrderMap = new UocChngOrderMap();
                        updateShipOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
                        updateShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                        updateShipOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
                        updateShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                        updateShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                        updateShipOrderMap.setUpdateTime(now);
                        modifyList.add(updateShipOrderMap);
                    }
                });
                if (!CollectionUtils.isEmpty(addList)) {
                    add.setUocChngOrderMapList(addList);
                    this.iUocChngOrderModel.addChngOrderMap(add);
                }
                if (!CollectionUtils.isEmpty(modifyList)) {
                    modify.setUocChngOrderMapList(modifyList);
                    this.iUocChngOrderModel.updateBatchValue(modify);
                }
            }
            UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
            uocChngOrderDo.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
            uocChngOrderDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
            uocChngOrderDo.setChngOrderState(OP_FLAG_CONFIRM.equals(reqBo.getOpFlag()) ? "CHNG_CHNG_QR" : "CHNG_CHNG_JJ");
            uocChngOrderDo.setUpdateTime(now);
            uocChngOrderDo.setUpdateOperId(reqBo.getUserId().toString());
            this.iUocChngOrderModel.updateChngOrderMain(uocChngOrderDo);
        });
    }

    private void validateArg(UocChngOrderConfirmOrRefuseHRReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (!OP_FLAG_CONFIRM.equals(reqBo.getOpFlag()) && !OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u64cd\u4f5c\u53ea\u652f\u6301\u786e\u8ba4\u6216\u62d2\u7edd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getChngOrderList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u4fe1\u606f\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBo.getChngOrderList().forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
            if (null == uocChngOrderConfirmOrRefuseReqItemBo.getOrderId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u4fe1\u606f\u7684\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u53d8\u66f4\u4fe1\u606f\u7684\u53d8\u66f4\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List chngOrderList = reqBo.getChngOrderList();
        chngOrderList.forEach(uocChngOrderConfirmOrRefuseHRReqItemBo -> {
            if (!CollectionUtils.isEmpty((Collection)uocChngOrderConfirmOrRefuseHRReqItemBo.getExtDeleteList())) {
                uocChngOrderConfirmOrRefuseHRReqItemBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException("100001", "\u8981\u5220\u9664\u7684\u6269\u5c55\u5c5e\u6027\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException("100001", "\u8981\u5220\u9664\u7684\u6269\u5c55\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                });
            }
            if (!CollectionUtils.isEmpty((Collection)uocChngOrderConfirmOrRefuseHRReqItemBo.getExtEditList())) {
                uocChngOrderConfirmOrRefuseHRReqItemBo.getExtEditList().forEach(uocBaseExtParallelDeleteBo -> {
                    if (null == uocBaseExtParallelDeleteBo.getOpFlag()) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u7f16\u8f91\u64cd\u4f5c\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (!UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag()) && !UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                        throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u7f16\u8f91\u64cd\u4f5c\u65f6\uff0c\u64cd\u4f5c\u7c7b\u578b\u4ec5\u652f\u6301\u65b0\u589e\u548c\u4fee\u6539");
                    }
                    if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                        if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                            throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                            throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                    }
                    if (UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                        if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                            throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldCode())) {
                            throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                        if (StringUtils.isBlank((CharSequence)uocBaseExtParallelDeleteBo.getFieldValue())) {
                            throw new BaseBusinessException("100001", "\u5bf9\u6269\u5c55\u5c5e\u6027\u505a\u4fee\u6539\u64cd\u4f5c\u65f6\uff0c\u5c5e\u6027\u503c\u4e0d\u80fd\u4e3a\u7a7a");
                        }
                    }
                });
            }
        });
    }
}

