/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.service.domainservice.UocQryAfOrderShopAddressService;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryAfOrderShopAddressBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryAfOrderShopAddressReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryAfOrderShopAddressRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocQryAfOrderShopAddressService"})
public class UocQryAfOrderShopAddressServiceImpl
implements UocQryAfOrderShopAddressService {
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocAfOrderModel iUocAfOrderModel;

    @PostMapping(value={"qryAfOrderShopAddress"})
    public UocQryAfOrderShopAddressRspBo qryAfOrderShopAddress(@RequestBody UocQryAfOrderShopAddressReqBo reqBo) {
        UocOrdLogisticsRela logisticsRela;
        this.validataArg(reqBo);
        UocQryAfOrderShopAddressRspBo rspBo = new UocQryAfOrderShopAddressRspBo();
        UocAfOrder afOrder = this.getAfOrder(reqBo);
        if (ObjectUtil.isNotNull((Object)afOrder) && ObjectUtil.isNotNull((Object)(logisticsRela = this.getLogisticsRela(afOrder)))) {
            rspBo.setAddress(UocRu.js(logisticsRela, UocQryAfOrderShopAddressBo.class));
        }
        return rspBo;
    }

    private UocOrdLogisticsRela getLogisticsRela(UocAfOrder afOrder) {
        UocOrdLogisticsRelaQryBo relaQryBo = new UocOrdLogisticsRelaQryBo();
        relaQryBo.setOrderId(afOrder.getOrderId());
        if (ObjectUtil.isEmpty((Object)afOrder.getExtField1())) {
            return new UocOrdLogisticsRela();
        }
        relaQryBo.setContactId(Long.parseLong(afOrder.getExtField1()));
        UocOrdLogisticsRela logisticsRela = this.iUocOrderModel.qryOrderLogisticsRela(relaQryBo);
        return logisticsRela;
    }

    private UocAfOrder getAfOrder(UocQryAfOrderShopAddressReqBo reqBo) {
        UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
        uocAfOrderQryBo.setAfOrderId(reqBo.getAfOrderId());
        uocAfOrderQryBo.setOrderId(reqBo.getOrderId());
        return this.iUocAfOrderModel.getAfOrderById(uocAfOrderQryBo);
    }

    public void validataArg(UocQryAfOrderShopAddressReqBo reqBo) {
        if (ObjectUtil.isNull((Object)reqBo)) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getAfOrderId())) {
            throw new BaseBusinessException("100001", "\u552e\u540e\u5546\u5bb6\u6536\u4ef6\u5730\u5740\u67e5\u8be2\u5931\u8d25\uff1a\u552e\u540e\u5355ID[afOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new BaseBusinessException("100001", "\u552e\u540e\u5546\u5bb6\u6536\u4ef6\u5730\u5740\u67e5\u8be2\u5931\u8d25\uff1a\u8ba2\u5355ID[orderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

