package com.tydic.dyc.oc.model.order.sub;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 标题:UocConfEvaluatePo
 * 说明:订单评价配置表
 * 时间:2022-02-23 20:57
 * 作者:罗有
 **/
@Data
public class UocConfEvaluate implements Serializable {
	private static final long serialVersionUID = -3227116439102432998L;

	@DocField(value = "评价ID 主键")
	private Long evaluateId;

	@DocField(value = "应用单位编码")
	private String applicationUnitNo;

	@DocField(value = "应用单位名称")
	private String applicationUnitName;

	@DocField(value = "评价截止时间 毫秒数")
	private Long evaluationDeadline;

	@DocField(value = "系统自动好评状态：0：否；1：是")
	private Integer systemAutomaticPraise;

	@DocField(value = "是否允许追评：0：否；1：是")
	private Integer whetherReview;

	@DocField(value = "追评截止时间 毫秒数")
	private Long reviewDeadline;

	@DocField(value = "操作时间")
	private Date operatingTime;

	@DocField(value = "操作人ID")
	private String operatorId;

	@DocField(value = "操作人名称")
	private String operatorName;

	@DocField(value = "排序")
	private String orderBy;

}
