/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspItemMap;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderMap;
import com.tydic.dyc.oc.model.insporder.sub.UocShipInspRel;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocConfEffectiveQryBo;
import com.tydic.dyc.oc.model.order.sub.UocConfEffective;
import com.tydic.dyc.oc.model.order.sub.UocOrderRel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.UocArrvalAcceptanceService;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArrvalAcceptanceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateInspOrderReqShipBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCreateInspOrderReqShipItemBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocArrvalAcceptanceService"})
public class UocArrvalAcceptanceServiceImpl
implements UocArrvalAcceptanceService {
    private static final Logger log = LoggerFactory.getLogger(UocArrvalAcceptanceServiceImpl.class);
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocCommonModel iUocCommonModel;
    private static final String OP_FLAG_YES = "1";
    private static final String OP_FLAG_NO = "0";
    private static final String EC_IMPORT = "2";
    private static final String SUP_NO = "0";

    @PostMapping(value={"dealArrvalAcceptance"})
    public UocArrvalAcceptanceRspBo dealArrvalAcceptance(@RequestBody UocArrvalAcceptanceReqBo reqBo) {
        this.validateArg(reqBo);
        UocShipOrderDo uocShipOrderDo = this.getShipOrderItemList(reqBo);
        Map<Long, UocShipOrderItem> uocShipOrderItemMap = uocShipOrderDo.getShipOrderItemBoList().stream().collect(Collectors.toMap(UocShipOrderItem::getShipOrderItemId, o -> o));
        List<UocSaleOrderItem> uocSaleOrderItemList = this.getUocSaleOrderItem(reqBo, uocShipOrderDo.getShipOrderItemBoList().stream().map(UocShipOrderItem::getSaleOrderItemId).distinct().collect(Collectors.toList()));
        Map<Long, UocSaleOrderItem> uocSaleOrderItemMap = uocSaleOrderItemList.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        Map<Long, Boolean> shipOrderInspStateMap = this.checkShipOrderInspState(reqBo, uocShipOrderItemMap, uocSaleOrderItemMap);
        Date now = new Date();
        String operId = reqBo.getUserId().toString();
        this.modifyShipOrder(reqBo, now, operId, shipOrderInspStateMap);
        this.iUocSaleOrderModel.modifyBatchItemInspCount(this.convertSaleOrderDo(reqBo, now, uocShipOrderItemMap, operId));
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        this.iUocSaleOrderModel.modifyInspSuper(uocSaleOrderDo);
        if (reqBo.getClosePennyDiff() != null && reqBo.getClosePennyDiff().booleanValue()) {
            UocSaleOrderDo uocSaleOrderDo1 = new UocSaleOrderDo();
            uocSaleOrderDo1.setOrderId(reqBo.getOrderId());
            uocSaleOrderDo1.setSaleOrderId(reqBo.getSaleOrderId());
            uocSaleOrderDo1.setClosePennyDiff(UocConstant.CLOSE_PENNY_DIFF.YES);
            uocSaleOrderDo1.setUpdateOperId(reqBo.getUserId().toString());
            uocSaleOrderDo1.setUpdateOperName(reqBo.getName());
            uocSaleOrderDo1.setUpdateTime(now);
            this.iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo1);
        }
        UocInspOrderDo uocInspOrderDo = this.convertInspOrderDo(reqBo, now, uocShipOrderItemMap, operId);
        this.iUocInspOrderModel.createInspOrder(uocInspOrderDo);
        boolean inspFinish = this.judgeSaleOrderFinishFlag(reqBo);
        if (inspFinish) {
            this.modifySaleOrderState(reqBo);
            UocCommonDo uocCommonDo = new UocCommonDo();
            ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(reqBo.getTaskId());
            taskBo.setStepId(reqBo.getStepId());
            taskBos.add(taskBo);
            uocCommonDo.setCompleteTaskInfos(taskBos);
            uocCommonDo.setUserId(reqBo.getUserId());
            uocCommonDo.setOrderId(reqBo.getOrderId());
            log.info("\u5168\u90e8\u5230\u8d27\u9a8c\u6536\u540e\u63d0\u4ea4\u8ba2\u5355\u6d41\u7a0b\u4efb\u52a1\u5165\u53c2\uff1a{}" + JSON.toJSONString((Object)uocCommonDo));
            this.iUocCommonModel.dealTask(uocCommonDo);
        }
        UocArrvalAcceptanceRspBo uocArrvalAcceptanceRspBo = UocRu.success(UocArrvalAcceptanceRspBo.class);
        uocArrvalAcceptanceRspBo.setFinish(Boolean.valueOf(inspFinish));
        uocArrvalAcceptanceRspBo.setOpFlag(inspFinish ? OP_FLAG_YES : "0");
        uocArrvalAcceptanceRspBo.setInspOrderId(uocInspOrderDo.getInspOrderId());
        uocArrvalAcceptanceRspBo.setShipOrderInspStateMap(shipOrderInspStateMap);
        UocCommonDo uocCommonDo = new UocCommonDo();
        ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo>();
        UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
        taskBo.setTaskId(((UocCreateInspOrderReqShipBo)reqBo.getShipOrderList().get(0)).getTaskId());
        taskBo.setStepId(((UocCreateInspOrderReqShipBo)reqBo.getShipOrderList().get(0)).getStepId());
        taskBos.add(taskBo);
        uocCommonDo.setCompleteTaskInfos(taskBos);
        uocCommonDo.setUserId(reqBo.getUserId());
        uocCommonDo.setOrderId(reqBo.getOrderId());
        this.iUocCommonModel.dealTask(uocCommonDo);
        return uocArrvalAcceptanceRspBo;
    }

    private void modifySaleOrderState(UocArrvalAcceptanceReqBo reqBo) {
        List<UocShipOrderDo> uocShipOrderDoList = this.getUocShipOrderDoList(reqBo, "FH_FH_JS");
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        if (!CollectionUtils.isEmpty(uocShipOrderDoList)) {
            uocSaleOrderDo.setSaleOrderState("XS_YS_BFYS");
        } else {
            uocSaleOrderDo.setSaleOrderState("XS_YS_YS");
        }
        this.iUocSaleOrderModel.updateSaleStatusAndProCode(uocSaleOrderDo);
    }

    private List<UocShipOrderDo> getUocShipOrderDoList(UocArrvalAcceptanceReqBo reqBo, String state) {
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderQryBo.setShipOrderState(state);
        return this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
    }

    private Boolean judgeSaleOrderFinishFlag(UocArrvalAcceptanceReqBo reqBo) {
        if (reqBo.getClosePennyDiff() == null || !reqBo.getClosePennyDiff().booleanValue()) {
            UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
            uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
            uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
            UocSaleOrderDo uocSaleOrderDo1 = this.iUocSaleOrderModel.getCollectCountImplOrderItem(uocSaleOrderItemQryBo);
            UocSaleOrderItem uocSaleOrderItem = uocSaleOrderDo1.getSaleOrderItems().get(0);
            if (uocSaleOrderItem.getPurchaseCount().compareTo(uocSaleOrderItem.getSendCount()) != 0) {
                return false;
            }
        }
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocShipOrderDo> shipOrderDos = this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        for (UocShipOrderDo uocShipOrderDo : shipOrderDos) {
            if (!uocShipOrderDo.getFinishFlag().equals(UocConstant.SHIP_ORDER_FINISH_FLAG.NOT_FINISH)) continue;
            return false;
        }
        return true;
    }

    private Map<Long, Boolean> checkShipOrderInspState(UocArrvalAcceptanceReqBo reqBo, Map<Long, UocShipOrderItem> uocShipOrderItemMap, Map<Long, UocSaleOrderItem> uocSaleOrderItemMap) {
        HashMap<Long, Boolean> shipOrderInspStateMap = new HashMap<Long, Boolean>();
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> {
            shipOrderInspStateMap.put(uocCreateInspOrderReqShipBo.getShipOrderId(), true);
            uocCreateInspOrderReqShipBo.getShipItemList().forEach(uocCreateInspOrderReqShipItemBo -> {
                UocShipOrderItem uocShipOrderItem = (UocShipOrderItem)uocShipOrderItemMap.get(uocCreateInspOrderReqShipItemBo.getShipItemId());
                UocSaleOrderItem uocSaleOrderItem = (UocSaleOrderItem)uocSaleOrderItemMap.get(uocShipOrderItem.getSaleOrderItemId());
                BigDecimal inspectionExcessPercent = this.getInspectionExcessPercent(uocSaleOrderItem.getInspectionExcessPercent());
                BigDecimal canInspCount = uocShipOrderItem.getSendCount().add(uocSaleOrderItem.getPurchaseCount().multiply(inspectionExcessPercent).subtract(uocSaleOrderItem.getInspSuperCount()));
                BigDecimal currentInspCount = uocCreateInspOrderReqShipItemBo.getInspCount().add(uocShipOrderItem.getInspCount());
                log.info("\u603b\u53ef\u9a8c\u6536\u6570\u91cf(canInspCount):{}", (Object)canInspCount);
                log.info("\u9a8c\u6536\u6570\u91cf(currentInspCount):{}", (Object)currentInspCount);
                if (currentInspCount.compareTo(canInspCount) > 0) {
                    throw new BaseBusinessException("101004", "\u5269\u4f59\u53ef\u9a8c\u6536\u6570\u91cf\u4e0d\u8db3\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u65b0\u586b\u5199\u9a8c\u6536\u6570\u91cf");
                }
                if (!(reqBo.getInspFinish() != null && reqBo.getInspFinish().booleanValue() || currentInspCount.compareTo(uocShipOrderItem.getSendCount()) >= 0)) {
                    shipOrderInspStateMap.put(uocShipOrderItem.getShipOrderId(), false);
                }
                uocShipOrderItem.setInspSuperCount(BigDecimal.ZERO);
                BigDecimal currentInspSuperCount = currentInspCount.subtract(uocShipOrderItem.getSendCount());
                if (currentInspSuperCount.compareTo(BigDecimal.ZERO) > 0) {
                    uocShipOrderItem.setInspSuperCount(currentInspSuperCount);
                }
            });
        });
        return shipOrderInspStateMap;
    }

    private boolean isFinish(Map<Long, UocShipOrderItem> uocShipOrderItemMap, Map<Long, UocSaleOrderItem> uocSaleOrderItemMap, UocCreateInspOrderReqShipBo uocCreateInspOrderReqShipBo) {
        for (UocCreateInspOrderReqShipItemBo uocCreateInspOrderReqShipItemBo : uocCreateInspOrderReqShipBo.getShipItemList()) {
            UocShipOrderItem uocShipOrderItem = uocShipOrderItemMap.get(uocCreateInspOrderReqShipItemBo.getShipItemId());
            UocSaleOrderItem uocSaleOrderItem = uocSaleOrderItemMap.get(uocShipOrderItem.getSaleOrderItemId());
            BigDecimal inspectionExcessPercent = this.getInspectionExcessPercent(uocSaleOrderItem.getInspectionExcessPercent());
            BigDecimal inspTotalCount = uocCreateInspOrderReqShipItemBo.getInspCount().add(uocShipOrderItem.getInspCount());
            BigDecimal canInspCount = uocShipOrderItem.getSendCount().add(uocSaleOrderItem.getPurchaseCount().multiply(inspectionExcessPercent));
            log.info("\u53ef\u9a8c\u6536\u6570\u91cf:{}", (Object)canInspCount);
            log.info("\u5168\u90e8\u9a8c\u6536\u6570\u91cf:{}", (Object)inspTotalCount);
            if (inspTotalCount.compareTo(canInspCount) > 0) {
                throw new BaseBusinessException("101004", "\u5269\u4f59\u53ef\u9a8c\u6536\u6570\u91cf\u4e0d\u8db3\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u91cd\u65b0\u586b\u5199\u9a8c\u6536\u6570\u91cf");
            }
            if (inspTotalCount.compareTo(canInspCount) >= 0) continue;
            return false;
        }
        return true;
    }

    private BigDecimal getInspectionExcessPercent(Integer supInspScale) {
        BigDecimal inspectionExcessPercent = BigDecimal.ZERO;
        if (null != supInspScale) {
            inspectionExcessPercent = new BigDecimal(supInspScale).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
        }
        return inspectionExcessPercent;
    }

    private UocInspOrderDo convertInspOrderDo(UocArrvalAcceptanceReqBo reqBo, Date now, Map<Long, UocShipOrderItem> uocShipOrderItemMap, String operId) {
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setOrderId(reqBo.getOrderId());
        uocInspOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocInspOrderDo.setInspOrderId(IdUtil.nextId());
        uocInspOrderDo.setRemark(reqBo.getRemark());
        uocInspOrderDo.setOtherRemark(reqBo.getOtherRemark());
        uocInspOrderDo.setInspOrderNo(this.getInspOrderNo(reqBo));
        uocInspOrderDo.setInspOrderState("YS_YS_YS");
        uocInspOrderDo.setInspOper(reqBo.getName());
        uocInspOrderDo.setCreateOperId(operId);
        uocInspOrderDo.setCreateTime(now);
        uocInspOrderDo.setInspOper(reqBo.getName());
        uocInspOrderDo.setInvoiceTag(UocConstant.INVOICE_TAG.NO);
        uocInspOrderDo.setInspOperPhone(reqBo.getCellphone());
        uocInspOrderDo.setTenantId(reqBo.getTenantId());
        uocInspOrderDo.setTotalPurchaseFee(BigDecimal.ZERO);
        uocInspOrderDo.setTotalSaleFee(BigDecimal.ZERO);
        ArrayList<UocShipInspRel> uocShipInspRelList = new ArrayList<UocShipInspRel>();
        ArrayList<UocInspOrderItem> uocInspOrderItemList = new ArrayList<UocInspOrderItem>();
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> {
            UocShipInspRel uocShipInspRel = UocRu.js(uocInspOrderDo, UocShipInspRel.class);
            uocShipInspRel.setId(IdUtil.nextId());
            uocShipInspRel.setShipOrderId(uocCreateInspOrderReqShipBo.getShipOrderId());
            uocShipInspRel.setRemark(null);
            uocShipInspRelList.add(uocShipInspRel);
            uocCreateInspOrderReqShipBo.getShipItemList().forEach(uocCreateInspOrderReqShipItemBo -> {
                UocShipOrderItem uocShipOrderItem = (UocShipOrderItem)uocShipOrderItemMap.get(uocCreateInspOrderReqShipItemBo.getShipItemId());
                UocInspOrderItem uocInspOrderItem = UocRu.js(uocInspOrderDo, UocInspOrderItem.class);
                uocInspOrderItem.setInspOrderItemId(IdUtil.nextId());
                uocInspOrderItem.setInspCount(uocCreateInspOrderReqShipItemBo.getInspCount());
                uocInspOrderItem.setSaleOrderItemId(uocShipOrderItem.getSaleOrderItemId());
                uocInspOrderItem.setShipOrderItemId(uocCreateInspOrderReqShipItemBo.getShipItemId());
                uocInspOrderItem.setUnitName(uocShipOrderItem.getUnitName());
                uocInspOrderItem.setRemark(null);
                if (!CollectionUtils.isEmpty((Collection)uocCreateInspOrderReqShipItemBo.getItemExtParallelBoList())) {
                    List<UocInspItemMap> uocInspItemMapList = UocRu.jsl(uocCreateInspOrderReqShipItemBo.getItemExtParallelBoList(), UocInspItemMap.class);
                    uocInspItemMapList.forEach(uocInspItemMap -> {
                        uocInspItemMap.setInspOrderId(uocInspOrderDo.getInspOrderId());
                        uocInspItemMap.setOrderId(uocInspOrderDo.getOrderId());
                        uocInspItemMap.setSaleOrderId(uocInspOrderDo.getSaleOrderId());
                        uocInspItemMap.setInspOrderItemId(uocInspOrderItem.getInspOrderItemId());
                        uocInspItemMap.setCreateOperId(operId);
                        uocInspItemMap.setCreateTime(now);
                        uocInspItemMap.setId(IdUtil.nextId());
                    });
                    uocInspOrderItem.setItemExtParallelBoList(uocInspItemMapList);
                }
                uocInspOrderItemList.add(uocInspOrderItem);
            });
        });
        uocInspOrderDo.setUocShipInspRelList(uocShipInspRelList);
        uocInspOrderDo.setUocInspOrderItemList(uocInspOrderItemList);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExtParallelBoList())) {
            List<UocInspOrderMap> uocInspOrderMapList = UocRu.jsl(reqBo.getExtParallelBoList(), UocInspOrderMap.class);
            uocInspOrderMapList.forEach(uocInspOrderMap -> {
                uocInspOrderMap.setInspOrderId(uocInspOrderDo.getInspOrderId());
                uocInspOrderMap.setSaleOrderId(reqBo.getSaleOrderId());
                uocInspOrderMap.setOrderId(reqBo.getOrderId());
                uocInspOrderMap.setCreateOperId(operId);
                uocInspOrderMap.setCreateTime(now);
                uocInspOrderMap.setId(IdUtil.nextId());
            });
            uocInspOrderDo.setExtParallelBoList(uocInspOrderMapList);
        }
        this.setInspAllowChngTime(reqBo, uocInspOrderDo);
        return uocInspOrderDo;
    }

    private void setInspAllowChngTime(UocArrvalAcceptanceReqBo reqBo, UocInspOrderDo uocInspOrderDo) {
        UocSaleOrderQryBo saleOrderQryBo = new UocSaleOrderQryBo();
        saleOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        saleOrderQryBo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo saleOrderMain = this.iUocSaleOrderModel.qrySaleOrder(saleOrderQryBo);
        UocConfEffectiveQryBo uocConfEffectiveQryBo = new UocConfEffectiveQryBo();
        uocConfEffectiveQryBo.setEffectiveCode("5");
        List rows = this.iUocOrderModel.qryListPageConfEffective(uocConfEffectiveQryBo).getRows();
        Date allowChngTime = null;
        String supId = "";
        String orderSource = "";
        if (ObjectUtil.isNotEmpty((Object)rows)) {
            Map confEffectiveMap = rows.stream().collect(Collectors.toMap(o -> o.getBusinessTypeCode() + o.getSupplierNo(), Function.identity()));
            if (ObjectUtil.isNotNull((Object)saleOrderMain)) {
                orderSource = saleOrderMain.getOrderSource().toString();
                supId = ObjectUtil.isNotNull((Object)saleOrderMain.getStakeholder()) ? saleOrderMain.getStakeholder().getSupId() : reqBo.getSupId().toString();
            } else {
                orderSource = EC_IMPORT;
            }
            allowChngTime = ObjectUtil.isNotNull(confEffectiveMap.get(orderSource + supId)) ? new Date(((UocConfEffective)confEffectiveMap.get(orderSource + supId)).getAging()) : new Date(((UocConfEffective)confEffectiveMap.get(orderSource + "0")).getAging());
        }
        uocInspOrderDo.setAllowChngTime(allowChngTime);
    }

    private List<UocSaleOrderItem> getUocSaleOrderItem(UocArrvalAcceptanceReqBo reqBo, List<Long> saleOrderItemIdList) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIdList);
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qryListSaleOrderItem(uocSaleOrderItemQryBo);
        if (CollectionUtils.isEmpty(uocSaleOrderDo.getSaleOrderItems())) {
            throw new BaseBusinessException("101004", "\u83b7\u53d6\u9500\u552e\u660e\u7ec6\u4e3a\u7a7a");
        }
        return uocSaleOrderDo.getSaleOrderItems();
    }

    private void modifyShipOrder(UocArrvalAcceptanceReqBo reqBo, Date now, String operId, Map<Long, Boolean> shipOrderInspStateMap) {
        UocShipOrderDo uocShipOrderDo = this.convertShipOrderDo(reqBo, now, operId, shipOrderInspStateMap);
        if (!CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderIdList())) {
            this.iUocShipOrderModel.modifyShipOrderMain(uocShipOrderDo);
        }
        this.iUocShipOrderModel.modifyShipOrderItemInspCount(uocShipOrderDo);
    }

    private UocShipOrderDo convertShipOrderDo(UocArrvalAcceptanceReqBo reqBo, Date now, String operId, Map<Long, Boolean> shipOrderInspStateMap) {
        ArrayList<Long> shipOrderIdList = new ArrayList<Long>();
        ArrayList<UocShipOrderItem> shipOrderItemList = new ArrayList<UocShipOrderItem>();
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> {
            if (((Boolean)shipOrderInspStateMap.get(uocCreateInspOrderReqShipBo.getShipOrderId())).booleanValue()) {
                shipOrderIdList.add(uocCreateInspOrderReqShipBo.getShipOrderId());
            }
            uocCreateInspOrderReqShipBo.getShipItemList().forEach(uocCreateInspOrderReqShipItemBo -> {
                UocShipOrderItem uocShipOrderItem = new UocShipOrderItem();
                uocShipOrderItem.setShipOrderItemId(uocCreateInspOrderReqShipItemBo.getShipItemId());
                uocShipOrderItem.setInspCount(uocCreateInspOrderReqShipItemBo.getInspCount());
                uocShipOrderItem.setOrderId(reqBo.getOrderId());
                uocShipOrderItem.setSaleOrderId(reqBo.getSaleOrderId());
                shipOrderItemList.add(uocShipOrderItem);
            });
        });
        UocShipOrderDo uocShipOrderDo = new UocShipOrderDo();
        uocShipOrderDo.setOrderId(reqBo.getOrderId());
        uocShipOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocShipOrderDo.setUpdateTime(now);
        uocShipOrderDo.setUpdateOperId(operId);
        if (!CollectionUtils.isEmpty(shipOrderIdList)) {
            uocShipOrderDo.setShipOrderIdList(shipOrderIdList);
            uocShipOrderDo.setInspTime(now);
            uocShipOrderDo.setShipOrderState("FH_FH_YS");
            uocShipOrderDo.setInspOperId(operId);
            uocShipOrderDo.setInspOperPhone(reqBo.getCellphone());
            uocShipOrderDo.setInspOperName(reqBo.getName());
            uocShipOrderDo.setFinishFlag(UocConstant.SHIP_ORDER_FINISH_FLAG.FINISH);
        }
        uocShipOrderDo.setShipOrderItemBoList(shipOrderItemList);
        return uocShipOrderDo;
    }

    private UocShipOrderDo getShipOrderItemList(UocArrvalAcceptanceReqBo reqBo) {
        UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
        uocShipOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        ArrayList<Long> shipOrderItemIdList = new ArrayList<Long>();
        ArrayList<Long> shipOrderIdList = new ArrayList<Long>();
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> {
            shipOrderIdList.add(uocCreateInspOrderReqShipBo.getShipOrderId());
            uocCreateInspOrderReqShipBo.getShipItemList().forEach(uocCreateInspOrderReqShipItemBo -> shipOrderItemIdList.add(uocCreateInspOrderReqShipItemBo.getShipItemId()));
        });
        uocShipOrderItemQryBo.setShipOrderItemIdList(shipOrderItemIdList);
        uocShipOrderItemQryBo.setShipOrderIdList(shipOrderIdList);
        UocShipOrderDo uocShipOrderDo = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
        Integer idSize = shipOrderItemIdList.size();
        if (CollectionUtils.isEmpty(uocShipOrderDo.getShipOrderItemBoList()) || !idSize.equals(uocShipOrderDo.getShipOrderItemBoList().size())) {
            throw new BaseBusinessException("101004", "\u52fe\u9009\u7684\u53d1\u8d27\u660e\u7ec6\u4e0e\u67e5\u8be2\u7ed3\u679c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u9a8c\u6536\u7684\u5546\u54c1\u4fe1\u606f");
        }
        return uocShipOrderDo;
    }

    private UocSaleOrderDo convertSaleOrderDo(UocArrvalAcceptanceReqBo reqBo, Date now, Map<Long, UocShipOrderItem> uocShipOrderItemMap, String operId) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setUpdateOperId(operId);
        uocSaleOrderDo.setUpdateTime(now);
        HashMap saleItemIdMap = new HashMap();
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> uocCreateInspOrderReqShipBo.getShipItemList().forEach(uocCreateInspOrderReqShipItemBo -> {
            UocShipOrderItem uocShipOrderItem = (UocShipOrderItem)uocShipOrderItemMap.get(uocCreateInspOrderReqShipItemBo.getShipItemId());
            UocSaleOrderItem uocSaleOrderItem = (UocSaleOrderItem)saleItemIdMap.get(uocShipOrderItem.getSaleOrderItemId());
            if (null != uocSaleOrderItem) {
                uocSaleOrderItem.setAcceptanceCount(uocSaleOrderItem.getAcceptanceCount().add(uocCreateInspOrderReqShipItemBo.getInspCount()));
                uocSaleOrderItem.setInspSuperCount(uocSaleOrderItem.getInspSuperCount().add(uocShipOrderItem.getInspSuperCount()));
            } else {
                uocSaleOrderItem = new UocSaleOrderItem();
                uocSaleOrderItem.setSaleOrderItemId(uocShipOrderItem.getSaleOrderItemId());
                uocSaleOrderItem.setAcceptanceCount(uocCreateInspOrderReqShipItemBo.getInspCount());
                uocSaleOrderItem.setInspSuperCount(uocShipOrderItem.getInspSuperCount());
            }
            saleItemIdMap.put(uocSaleOrderItem.getSaleOrderItemId(), uocSaleOrderItem);
        }));
        uocSaleOrderDo.setSaleOrderItems(new ArrayList<UocSaleOrderItem>(saleItemIdMap.values()));
        return uocSaleOrderDo;
    }

    private String getInspOrderNo(UocArrvalAcceptanceReqBo reqBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("101004", "\u67e5\u8be2\u9500\u552e\u5355\u5355\u4e3a\u7a7a");
        }
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setOrderSource(uocSaleOrderDo.getOrderSource());
        return this.iUocInspOrderModel.getInspOrderNo(uocInspOrderDo).getInspOrderNo();
    }

    private void calRelInfo(UocArrvalAcceptanceReqBo reqBo, Long inspOrderId) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo = this.iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException("101004", "\u67e5\u8be2\u9500\u552e\u5355\u5355\u4e3a\u7a7a");
        }
        this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.COMMON_INVOICE);
        if (UocConstant.ModelSettle.MY.equals(uocSaleOrderDo.getModelSettle())) {
            this.createRelInfo(reqBo, inspOrderId, UocDicConstant.REL_TYPE.UP_INVOICE);
        }
    }

    private void createRelInfo(UocArrvalAcceptanceReqBo reqBo, Long inspOrderId, Integer relType) {
        UocOrderRel uocOrderRel = new UocOrderRel();
        uocOrderRel.setId(IdUtil.nextId());
        uocOrderRel.setRelStatus(UocDicConstant.REL_STATUS.UN_SUBMITTED);
        uocOrderRel.setRelType(relType);
        uocOrderRel.setOrderId(reqBo.getOrderId());
        uocOrderRel.setObjId(inspOrderId);
        uocOrderRel.setObjType(UocDicConstant.OBJ_TYPE.INSPECTION);
        this.iUocOrderModel.createRelInfo(uocOrderRel);
    }

    private void validateArg(UocArrvalAcceptanceReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getInspFinish()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u9a8c\u6536\u5b8c\u7ed3\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getClosePennyDiff()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5173\u95ed\u5c3e\u5dee\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u7528\u6237ID\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getShipOrderList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u5355\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBo.getShipOrderList().forEach(uocCreateInspOrderReqShipBo -> {
            if (null == uocCreateInspOrderReqShipBo.getShipOrderId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == uocCreateInspOrderReqShipBo.getTaskId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == uocCreateInspOrderReqShipBo.getStepId()) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u73af\u8282\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (CollectionUtils.isEmpty((Collection)uocCreateInspOrderReqShipBo.getShipItemList())) {
                throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            uocCreateInspOrderReqShipBo.getShipItemList().forEach(uocCreateInspOrderReqShipItemBo -> {
                if (null == uocCreateInspOrderReqShipItemBo.getInspCount()) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u9a8c\u6536\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (null == uocCreateInspOrderReqShipItemBo.getShipItemId()) {
                    throw new BaseBusinessException("100001", "\u5165\u53c2\u53d1\u8d27\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
        });
    }
}

