/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.audit.sub.UocAuditOrder;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdInvoiceQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrdLogisticsRelaQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderAccessoryQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderProcInstQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskDealQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderTaskInstQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrdInvoice;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderAgreement;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderQryBo;
import com.tydic.dyc.oc.model.payorder.sub.UocPayOrder;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocOrderAgreementQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleItemMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderMapQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleItemMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleStakeholder;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryDetailBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryTypeDetailBo;
import com.tydic.dyc.oc.service.saleorder.UocGetSaleOrderDetailService;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspAgreementInfoBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspInspOrderInfoBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspInspOrderItemInfoBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspInvoiceBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPayOrderBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspPorcBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspReceiverAddressBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspShipOrderInfoBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspShipOrderItemBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspStakeholderBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspTaskDealBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspVerifyInfoBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocSaleOrderAuditBO;
import com.tydic.dyc.oc.utils.UocRu;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.saleorder.UocGetSaleOrderDetailService"})
public class UocGetSaleOrderDetailServiceImpl
implements UocGetSaleOrderDetailService {
    public static final List<String> pCodeList = ListUtil.list((boolean)false);
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;
    private static final String LINE = "_";
    @Value(value="${uoc.obj_type.isSale:0}")
    private String isSale;

    @PostMapping(value={"getSaleOrderDetail"})
    public UocGetSaleOrderDetailServiceRspBo getSaleOrderDetail(@RequestBody UocGetSaleOrderDetailServiceReqBo reqBo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo;
        List<UocSaleOrderItem> saleOrderItemList;
        UocSaleOrderMapQryBo uocSaleOrderMapQryBo;
        List<UocSaleOrderMap> saleOrderExpandList;
        this.validateParam(reqBo);
        ArrayList<UocBaseOrderAccessoryTypeDetailBo> accessoryDetailBoList = new ArrayList<UocBaseOrderAccessoryTypeDetailBo>();
        List<Object> uocBaseExtParallelBoList = new ArrayList();
        ArrayList<UocGetSaleOrderDetailServiceRspItemBo> uocGetSaleOrderDetailServiceRspItemBos = new ArrayList<UocGetSaleOrderDetailServiceRspItemBo>();
        ArrayList<Object> shipOrderInfo = new ArrayList<Object>();
        ArrayList<UocGetSaleOrderDetailServiceRspInspOrderInfoBo> inspOrderInfo = new ArrayList<UocGetSaleOrderDetailServiceRspInspOrderInfoBo>();
        UocSaleOrderQryBo uocSaleOrderQryBo = UocRu.js(reqBo, UocSaleOrderQryBo.class);
        UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        if (Objects.isNull(uocSaleOrderDo)) {
            return UocRu.success(UocGetSaleOrderDetailServiceRspBo.class);
        }
        UocGetSaleOrderDetailServiceRspBo rspBo = UocRu.js(uocSaleOrderDo, UocGetSaleOrderDetailServiceRspBo.class);
        if (null == rspBo.getTotalTransFee()) {
            rspBo.setTotalTransFee(BigDecimal.ZERO);
        }
        if (null != uocSaleOrderDo.getStakeholder()) {
            UocSaleStakeholder stakeholder = uocSaleOrderDo.getStakeholder();
            BeanUtils.copyProperties((Object)stakeholder, (Object)rspBo);
            rspBo.setDistirbutionId(stakeholder.getSupId());
            rspBo.setDistirbutionName(stakeholder.getSupName());
            rspBo.setDistirbutionIdContactName(stakeholder.getSupRelaName());
            rspBo.setDistirbutionIdContactMobile(stakeholder.getSupRelaMobile());
            rspBo.setUocGetSaleOrderDetailServiceRspStakeholderBo(UocRu.js(stakeholder, UocGetSaleOrderDetailServiceRspStakeholderBo.class));
        }
        UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
        uocSaleOrderPayConfQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderPayConfQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocSaleOrderPayConf> saleOrderPayConfList = this.iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
        if (ObjectUtil.isNotEmpty(saleOrderPayConfList) && ObjectUtil.isNotEmpty(saleOrderPayConfList = saleOrderPayConfList.stream().filter(each -> ObjectUtil.notEqual((Object)each.getPayType(), (Object)UocDicConstant.PAY_TYPE.PAY_BY_PERIOD) && null != each.getPrePayFee() && null != each.getVerPayFee() && null != each.getPilPayFee() && null != each.getQuaPayFee()).collect(Collectors.toList()))) {
            UocSaleOrderPayConf payConf = saleOrderPayConfList.get(0);
            rspBo.setPayRatio(payConf.getPrePayFee().multiply(BigDecimal.valueOf(0.2)).subtract(payConf.getVerPayFee().multiply(BigDecimal.valueOf(0.4))).subtract(payConf.getPilPayFee().multiply(BigDecimal.valueOf(0.2))).subtract(payConf.getQuaPayFee().multiply(BigDecimal.valueOf(0.2))));
        }
        UocGetSaleOrderDetailServiceRspPorcBo procInst = this.getProcInst(uocSaleOrderDo, this.isSale);
        rspBo.setProcInst(procInst);
        UocGetSaleOrderDetailServiceRspPorcBo auditProcInst = UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(uocSaleOrderDo.getOrderSource()) ? this.getAuditProcInst(uocSaleOrderDo, UocDicConstant.OBJ_TYPE.ORDER) : this.getAuditProcInst(uocSaleOrderDo, UocDicConstant.OBJ_TYPE.SALE);
        rspBo.setAuditProcInst(auditProcInst);
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(reqBo.getOrderId());
        uocOrderDo = this.iUocOrderModel.qryOrderBy(uocOrderDo);
        if (ObjectUtil.isNotNull((Object)((Object)uocOrderDo))) {
            rspBo.setOrderNo(uocOrderDo.getOrderNo());
            rspBo.setOrderTime(uocOrderDo.getCreateTime());
            rspBo.setRemark(uocOrderDo.getRemark());
        }
        if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(uocSaleOrderDo.getOrderSource())) {
            UocOrderAgreementQryBo uocOrderAgreementQryBo = new UocOrderAgreementQryBo();
            uocOrderAgreementQryBo.setOrderId(reqBo.getOrderId());
            uocOrderAgreementQryBo.setId(uocSaleOrderDo.getAgrDataId());
            List<UocOrderAgreement> agreementOrderList = this.iUocSaleOrderModel.getAgreementOrderList(uocOrderAgreementQryBo);
            if (ObjectUtil.isNotEmpty(agreementOrderList)) {
                rspBo.setAgreementInfo(new UocGetSaleOrderDetailServiceRspAgreementInfoBo());
                rspBo.getAgreementInfo().setAgreementCode(agreementOrderList.get(0).getAgreementCode());
                rspBo.getAgreementInfo().setPlaAgreementCode(agreementOrderList.get(0).getPlaAgreementCode());
                rspBo.getAgreementInfo().setEntAgreementCode(agreementOrderList.get(0).getEntAgreementCode());
                rspBo.getAgreementInfo().setProducerName(agreementOrderList.get(0).getProducerName());
                rspBo.getAgreementInfo().setAgreementName(agreementOrderList.get(0).getAgreementName());
                rspBo.getAgreementInfo().setAdjustPrice(agreementOrderList.get(0).getAdjustPrice());
            }
        }
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setOrderId(reqBo.getOrderId());
        uocChngOrderQryBo.setBusiTypeList(Arrays.asList(UocConstant.BUSI_TYPE.PRICE_CHG));
        List<UocChngOrderDo> listChngOrder = this.iUocChngOrderModel.getListChngOrder(uocChngOrderQryBo);
        if (ObjectUtil.isNotEmpty(listChngOrder)) {
            rspBo.setOrderVerifyInfo(new UocGetSaleOrderDetailServiceRspVerifyInfoBo());
            rspBo.getOrderVerifyInfo().setAdjustName(listChngOrder.get(0).getCreateOperName());
            rspBo.getOrderVerifyInfo().setAdjustTime(listChngOrder.get(0).getCreateTime());
            rspBo.getOrderVerifyInfo().setRemark(listChngOrder.get(0).getRemark());
        } else {
            UocSaleOrderMapQryBo uocSaleOrderMapQryBo2 = UocRu.js(reqBo, UocSaleOrderMapQryBo.class);
            String FIELD_CODE = "SKIP_ADJUST_PRICE_MEN";
            uocSaleOrderMapQryBo2.setFieldCode(FIELD_CODE);
            List<UocSaleOrderMap> saleOrderExpandList2 = this.iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo2);
            if (!CollectionUtils.isEmpty(saleOrderExpandList2)) {
                rspBo.setOrderVerifyInfo(new UocGetSaleOrderDetailServiceRspVerifyInfoBo());
                rspBo.getOrderVerifyInfo().setAdjustName(saleOrderExpandList2.get(0).getFieldValue());
                rspBo.getOrderVerifyInfo().setAdjustTime(saleOrderExpandList2.get(0).getCreateTime());
                rspBo.getOrderVerifyInfo().setRemark(saleOrderExpandList2.get(0).getRemark());
            }
        }
        UocOrdLogisticsRelaQryBo relaQryBo = new UocOrdLogisticsRelaQryBo();
        relaQryBo.setOrderId(uocSaleOrderDo.getOrderId());
        relaQryBo.setContactId(uocOrderDo.getContactId());
        UocOrdLogisticsRela uocOrdLogisticsRela = this.iUocOrderModel.qryOrderLogisticsRela(relaQryBo);
        rspBo.setReceiverAddressBo(UocRu.js(uocOrdLogisticsRela, UocGetSaleOrderDetailServiceRspReceiverAddressBo.class));
        UocOrdInvoiceQryBo invoiceQryBo = new UocOrdInvoiceQryBo();
        invoiceQryBo.setOrderId(uocSaleOrderDo.getOrderId());
        UocOrdInvoice uocOrdInvoice = this.iUocOrderModel.qryOrderInvoice(invoiceQryBo);
        rspBo.setInvoiceBo(UocRu.js(uocOrdInvoice, UocGetSaleOrderDetailServiceRspInvoiceBo.class));
        UocGetSaleOrderDetailServiceRspReceiverAddressBo invoiceAddressBo = new UocGetSaleOrderDetailServiceRspReceiverAddressBo();
        if (ObjectUtil.isNotEmpty((Object)uocOrdInvoice)) {
            relaQryBo = new UocOrdLogisticsRelaQryBo();
            relaQryBo.setContactId(uocOrdInvoice.getContactId());
            relaQryBo.setOrderId(uocOrdInvoice.getOrderId());
            invoiceAddressBo = UocRu.js(this.iUocOrderModel.qryOrderLogisticsRela(relaQryBo), UocGetSaleOrderDetailServiceRspReceiverAddressBo.class);
        }
        rspBo.setInvoiceAddressBo(invoiceAddressBo);
        UocOrderAccessoryQryBo uocOrderAccessoryQryBo = new UocOrderAccessoryQryBo();
        uocOrderAccessoryQryBo.setObjId(uocSaleOrderDo.getOrderId());
        uocOrderAccessoryQryBo.setOrderId(uocSaleOrderDo.getOrderId());
        uocOrderAccessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
        List<UocOrderAccessory> saleOrderAccessoryList = this.iUocSaleOrderModel.getSaleOrderAccessoryList(uocOrderAccessoryQryBo).getSaleOrderAccessoryList();
        if (ObjectUtil.isNotEmpty(saleOrderAccessoryList)) {
            List<UocBaseOrderAccessoryDetailBo> accessoryDetailBos = UocRu.jsl(saleOrderAccessoryList, UocBaseOrderAccessoryDetailBo.class);
            Map<Integer, List<UocBaseOrderAccessoryDetailBo>> accessoryDetailMap = accessoryDetailBos.stream().collect(Collectors.groupingBy(UocBaseOrderAccessoryDetailBo::getAttachmentType));
            Iterator<Integer> iterator = accessoryDetailMap.keySet().iterator();
            while (iterator.hasNext()) {
                UocBaseOrderAccessoryTypeDetailBo accessoryTypeDetailBo = new UocBaseOrderAccessoryTypeDetailBo();
                Integer attachmentType = iterator.next();
                accessoryTypeDetailBo.setAttachmentType(attachmentType);
                accessoryTypeDetailBo.setAttchList(accessoryDetailMap.get(attachmentType));
                accessoryDetailBoList.add(accessoryTypeDetailBo);
            }
        }
        if (ObjectUtil.isNotEmpty(saleOrderExpandList = this.iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo = UocRu.js(reqBo, UocSaleOrderMapQryBo.class)))) {
            uocBaseExtParallelBoList = UocRu.jsl(saleOrderExpandList, UocBaseExtParallelBo.class);
        }
        Map<Object, Object> shipOrderItemMap = new HashMap();
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocShipOrderDo> shipOrderList = this.iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        if (ObjectUtil.isNotEmpty(shipOrderList)) {
            for (UocShipOrderDo each2 : shipOrderList) {
                UocGetSaleOrderDetailServiceRspShipOrderInfoBo shipOrderInfoBo = UocRu.js(each2, UocGetSaleOrderDetailServiceRspShipOrderInfoBo.class);
                UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
                uocShipOrderItemQryBo.setOrderId(each2.getOrderId());
                uocShipOrderItemQryBo.setShipOrderId(each2.getShipOrderId());
                UocShipOrderDo listShipOrderItem = this.iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
                if (ObjectUtil.isNotEmpty(listShipOrderItem.getShipOrderItemBoList())) {
                    shipOrderInfoBo.setShipOrderItemInfo(UocRu.jsl(listShipOrderItem.getShipOrderItemBoList(), UocGetSaleOrderDetailServiceRspShipOrderItemBo.class));
                    shipOrderItemMap = listShipOrderItem.getShipOrderItemBoList().stream().collect(Collectors.toMap(UocShipOrderItem::getSaleOrderItemId, o -> o));
                }
                shipOrderInfo.add(shipOrderInfoBo);
            }
        }
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setOrderId(reqBo.getOrderId());
        uocInspOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocInspOrderDo> inspOrderList = this.iUocInspOrderModel.getListInspOrder(uocInspOrderQryBo);
        if (ObjectUtil.isNotEmpty(inspOrderList)) {
            for (UocInspOrderDo each3 : inspOrderList) {
                UocGetSaleOrderDetailServiceRspInspOrderInfoBo inspOrderInfoBo = UocRu.js(each3, UocGetSaleOrderDetailServiceRspInspOrderInfoBo.class);
                UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
                uocInspOrderItemQryBo.setOrderId(each3.getOrderId());
                uocInspOrderItemQryBo.setInspOrderId(each3.getInspOrderId());
                UocInspOrderDo listInspOrderItem = this.iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
                if (null != listInspOrderItem && ObjectUtil.isNotEmpty(listInspOrderItem.getUocInspOrderItemList())) {
                    inspOrderInfoBo.setInspOrderItemInfo(UocRu.jsl(listInspOrderItem.getUocInspOrderItemList(), UocGetSaleOrderDetailServiceRspInspOrderItemInfoBo.class));
                }
                inspOrderInfo.add(inspOrderInfoBo);
            }
        }
        UocPayOrderQryBo uocPayOrderQryBo = new UocPayOrderQryBo();
        uocPayOrderQryBo.setOrderId(reqBo.getOrderId());
        List<UocPayOrder> listPayOrder = this.iUocPayOrderModel.getListPayOrder(uocPayOrderQryBo);
        if (ObjectUtil.isNotEmpty(listPayOrder)) {
            rspBo.setPayOrderInfo(UocRu.jsl(listPayOrder, UocGetSaleOrderDetailServiceRspPayOrderBo.class));
        }
        if (ObjectUtil.isNotEmpty(saleOrderItemList = this.iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo = UocRu.js(reqBo, UocSaleOrderItemQryBo.class)))) {
            for (UocSaleOrderItem item : saleOrderItemList) {
                UocGetSaleOrderDetailServiceRspItemBo rspItemBo = UocRu.js(item, UocGetSaleOrderDetailServiceRspItemBo.class);
                if (ObjectUtil.isNotEmpty(shipOrderItemMap) && shipOrderItemMap.containsKey(item.getSaleOrderItemId())) {
                    rspItemBo.setSendCount(((UocShipOrderItem)shipOrderItemMap.get(item.getSaleOrderItemId())).getSendCount());
                }
                if (ObjectUtil.isNotEmpty(shipOrderItemMap) && shipOrderItemMap.containsKey(item.getSaleOrderItemId())) {
                    rspItemBo.setAcceptanceCount(((UocShipOrderItem)shipOrderItemMap.get(item.getSaleOrderItemId())).getInspCount());
                }
                if (null == rspItemBo.getPurchaseFee() && null != rspItemBo.getPurchasePrice() && null != rspItemBo.getPurchaseCount()) {
                    rspItemBo.setPurchaseFee(rspItemBo.getPurchasePrice().multiply(rspItemBo.getPurchaseCount()));
                }
                if (null == rspItemBo.getSaleFee()) {
                    if (null == rspItemBo.getSalePrice()) {
                        rspItemBo.setSalePrice(rspItemBo.getPurchasePrice());
                    }
                    if (null != rspItemBo.getSalePrice() && null != rspItemBo.getPurchaseCount()) {
                        rspItemBo.setSaleFee(rspItemBo.getSalePrice().multiply(rspItemBo.getPurchaseCount()));
                    }
                }
                if (null == rspItemBo.getMarkUpRate()) {
                    rspItemBo.setMarkUpRate(Double.valueOf(BigDecimal.ZERO.doubleValue()));
                }
                rspItemBo.setSalePriceRear(rspItemBo.getSalePrice());
                rspItemBo.setPurchasePriceRear(rspItemBo.getPurchasePrice());
                if (null != rspItemBo.getSalePriceRear() && null != rspItemBo.getPurchasePriceRear()) {
                    rspItemBo.setMarkUpRateRear(Double.valueOf(rspItemBo.getSalePriceRear().subtract(rspItemBo.getPurchasePriceRear()).abs().divide(rspItemBo.getPurchasePriceRear(), 2).doubleValue()));
                }
                rspItemBo.setDistirbutionId(uocSaleOrderDo.getStakeholder().getProId());
                rspItemBo.setDistirbutionName(uocSaleOrderDo.getStakeholder().getProName());
                UocSaleItemMapQryBo uocSaleItemMapQryBo = new UocSaleItemMapQryBo();
                uocSaleItemMapQryBo.setSaleOrderItemId(item.getSaleOrderItemId());
                List<UocSaleItemMap> saleOrderItemMapList = this.iUocSaleOrderModel.getSaleOrderItemMapList(uocSaleItemMapQryBo);
                if (ObjectUtil.isNotEmpty(saleOrderItemMapList)) {
                    List<UocBaseExtParallelBo> uocBaseExtParallelBos = UocRu.jsl(saleOrderItemMapList, UocBaseExtParallelBo.class);
                    rspItemBo.setItemExtParallelBos(uocBaseExtParallelBos);
                    if (ObjectUtil.equal((Object)rspItemBo.getItemType(), (Object)UocDicConstant.ITEM_TYPE.COMMODITY_SKU)) {
                        rspItemBo.setCommExtParallelBos(uocBaseExtParallelBos);
                    }
                }
                uocGetSaleOrderDetailServiceRspItemBos.add(rspItemBo);
            }
        }
        if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(uocSaleOrderDo.getOrderSource())) {
            UocOrderQueryIndexQryBo queryIndexQryBo = new UocOrderQueryIndexQryBo();
            queryIndexQryBo.setOrderId(reqBo.getOrderId());
            queryIndexQryBo.setObjId(reqBo.getSaleOrderId());
            queryIndexQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            List<UocOrderQueryIndex> uocOrderQueryIndices = this.iUocOrderModel.qryOrderQueryIndexList(queryIndexQryBo);
            if (ObjectUtil.isNotEmpty(uocOrderQueryIndices)) {
                rspBo.setOutOrderId(uocOrderQueryIndices.get(0).getOutObjId());
            }
        }
        List<UocAuditOrderDo> auditOrderList = this.getAuditOrderList(reqBo.getOrderId(), reqBo.getSaleOrderId(), UocDicConstant.OBJ_TYPE.SALE);
        rspBo.setAuditOrderBoList(UocRu.jsl(auditOrderList, UocSaleOrderAuditBO.class));
        List<UocAuditOrderDo> wholeAuditOrderList = this.getAuditOrderList(reqBo.getOrderId(), reqBo.getOrderId(), UocDicConstant.OBJ_TYPE.ORDER);
        rspBo.setWholeAuditOrderBoList(UocRu.jsl(wholeAuditOrderList, UocSaleOrderAuditBO.class));
        rspBo.setAccessoryDetailBoList(accessoryDetailBoList);
        rspBo.setSaleOrderDetailServiceRspExtBoList(uocBaseExtParallelBoList);
        rspBo.setSaleOrderDetailServiceRspItemBoList(uocGetSaleOrderDetailServiceRspItemBos);
        rspBo.setShipOrderInfo(shipOrderInfo);
        rspBo.setInspOrderInfo(inspOrderInfo);
        this.translateProperties(rspBo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private UocGetSaleOrderDetailServiceRspPorcBo getProcInst(UocSaleOrderDo uocSaleOrderDo, String isSale) {
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        Boolean isSaleFlag = false;
        if (StringUtils.isNotBlank((CharSequence)isSale) && isSale.equals("1")) {
            procInstQryBo.setObjId(uocSaleOrderDo.getSaleOrderId());
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            isSaleFlag = true;
        }
        procInstQryBo.setOrderId(uocSaleOrderDo.getOrderId());
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderProcInst> uocOrderProcInsts = this.iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            List<UocGetSaleOrderDetailServiceRspPorcBo> procBoList = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class);
            Map<Integer, List<UocGetSaleOrderDetailServiceRspPorcBo>> procBosMap = procBoList.stream().collect(Collectors.groupingBy(UocGetSaleOrderDetailServiceRspPorcBo::getObjType));
            if (ObjectUtil.isNotEmpty(procBosMap.get(UocDicConstant.OBJ_TYPE.SALE))) {
                procInst = procBosMap.get(UocDicConstant.OBJ_TYPE.SALE).get(0);
            }
            ArrayList<UocOrderTaskInst> uocOrderTaskInsts = new ArrayList<UocOrderTaskInst>();
            if (isSaleFlag.booleanValue()) {
                uocOrderTaskInsts.addAll(this.getOrderTaskInsts(procInst));
            } else {
                procBoList.forEach(bo -> uocOrderTaskInsts.addAll(this.getOrderTaskInsts((UocGetSaleOrderDetailServiceRspPorcBo)bo)));
            }
            List<Object> taskBoList = new ArrayList();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                Map<Integer, List<UocGetSaleOrderDetailServiceRspTaskBo>> taskBosMap = taskBoList.stream().collect(Collectors.groupingBy(UocGetSaleOrderDetailServiceRspTaskBo::getObjType));
                taskBoList.forEach(each -> {
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setObjId(each.getObjId());
                    taskDealQryBo.setObjType(each.getObjType());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = this.iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList());
                });
                if (ObjectUtil.isNotEmpty(taskBosMap.get(UocDicConstant.OBJ_TYPE.SALE))) {
                    procInst.setProcState(taskBosMap.get(UocDicConstant.OBJ_TYPE.SALE).get(0).getProcState());
                    procInst.setTaskId(taskBosMap.get(UocDicConstant.OBJ_TYPE.SALE).get(0).getTaskInstId());
                }
            }
            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }

    private UocGetSaleOrderDetailServiceRspPorcBo getAuditProcInst(UocSaleOrderDo uocSaleOrderDo, Integer objType) {
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        UocApprovalObjQryBo uocApprovalObjQryBo = new UocApprovalObjQryBo();
        uocApprovalObjQryBo.setOrderId(uocSaleOrderDo.getOrderId());
        if (UocDicConstant.OBJ_TYPE.SALE.equals(objType)) {
            uocApprovalObjQryBo.setObjId(uocSaleOrderDo.getSaleOrderId() + "");
            uocApprovalObjQryBo.setObjType(objType);
        } else {
            uocApprovalObjQryBo.setObjId(uocSaleOrderDo.getOrderId() + "");
            uocApprovalObjQryBo.setObjType(objType);
        }
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo);
        if (ObjectUtil.isNotEmpty(uocApprovalObjs)) {
            List<Long> auditOrderIds = uocApprovalObjs.stream().map(UocApprovalObj::getAuditOrderId).collect(Collectors.toList());
            UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
            taskInstQryBo.setOrderId(uocSaleOrderDo.getOrderId());
            taskInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
            taskInstQryBo.setObjIdList(auditOrderIds);
            List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
            List<Object> taskBoList = new ArrayList();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                taskBoList.forEach(each -> {
                    UocApprovalObjQryBo uocApprovalObjQryBo1 = new UocApprovalObjQryBo();
                    uocApprovalObjQryBo1.setAuditOrderId(each.getObjId());
                    List<UocApprovalObj> uocApprovalObjs1 = this.iUocAuditOrderModel.qryApprovealObj(uocApprovalObjQryBo1);
                    Integer objBusiType = uocApprovalObjs1.get(0).getObjBusiType();
                    each.setObjBusiType(objBusiType);
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = this.iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    if (ObjectUtil.isNotEmpty(uocOrderTaskDeals)) {
                        UocOrderTaskDeal uocOrderTaskDeal = uocOrderTaskDeals.get(0);
                        String dealId = uocOrderTaskDeal.getDealId();
                        String dealName = uocOrderTaskDeal.getDealName();
                        each.setDealId(dealId);
                        each.setDealName(dealName);
                    }
                    String auditDealResultQryKey = each.getDealId() + LINE + each.getObjBusiType();
                    if (each.getDealResult() != null) {
                        auditDealResultQryKey = auditDealResultQryKey + LINE + each.getDealResult();
                    }
                    each.setAuditDealResultQryKey(auditDealResultQryKey);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList());
                });
                procInst.setTaskList(taskBoList);
                String procInstId = "";
                for (UocOrderTaskInst bo : uocOrderTaskInsts) {
                    if (0 != bo.getFinishTag()) continue;
                    procInstId = bo.getProcInstId();
                    break;
                }
                if (StringUtils.isNotBlank((CharSequence)procInstId)) {
                    procInst.setProcInstId(procInstId);
                }
            }
        }
        return procInst;
    }

    private List<UocOrderTaskInst> getOrderTaskInsts(UocGetSaleOrderDetailServiceRspPorcBo procInst) {
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setObjId(procInst.getObjId());
        taskInstQryBo.setObjType(procInst.getObjType());
        taskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderTaskInst> uocOrderTaskInsts = this.iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        return uocOrderTaskInsts;
    }

    private List<UocAuditOrderDo> getAuditOrderList(Long orderId, Long objId, Integer objType) {
        UocApprovalObjQryBo obj = new UocApprovalObjQryBo();
        obj.setOrderId(orderId);
        obj.setObjId(Convert.toStr((Object)objId));
        obj.setObjType(objType);
        List<UocApprovalObj> uocApprovalObjs = this.iUocAuditOrderModel.qryApprovealObj(obj);
        if (CollectionUtils.isEmpty(uocApprovalObjs)) {
            return new ArrayList<UocAuditOrderDo>();
        }
        ArrayList<Long> auditOrderIdList = new ArrayList<Long>();
        uocApprovalObjs.forEach(uocApprovalObj -> auditOrderIdList.add(uocApprovalObj.getAuditOrderId()));
        List<UocAuditOrderDo> uocAuditOrderDoList = new ArrayList<UocAuditOrderDo>();
        UocAuditOrderQryBo auditOrderQryBo = new UocAuditOrderQryBo();
        auditOrderQryBo.setOrderId(orderId);
        auditOrderQryBo.setAuditOrderIdList(auditOrderIdList);
        List<UocAuditOrder> uocAuditOrders = this.iUocAuditOrderModel.qryAuditOrderList(auditOrderQryBo);
        if (ObjectUtil.isNotEmpty(uocAuditOrders)) {
            uocAuditOrders.forEach(uocAuditOrder -> {
                UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
                procInstQryBo.setObjId(uocAuditOrder.getAuditOrderId());
                procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
                procInstQryBo.setOrderId(orderId);
                List<UocOrderProcInst> uocOrderProcInsts = this.iUocOrderModel.qryOrderProcInstList(procInstQryBo);
                if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
                    uocAuditOrder.setProcInstId(uocOrderProcInsts.get(0).getProcInstId());
                }
            });
            uocAuditOrderDoList = UocRu.jsl(uocAuditOrders, UocAuditOrderDo.class);
            Map approvalObjMap = uocApprovalObjs.stream().collect(Collectors.groupingByConcurrent(UocApprovalObj::getAuditOrderId));
            uocAuditOrderDoList.forEach(each -> each.setApprovalObjs((List)approvalObjMap.get(each.getAuditOrderId())));
        }
        return uocAuditOrderDoList;
    }

    private static void initialize() {
        pCodeList.add("UOC_SALE_ORDER_STATE");
        pCodeList.add("UOC_SALE_ORDER_NOARGEE_TACHE_CODE");
        pCodeList.add("UOC_SALE_ORDER_ARGEE_TACHE_CODE");
        pCodeList.add("UOC_SALE_ORDER_ECOM_TACHE_CODE");
        pCodeList.add("UOC_SALE_ORDER_SOURCE");
        pCodeList.add("UOC_SALE_ORDER_PAY_TYPE");
        pCodeList.add("UOC_SALE_ORDER_PAY_STATE");
        pCodeList.add("UOC_COMMON_FINISH_FLAG");
        pCodeList.add("UOC_COMMON_MODEL_SETTLE");
        pCodeList.add("UOC_COMMON_PURCHASE_TYPE");
        pCodeList.add("UOC_COMMON_PURCHASE_MODE");
        pCodeList.add("UOC_ORD_INVOICE_TYPE");
        pCodeList.add("UOC_ORD_INVOICE_CATEGORY");
        pCodeList.add("UOC_ORDER_ACCESSORY_ATTACHMENT_TYPE");
        pCodeList.add("UOC_ORDER_OBJ_TYPE");
        pCodeList.add("UOC_COMMON_ITEM_TYPE");
        pCodeList.add("UOC_ORDER_TASK_DEAL_TYPE");
        pCodeList.add("UOC_ORDER_TASK_DEAL_CLASS");
        pCodeList.add("UOC_ORD_AGREEMENT_MODE");
        pCodeList.add("UOC_ORD_ADJUST_PRICE");
        pCodeList.add("SHIP_ORDER_STATE");
        pCodeList.add("INSP_ORDER_STATE");
    }

    private void translateProperties(UocGetSaleOrderDetailServiceRspBo rspBo) {
        Map<String, Map<String, String>> dictionaryMap = this.iUocSysDictionaryModel.getDictionaryMap(pCodeList);
        if (ObjectUtil.isNotEmpty(dictionaryMap)) {
            Integer orderSource = rspBo.getOrderSource();
            String saleOrderState = rspBo.getSaleOrderState();
            UocGetSaleOrderDetailServiceRspPorcBo busiProcInst = rspBo.getProcInst();
            ArrayList<String> stateList = new ArrayList<String>();
            if (StringUtils.isNotBlank((CharSequence)saleOrderState) && StringUtils.isNotBlank((CharSequence)busiProcInst.getProcState())) {
                if ("XS_FH_FHWC".equals(saleOrderState) || "XS_FH_FHZ".equals(saleOrderState)) {
                    stateList.add(busiProcInst.getProcState() + LINE + "XS_FH_FHZ");
                    stateList.add(busiProcInst.getProcState() + LINE + "XS_FH_FHWC");
                } else {
                    stateList.add(busiProcInst.getProcState() + LINE + saleOrderState);
                }
            } else if (StringUtils.isNotBlank((CharSequence)saleOrderState)) {
                stateList.add(saleOrderState);
            } else if (StringUtils.isNotBlank((CharSequence)busiProcInst.getProcState())) {
                stateList.add(busiProcInst.getProcState());
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_NOARGEE_TACHE_CODE")) && UocConstant.SkuSource.SELF.equals(orderSource) && ObjectUtil.isNotEmpty(stateList)) {
                rspBo.setSaleOrderStateStr(dictionaryMap.get("UOC_SALE_ORDER_NOARGEE_TACHE_CODE").get(stateList.get(0)));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_ECOM_TACHE_CODE")) && UocConstant.SkuSource.ELC.equals(orderSource) && ObjectUtil.isNotEmpty(stateList)) {
                rspBo.setSaleOrderStateStr(dictionaryMap.get("UOC_SALE_ORDER_ECOM_TACHE_CODE").get(stateList.get(0)));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_ARGEE_TACHE_CODE")) && UocConstant.SkuSource.AGR.equals(orderSource) && ObjectUtil.isNotEmpty(stateList)) {
                rspBo.setSaleOrderStateStr(dictionaryMap.get("UOC_SALE_ORDER_ARGEE_TACHE_CODE").get(stateList.get(0)));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_SOURCE")) && ObjectUtil.isNotEmpty((Object)rspBo.getOrderSource())) {
                rspBo.setOrderSourceStr(dictionaryMap.get("UOC_SALE_ORDER_SOURCE").get(rspBo.getOrderSource().toString()));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_PAY_TYPE"))) {
                rspBo.setPayTypeStr(dictionaryMap.get("UOC_SALE_ORDER_PAY_TYPE").get(rspBo.getPayType()));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_SALE_ORDER_PAY_STATE")) && ObjectUtil.isNotEmpty((Object)rspBo.getPayState())) {
                rspBo.setPayStateStr(dictionaryMap.get("UOC_SALE_ORDER_PAY_STATE").get(rspBo.getPayState().toString()));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_FINISH_FLAG")) && ObjectUtil.isNotEmpty((Object)rspBo.getFinishFlag())) {
                rspBo.setFinishFlagStr(dictionaryMap.get("UOC_COMMON_FINISH_FLAG").get(rspBo.getFinishFlag().toString()));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_MODEL_SETTLE")) && ObjectUtil.isNotEmpty((Object)rspBo.getModelSettle())) {
                rspBo.setModelSettleStr(dictionaryMap.get("UOC_COMMON_MODEL_SETTLE").get(rspBo.getModelSettle().toString()));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_PURCHASE_TYPE")) && ObjectUtil.isNotEmpty((Object)rspBo.getPurchaseType())) {
                rspBo.setPurchaseTypeStr(dictionaryMap.get("UOC_COMMON_PURCHASE_TYPE").get(rspBo.getPurchaseType().toString()));
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_PURCHASE_MODE")) && ObjectUtil.isNotEmpty((Object)rspBo.getPurchaseMode())) {
                rspBo.setPurchaseModeStr(dictionaryMap.get("UOC_COMMON_PURCHASE_MODE").get(rspBo.getPurchaseMode().toString()));
            }
            if (ObjectUtil.isNotEmpty((Object)rspBo.getInvoiceBo())) {
                UocGetSaleOrderDetailServiceRspInvoiceBo invoiceBo = rspBo.getInvoiceBo();
                if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORD_INVOICE_TYPE")) && ObjectUtil.isNotEmpty((Object)invoiceBo.getInvoiceType())) {
                    invoiceBo.setInvoiceTypeStr(dictionaryMap.get("UOC_ORD_INVOICE_TYPE").get(invoiceBo.getInvoiceType().toString()));
                }
                if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORD_INVOICE_CATEGORY")) && ObjectUtil.isNotEmpty((Object)invoiceBo.getInvoceCategory())) {
                    invoiceBo.setInvoceCategoryStr(dictionaryMap.get("UOC_ORD_INVOICE_CATEGORY").get(invoiceBo.getInvoceCategory().toString()));
                }
            }
            if (ObjectUtil.isNotEmpty((Object)rspBo.getAccessoryDetailBoList())) {
                rspBo.getAccessoryDetailBoList().forEach(each -> {
                    if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORDER_ACCESSORY_ATTACHMENT_TYPE")) && ObjectUtil.isNotEmpty((Object)each.getAttachmentType())) {
                        each.setAttachmentTypeStr((String)((Map)dictionaryMap.get("UOC_ORDER_ACCESSORY_ATTACHMENT_TYPE")).get(each.getAttachmentType().toString()));
                    }
                    if (ObjectUtil.isNotEmpty((Object)each.getAttchList())) {
                        for (UocBaseOrderAccessoryDetailBo accessoryDetailBo : each.getAttchList()) {
                            if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORDER_OBJ_TYPE")) && ObjectUtil.isNotEmpty((Object)accessoryDetailBo.getObjType())) {
                                accessoryDetailBo.setObjTypeStr((String)((Map)dictionaryMap.get("UOC_ORDER_OBJ_TYPE")).get(accessoryDetailBo.getObjType().toString()));
                            }
                            if (!ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORDER_ACCESSORY_ATTACHMENT_TYPE")) || !ObjectUtil.isNotEmpty((Object)accessoryDetailBo.getAttachmentType())) continue;
                            accessoryDetailBo.setAttachmentTypeStr((String)((Map)dictionaryMap.get("UOC_ORDER_ACCESSORY_ATTACHMENT_TYPE")).get(accessoryDetailBo.getAttachmentType().toString()));
                        }
                    }
                });
            }
            if (ObjectUtil.isNotEmpty((Object)rspBo.getSaleOrderDetailServiceRspItemBoList())) {
                rspBo.getSaleOrderDetailServiceRspItemBoList().forEach(each -> {
                    if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_COMMON_ITEM_TYPE")) && ObjectUtil.isNotEmpty((Object)each.getItemType())) {
                        each.setItemTypeStr((String)((Map)dictionaryMap.get("UOC_COMMON_ITEM_TYPE")).get(each.getItemType().toString()));
                    }
                });
            }
            if (ObjectUtil.isNotNull((Object)rspBo.getAgreementInfo())) {
                UocGetSaleOrderDetailServiceRspAgreementInfoBo agreementInfo = rspBo.getAgreementInfo();
                if (null != agreementInfo.getAgreementCode()) {
                    agreementInfo.setAgreementCodeStr(dictionaryMap.get("UOC_ORD_AGREEMENT_MODE").get(agreementInfo.getAgreementCode().toString()));
                }
                if (null != agreementInfo.getAdjustPrice()) {
                    agreementInfo.setAdjustPriceStr(dictionaryMap.get("UOC_ORD_ADJUST_PRICE").get(agreementInfo.getAdjustPrice().toString()));
                }
            }
            if (ObjectUtil.isNotEmpty((Object)rspBo.getProcInst())) {
                UocGetSaleOrderDetailServiceRspPorcBo procInst = rspBo.getProcInst();
                if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORDER_OBJ_TYPE")) && ObjectUtil.isNotEmpty((Object)procInst.getObjType())) {
                    procInst.setObjTypeStr(dictionaryMap.get("UOC_ORDER_OBJ_TYPE").get(procInst.getObjType().toString()));
                }
                if (ObjectUtil.isNotEmpty((Object)procInst.getTaskList())) {
                    procInst.getTaskList().forEach(each -> {
                        if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORDER_OBJ_TYPE")) && ObjectUtil.isNotEmpty((Object)each.getObjType())) {
                            each.setObjTypeStr((String)((Map)dictionaryMap.get("UOC_ORDER_OBJ_TYPE")).get(each.getObjType().toString()));
                        }
                        if (ObjectUtil.isNotEmpty((Object)each.getTaskDealBo())) {
                            for (UocGetSaleOrderDetailServiceRspTaskDealBo taskDealBo : each.getTaskDealBo()) {
                                if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORDER_OBJ_TYPE")) && ObjectUtil.isNotEmpty((Object)taskDealBo.getObjType())) {
                                    taskDealBo.setObjTypeStr((String)((Map)dictionaryMap.get("UOC_ORDER_OBJ_TYPE")).get(taskDealBo.getObjType().toString()));
                                }
                                if (ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORDER_TASK_DEAL_TYPE")) && ObjectUtil.isNotEmpty((Object)taskDealBo.getDealType())) {
                                    taskDealBo.setDealTypeStr((String)((Map)dictionaryMap.get("UOC_ORDER_TASK_DEAL_TYPE")).get(taskDealBo.getDealType().toString()));
                                }
                                if (!ObjectUtil.isNotEmpty(dictionaryMap.get("UOC_ORDER_TASK_DEAL_CLASS"))) continue;
                                taskDealBo.setDealClassStr((String)((Map)dictionaryMap.get("UOC_ORDER_TASK_DEAL_CLASS")).get(taskDealBo.getDealClass()));
                            }
                        }
                    });
                }
            }
            if (ObjectUtil.isNotEmpty((Object)rspBo.getShipOrderInfo())) {
                rspBo.getShipOrderInfo().forEach(each -> {
                    each.setShipOrderStateStr((String)((Map)dictionaryMap.get("SHIP_ORDER_STATE")).get(each.getShipOrderState()));
                    if (ObjectUtil.isNotEmpty((Object)each.getShipOrderItemInfo())) {
                        each.getShipOrderItemInfo().forEach(item -> item.setShipItemStateStr((String)((Map)dictionaryMap.get("SHIP_ORDER_STATE")).get(item.getShipItemState())));
                    }
                });
            }
            if (ObjectUtil.isNotEmpty((Object)rspBo.getInspOrderInfo())) {
                rspBo.getInspOrderInfo().forEach(each -> {
                    each.setInspOrderStateStr((String)((Map)dictionaryMap.get("INSP_ORDER_STATE")).get(each.getInspOrderState()));
                    if (ObjectUtil.isNotEmpty((Object)each.getInspOrderItemInfo())) {
                        each.getInspOrderItemInfo().forEach(item -> item.setInspItemStatusStr((String)((Map)dictionaryMap.get("SHIP_ORDER_STATE")).get(item.getInspItemStatus())));
                    }
                });
            }
        }
    }

    private void validateParam(UocGetSaleOrderDetailServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getSaleOrderId() == null) {
            throw new BaseBusinessException("100001", "\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException("100001", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    static {
        UocGetSaleOrderDetailServiceImpl.initialize();
    }
}

