package com.tydic.dyc.oc.model.order.sub;

import com.tydic.utils.generatedoc.annotation.DocField;
import lombok.Data;

import java.io.Serializable;

/**
 * 标题:UocOrderQueryIndex
 * 说明:外部系统单号关联表，主要用于关联电商的外部单号，提升查询效率
 * 时间:2022-04-06 16:03
 * 作者:tkl
 **/
@Data
public class UocOrderQueryIndex implements Serializable {
	private static final long serialVersionUID = -1334051643269897262L;

	@DocField(value = "id")
	private Long id;

	@DocField(value = "单据id")
	private Long objId;

	@DocField(value = "单据类型 1订单  2.销售单 3 发货单 4.收货单  5.售后服务单  6.支付单 99.其他")
	private Integer objType;

	@DocField(value = "订单id")
	private Long orderId;

	@DocField(value = "外部单号")
	private String outObjId;

	@DocField(value = "订单来源系统")
	private String orderSystem;

	@DocField(value = "排序")
	private String orderBy;
}
