package com.tydic.dyc.oc.model.waitdone.impl;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.waitdone.IUocWaitDoneModel;
import com.tydic.dyc.oc.model.waitdone.UocWaitDoneConfigDo;
import com.tydic.dyc.oc.model.waitdone.qrybo.UocWaitDoneConfigQryBo;
import com.tydic.dyc.oc.repository.UocWaitDoneRepository;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 标题：类名称:IUocWaitDoneModelImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/5/19 19:39
 * 作者 @author 尹栋梁
 */
@Service
@Slf4j
public class IUocWaitDoneModelImpl implements IUocWaitDoneModel {
    @Autowired
    private UocWaitDoneRepository uocWaitDoneRepository;
    @Override
    public List<UocWaitDoneConfigDo> qryWaitDoneList(UocWaitDoneConfigQryBo uocWaitDoneConfigQryBo) {
        if (null == uocWaitDoneConfigQryBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        return uocWaitDoneRepository.qryWaitDoneList(uocWaitDoneConfigQryBo);
    }
}
