package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocDMsgPoolQryBo;
import com.tydic.dyc.oc.service.domainservice.UocQryMsgPoolCountService;
import com.tydic.dyc.oc.service.order.bo.UocQryMsgPoolCountServiceReqBo;
import com.tydic.dyc.oc.service.order.bo.UocQryMsgPoolCountServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

@Slf4j
@HTServiceImpl
public class UocQryMsgPoolCountServiceImpl implements UocQryMsgPoolCountService {
    @Autowired
    private IUocOrderModel iUocOrderModel;
    
    @Override
    public UocQryMsgPoolCountServiceRspBo qryMsgCount(UocQryMsgPoolCountServiceReqBo reqBo) {
        UocQryMsgPoolCountServiceRspBo rspBo = new UocQryMsgPoolCountServiceRspBo();
        if(reqBo == null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        int count = iUocOrderModel.getCheckMsg(UocRu.js(reqBo, UocDMsgPoolQryBo.class));
    
        rspBo.setMsgCount(count);
        return rspBo;
    }
}
