/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.service.domainservice.UocOrderStatisticService;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrderStatisticReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocOrderStatisticRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.domainservice.UocOrderStatisticService"})
public class UocOrderStatisticServiceImpl
implements UocOrderStatisticService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;

    @PostMapping(value={"qryStatisticInfo"})
    public UocOrderStatisticRspBo qryStatisticInfo(@RequestBody UocOrderStatisticReqBo reqBo) {
        this.validateArg(reqBo);
        UocOrderStatisticRspBo success = UocRu.success(UocOrderStatisticRspBo.class);
        if (UocConstant.SearchType.SALE.equals(reqBo.getSearchType())) {
            UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
            uocSaleOrderQryBo.setCreateTimeStart((Date)DateUtil.parse((CharSequence)reqBo.getCreateTimeStart()));
            uocSaleOrderQryBo.setCreateTimeEnd((Date)DateUtil.parse((CharSequence)reqBo.getCreateTimeEnd()));
            uocSaleOrderQryBo.setSupId(Convert.toLong((Object)reqBo.getSupNo()));
            UocSaleOrderDo uocSaleOrderDo = this.iUocSaleOrderModel.qryTotalFeeAndCount(uocSaleOrderQryBo);
            success.setTotalCount(uocSaleOrderDo.getTotalCount());
            success.setTotalFee(uocSaleOrderDo.getTotalFee());
        } else {
            UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
            uocInspOrderQryBo.setCreateTimeStart((Date)DateUtil.parse((CharSequence)reqBo.getCreateTimeStart()));
            uocInspOrderQryBo.setCreateTimeEnd((Date)DateUtil.parse((CharSequence)reqBo.getCreateTimeEnd()));
            uocInspOrderQryBo.setSupId(Convert.toLong((Object)reqBo.getSupNo()));
            UocInspOrderDo uocInspOrderDo = this.iUocInspOrderModel.qryTotalFeeAndCount(uocInspOrderQryBo);
            success.setTotalCount(uocInspOrderDo.getTotalCount());
            success.setTotalFee(uocInspOrderDo.getTotalFee());
        }
        return success;
    }

    private void validateArg(UocOrderStatisticReqBo reqBo) {
        if (StringUtils.isBlank((CharSequence)reqBo.getSupNo())) {
            throw new BaseBusinessException("100001", "supNo\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getSearchType()) {
            throw new BaseBusinessException("100001", "searchType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getCreateTimeStart())) {
            throw new BaseBusinessException("100001", "createTimeStart\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBo.getCreateTimeEnd())) {
            throw new BaseBusinessException("100001", "createTimeEnd\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

