package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.*;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题：类名称:UocNumChngOrderCreateHRServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/5/23 10:22
 * 作者 @author 尹栋梁
 */
@HTServiceImpl
public class UocNumChngOrderCreateHRServiceImpl implements UocNumChngOrderCreateHRService{
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocInspOrderModel uocInspOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Override
    public UocNumChngOrderCreateHRRspBo createNumChng(UocNumChngOrderCreateHRReqBo reqBo) {
        validateArg(reqBo);
        String operId = reqBo.getUserId().toString();
        Date now = new Date();
        //获取验收单列表详情
        List<UocInspOrderItem> inspOrderItemList = getInspOrderList(reqBo);
        //检验是否能发起异常变更
        checkChngingCount(reqBo, inspOrderItemList);
        //获取销售单信息
        List<UocSaleOrderItem> saleOrderItems = getSaleOrderItemList(reqBo);
        //转换变更单Do对象
        UocChngOrderDo uocChngOrderDo = convertChngOrderDo(reqBo, operId, now, inspOrderItemList, saleOrderItems);
        //变更单Do对象入库
        iUocChngOrderModel.createChngOrder(uocChngOrderDo);
        //修改 销售单异常在途数量，验收单明细异常在途数量
        for (UocNumChngOrderCreateHRReqInspBo uocNumChngOrderCreateReqInspBo : reqBo.getChngItemList()) {
            uocInspOrderModel.modifyInspOrderItemChngingCount(convertInspOrderDo(reqBo, uocNumChngOrderCreateReqInspBo, operId, now));
            iUocSaleOrderModel.modifyBatchItemChngingCount(convertSaleOrderDo(reqBo, uocNumChngOrderCreateReqInspBo,inspOrderItemList, operId, now));
        }

        //封装出参对象
        UocNumChngOrderCreateHRRspBo uocNumChngOrderCreateRspBo = UocRu.success(UocNumChngOrderCreateHRRspBo.class);
        uocNumChngOrderCreateRspBo.setChngOrderId(uocChngOrderDo.getChngOrderId());
        uocNumChngOrderCreateRspBo.getInspOrderIdList().addAll(reqBo.getChngItemList().stream().map(UocNumChngOrderCreateHRReqInspBo::getInspOrderId).collect(Collectors.toList()));
        return uocNumChngOrderCreateRspBo;
    }

    private UocSaleOrderDo convertSaleOrderDo(UocNumChngOrderCreateHRReqBo reqBo, UocNumChngOrderCreateHRReqInspBo uocNumChngOrderCreateReqInspBo, List<UocInspOrderItem> inspOrderItemList, String operId, Date now) {
        Map<Long, UocInspOrderItem> inspOrderItemMap = inspOrderItemList.stream().collect(Collectors.toMap(UocInspOrderItem::getInspOrderItemId, o -> o));
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setUpdateOperId(operId);
        ArrayList<UocSaleOrderItem> saleOrderItems = new ArrayList<>();
        uocNumChngOrderCreateReqInspBo.getInspOrderItemList().forEach(x->{
            UocInspOrderItem uocInspOrderItem = inspOrderItemMap.get(x.getInspOrderItemId());
            Long saleOrderItemId = uocInspOrderItem.getSaleOrderItemId();
            UocSaleOrderItem uocSaleOrderItem = new UocSaleOrderItem();
            uocSaleOrderItem.setSaleOrderItemId(saleOrderItemId);
            uocSaleOrderItem.setChngingCount(x.getChngCount());
            uocSaleOrderItem.setUpdateTime(now);
            uocSaleOrderItem.setUpdateOperId(operId);
            saleOrderItems.add(uocSaleOrderItem);
        });
        uocSaleOrderDo.setSaleOrderItems(saleOrderItems);
        return uocSaleOrderDo;
    }

    private UocInspOrderDo convertInspOrderDo(UocNumChngOrderCreateHRReqBo reqBo, UocNumChngOrderCreateHRReqInspBo uocNumChngOrderCreateReqInspBo, String operId, Date now) {
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setInspOrderId(uocNumChngOrderCreateReqInspBo.getInspOrderId());
        uocInspOrderDo.setOrderId(reqBo.getOrderId());
        uocInspOrderDo.setUpdateOperId(operId);
        uocInspOrderDo.setUpdateTime(now);
        List<UocInspOrderItem> uocInspOrderItemList = new ArrayList<>();
        uocNumChngOrderCreateReqInspBo.getInspOrderItemList().forEach(inspItemBo->{
            UocInspOrderItem uocInspOrderItem = new UocInspOrderItem();
            uocInspOrderItem.setInspOrderItemId(inspItemBo.getInspOrderItemId());
            uocInspOrderItem.setChngingCount(inspItemBo.getChngCount());
            uocInspOrderItem.setUpdateOperId(operId);
            uocInspOrderItem.setUpdateTime(now);
            uocInspOrderItemList.add(uocInspOrderItem);
        });
        uocInspOrderDo.setUocInspOrderItemList(uocInspOrderItemList);
        return uocInspOrderDo;

    }

    private String getChngOrderNo(UocNumChngOrderCreateHRReqBo reqBo) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setSaleOrderId(reqBo.getSaleOrderId());
        uocSaleOrderDo.setOrderId(reqBo.getOrderId());
        uocSaleOrderDo = iUocSaleOrderModel.getSaleOrderMain(uocSaleOrderDo);
        if (null == uocSaleOrderDo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_IMPL_SHIP_ORDER_ERROR, "查询验收单为空");
        }
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setBusiType(UocConstant.BUSI_TYPE.NUM);
        uocChngOrderQryBo.setOrderSource(uocSaleOrderDo.getOrderSource());
        UocChngOrderDo uocChngOrderDo = iUocChngOrderModel.getChngOrderNo(uocChngOrderQryBo);
        return uocChngOrderDo.getChngOrderNo();
    }

    private UocChngOrderDo convertChngOrderDo(UocNumChngOrderCreateHRReqBo reqBo, String operId, Date now, List<UocInspOrderItem> inspOrderItemList, List<UocSaleOrderItem> saleOrderItems) {
        Map<Long, UocInspOrderItem> inspOrderItemMap = inspOrderItemList.stream().collect(Collectors.toMap(UocInspOrderItem::getInspOrderItemId, o -> o));
        
        Map<Long, UocSaleOrderItem> saleOrderItemMap = saleOrderItems.stream().collect(Collectors.toMap(UocSaleOrderItem::getSaleOrderItemId, o -> o));
        UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
        uocChngOrderDo.setChngOrderId(IdUtil.nextId());
        uocChngOrderDo.setChngOrderState(UocStateConstants.ChngOrder.NUM.CHNG_CHNG_QRZ);
        uocChngOrderDo.setCreateOperId(operId);
        uocChngOrderDo.setTenantId(reqBo.getTenantId());
        uocChngOrderDo.setCreateTime(now);
        uocChngOrderDo.setCreateOperName(reqBo.getName());
        uocChngOrderDo.setCreateOperMobile(reqBo.getCellphone());
        uocChngOrderDo.setOrderId(reqBo.getOrderId());
        uocChngOrderDo.setBusiType(UocConstant.BUSI_TYPE.NUM);
        uocChngOrderDo.setRemark(reqBo.getRemark());
        uocChngOrderDo.setChngOrderNo(getChngOrderNo(reqBo));
        List<UocChngOrderObj> uocChngOrderObjList = new ArrayList<>();
        for (UocNumChngOrderCreateHRReqInspBo uocNumChngOrderCreateHRReqInspBo : reqBo.getChngItemList()) {
            UocChngOrderObj uocChngOrderObj = new UocChngOrderObj();
            uocChngOrderObj.setChngOrderId(uocChngOrderDo.getChngOrderId());
            uocChngOrderObj.setOrderId(reqBo.getOrderId());
            uocChngOrderObj.setSaleOrderId(reqBo.getSaleOrderId());
//        uocChngOrderObj.setImplOrderId(reqBo.getImplOrderId());
            uocChngOrderObj.setInspOrderId(uocNumChngOrderCreateHRReqInspBo.getInspOrderId());
            uocChngOrderObj.setChngOrderObjId(IdUtil.nextId());
            uocChngOrderObj.setChngType(UocConstant.BUSI_TYPE.NUM);
            uocChngOrderObj.setCreateOperId(operId);
            uocChngOrderObj.setCreateTime(now);
            List<UocChngOrderItemObj> uocChngOrderItemObjList = new ArrayList<>();
            uocChngOrderObj.setChngNum(BigDecimal.ZERO);
            uocChngOrderObj.setChngFee(BigDecimal.ZERO);
            uocNumChngOrderCreateHRReqInspBo.getInspOrderItemList().forEach(x->{
                UocInspOrderItem uocInspOrderItem = inspOrderItemMap.get(x.getInspOrderItemId());
                UocSaleOrderItem saleOrderItem = saleOrderItemMap.get(uocInspOrderItem.getSaleOrderItemId());
                UocChngOrderItemObj uocChngOrderItemObj = new UocChngOrderItemObj();
                uocChngOrderItemObj.setChngNum(x.getChngCount());
                uocChngOrderItemObj.setInspOrderItemId(x.getInspOrderItemId());
                uocChngOrderItemObj.setChngFee(x.getChngCount().multiply(saleOrderItem.getSalePrice()));
                uocChngOrderItemObj.setChngOrderId(uocChngOrderObj.getChngOrderId());
                uocChngOrderItemObj.setChngOrderObjId(uocChngOrderObj.getChngOrderObjId());
                uocChngOrderItemObj.setSaleOrderItemId(uocInspOrderItem.getSaleOrderItemId());
                uocChngOrderItemObj.setChngType(UocConstant.BUSI_TYPE.NUM);
                uocChngOrderItemObj.setOrderId(reqBo.getOrderId());
                uocChngOrderItemObj.setId(IdUtil.nextId());
                uocChngOrderItemObj.setCreateOperId(operId);
                uocChngOrderItemObj.setCreateTime(now);
                uocChngOrderItemObjList.add(uocChngOrderItemObj);
                uocChngOrderObj.setChngNum(uocChngOrderObj.getChngNum().add(x.getChngCount()));
                uocChngOrderObj.setChngFee(uocChngOrderObj.getChngNum().multiply(saleOrderItem.getSalePrice()));
            });
            uocChngOrderObj.setUocChngOrderItemObjList(uocChngOrderItemObjList);
            uocChngOrderObjList.add(uocChngOrderObj);
        }

        uocChngOrderDo.setUocChngOrderObjList(uocChngOrderObjList);
        if (!CollectionUtils.isEmpty(reqBo.getExtParallelBoList())) {
            List<UocChngOrderMap> uocChngOrderMapList = UocRu.jsl(reqBo.getExtParallelBoList(), UocChngOrderMap.class);
            uocChngOrderMapList.forEach(uocChngOrderMap -> {
                uocChngOrderMap.setChngOrderId(uocChngOrderDo.getChngOrderId());
                uocChngOrderMap.setOrderId(uocChngOrderDo.getOrderId());
                uocChngOrderMap.setCreateOperId(operId);
                uocChngOrderMap.setCreateTime(now);
                uocChngOrderMap.setId(IdUtil.nextId());
            });
            uocChngOrderDo.setUocChngOrderMapList(uocChngOrderMapList);
        }

        if (!CollectionUtils.isEmpty(reqBo.getOrderAccessoryBoList())) {
            List<UocOrderAccessory> uocOrderAccessoryList = UocRu.jsl(reqBo.getOrderAccessoryBoList(), UocOrderAccessory.class);
            uocOrderAccessoryList.forEach(uocOrderAccessory -> {
                uocOrderAccessory.setOrderId(reqBo.getOrderId());
                uocOrderAccessory.setCreateTime(now);
                uocOrderAccessory.setCreateOperId(reqBo.getUserId().toString());
                uocOrderAccessory.setId(IdUtil.nextId());
                uocOrderAccessory.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
                uocOrderAccessory.setAttachmentType(1);
                uocOrderAccessory.setObjId(uocChngOrderDo.getChngOrderId());
            });
            uocChngOrderDo.setOrderAccessoryBoList(uocOrderAccessoryList);
        }
        return uocChngOrderDo;

    }

    private List<UocSaleOrderItem> getSaleOrderItemList(UocNumChngOrderCreateHRReqBo reqBo) {
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (CollectionUtils.isEmpty(saleOrderItemList)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_NUM_CHNG_APPLY_ERROR, "查询销售单明细列表为空");
        }
        return saleOrderItemList;
    }

    private void checkChngingCount(UocNumChngOrderCreateHRReqBo reqBo, List<UocInspOrderItem> inspOrderItemList) {
        if (CollectionUtil.isNotEmpty(inspOrderItemList)) {
            Map<Long, UocInspOrderItem> inspOrderItemMap = inspOrderItemList.stream().collect(Collectors.toMap(UocInspOrderItem::getInspOrderItemId, o -> o));
            reqBo.getChngItemList().forEach(chngOrderCreateHRReqInspBo -> {
                chngOrderCreateHRReqInspBo.getInspOrderItemList().forEach(uocNumChngOrderCreateHRReqInspItemBo -> {
                    Long inspOrderItemId = uocNumChngOrderCreateHRReqInspItemBo.getInspOrderItemId();
                    UocInspOrderItem uocInspOrderItem = inspOrderItemMap.get(inspOrderItemId);
                    if (!(uocNumChngOrderCreateHRReqInspItemBo.getChngCount().compareTo(BigDecimal.ZERO) >= 0 && uocNumChngOrderCreateHRReqInspItemBo.getChngCount().compareTo(uocInspOrderItem.getInspCount()) <= 0)) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "变更数量不能超过验收数量");
                    }
                    UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
                    uocChngOrderItemObjQryBo.setInspOrderItemId(inspOrderItemId);
                    uocChngOrderItemObjQryBo.setChngType(UocConstant.BUSI_TYPE.NUM);
                    List<UocChngOrderItemObj> listChngOrderItemObj = iUocChngOrderModel.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
                    if (CollectionUtil.isNotEmpty(listChngOrderItemObj)) {
                        Long chngOrderId = listChngOrderItemObj.get(0).getChngOrderId();
                        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
                        uocChngOrderQryBo.setChngOrderId(chngOrderId);
                        uocChngOrderQryBo.setOrderId(reqBo.getOrderId());
                        UocChngOrderDo chngOrder = iUocChngOrderModel.getChngOrder(uocChngOrderQryBo);
                        if (ObjectUtil.isNotEmpty(chngOrder)) {
                            String chngOrderState = chngOrder.getChngOrderState();
                            if (!UocStateConstants.ChngOrder.NUM.CHNG_CHNG_JJ.equals(chngOrderState)) {
                                throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "已存在异常变更");
                            }
                        }
                    }
                });
            });
        }
    }

    private List<UocInspOrderItem> getInspOrderList(UocNumChngOrderCreateHRReqBo reqBo) {
        List<UocInspOrderItem> inspOrderItemList = new ArrayList<>();
        for (UocNumChngOrderCreateHRReqInspBo uocNumChngOrderCreateReqShipBo : reqBo.getChngItemList()) {
            UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
            uocInspOrderItemQryBo.setInspOrderItemIdList(uocNumChngOrderCreateReqShipBo.getInspOrderItemList().stream().map(UocNumChngOrderCreateHRReqInspItemBo::getInspOrderItemId).collect(Collectors.toList()));
            uocInspOrderItemQryBo.setOrderId(reqBo.getOrderId());
            uocInspOrderItemQryBo.setSaleOrderId(reqBo.getSaleOrderId());
            UocInspOrderDo uocInspOrderDo = uocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);

            if (CollectionUtils.isEmpty(uocInspOrderDo.getUocInspOrderItemList())) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_NUM_CHNG_APPLY_ERROR, "查询验收单明细列表为空");
            }
            inspOrderItemList.addAll(uocInspOrderDo.getUocInspOrderItemList());
        }
        return inspOrderItemList;
    }

    private void validateArg(UocNumChngOrderCreateHRReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID为空");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID为空");
        }
        if (CollectionUtils.isEmpty(reqBo.getChngItemList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更信息列表为空");
        }
        reqBo.getChngItemList().forEach(uocNumChngOrderCreateReqItemBo -> {
            if (null == uocNumChngOrderCreateReqItemBo.getInspOrderId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参验收单ID为空");
            }
            if (null == uocNumChngOrderCreateReqItemBo.getInspOrderItemList()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参验收对象为空");
            }
            uocNumChngOrderCreateReqItemBo.getInspOrderItemList().forEach(x->{
                if (null == x.getInspOrderItemId()) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参验收单明细ID为空");
                }
                if (null == x.getChngCount()) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更数量为空");
                }
            });
        });

    }
}
