package com.tydic.dyc.oc.service.saleorder;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.UocAuditOrderDo;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.qrybo.UocAuditOrderQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.model.audit.sub.UocAuditOrder;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderQryBo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderQryBo;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.*;
import com.tydic.dyc.oc.model.order.sub.*;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.payorder.qrybo.UocPayOrderQryBo;
import com.tydic.dyc.oc.model.payorder.sub.UocPayOrder;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.*;
import com.tydic.dyc.oc.model.saleorder.sub.*;
import com.tydic.dyc.oc.model.shiporder.IUocShipOrderModel;
import com.tydic.dyc.oc.model.shiporder.UocShipOrderDo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderItemQryBo;
import com.tydic.dyc.oc.model.shiporder.qrybo.UocShipOrderQryBo;
import com.tydic.dyc.oc.model.shiporder.sub.UocShipOrderItem;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.common.bo.UocBaseExtParallelBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryDetailBo;
import com.tydic.dyc.oc.service.common.bo.UocBaseOrderAccessoryTypeDetailBo;
import com.tydic.dyc.oc.service.saleorder.bo.*;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 标题:UocGetSaleOrderDetailServiceImpl
 * 说明:
 * 时间:2022/2/25 10:29
 * 作者:田坤林
 */
@HTServiceImpl
public class UocGetSaleOrderDetailServiceImpl implements UocGetSaleOrderDetailService {

    public static final List<String> pCodeList = ListUtil.list(false);

    static {
        initialize();
    }

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocSysDictionaryModel iUocSysDictionaryModel;
    @Autowired
    private IUocShipOrderModel iUocShipOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    private static final String LINE = "_";

    @Value("${uoc.obj_type.isSale:0}")
    private String isSale;

    @Override
    public UocGetSaleOrderDetailServiceRspBo getSaleOrderDetail(UocGetSaleOrderDetailServiceReqBo reqBo) {
        //入参校验
        validateParam(reqBo);
        //销售单附件
        List<UocBaseOrderAccessoryTypeDetailBo> accessoryDetailBoList = new ArrayList<>();
        //销售单纵向扩展
        List<UocBaseExtParallelBo> uocBaseExtParallelBoList = new ArrayList<>();
        //销售单明细
        List<UocGetSaleOrderDetailServiceRspItemBo> uocGetSaleOrderDetailServiceRspItemBos = new ArrayList<>();
        //发货单信息
        List<UocGetSaleOrderDetailServiceRspShipOrderInfoBo> shipOrderInfo = new ArrayList<>();
        //验收单信息
        List<UocGetSaleOrderDetailServiceRspInspOrderInfoBo> inspOrderInfo = new ArrayList<>();

        //查询销售单主体
        UocSaleOrderQryBo uocSaleOrderQryBo = UocRu.js(reqBo, UocSaleOrderQryBo.class);
        UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
        if (Objects.isNull(uocSaleOrderDo)) {
            return UocRu.success(UocGetSaleOrderDetailServiceRspBo.class);
        }
        UocGetSaleOrderDetailServiceRspBo rspBo = UocRu.js(uocSaleOrderDo, UocGetSaleOrderDetailServiceRspBo.class);
        if (null == rspBo.getTotalTransFee()) {
            rspBo.setTotalTransFee(BigDecimal.ZERO);
        }
        //三方信息
        if (null != uocSaleOrderDo.getStakeholder()) {
            UocSaleStakeholder stakeholder = uocSaleOrderDo.getStakeholder();
            BeanUtils.copyProperties(stakeholder, rspBo);
            rspBo.setDistirbutionId(stakeholder.getSupId());
            rspBo.setDistirbutionName(stakeholder.getSupName());
            rspBo.setDistirbutionIdContactName(stakeholder.getSupRelaName());
            rspBo.setDistirbutionIdContactMobile(stakeholder.getSupRelaMobile());
            rspBo.setUocGetSaleOrderDetailServiceRspStakeholderBo(UocRu.js(stakeholder, UocGetSaleOrderDetailServiceRspStakeholderBo.class));
        }
        //支付配置
        UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
        uocSaleOrderPayConfQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderPayConfQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocSaleOrderPayConf> saleOrderPayConfList = iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
        if (ObjectUtil.isNotEmpty(saleOrderPayConfList)) {
            saleOrderPayConfList = saleOrderPayConfList.stream()
                    .filter(each -> ObjectUtil.notEqual(each.getPayType(), UocDicConstant.PAY_TYPE.PAY_BY_PERIOD)
                            && null != each.getPrePayFee() && null != each.getVerPayFee() && null != each.getPilPayFee() && null != each.getQuaPayFee())
                    .collect(Collectors.toList());
            if (ObjectUtil.isNotEmpty(saleOrderPayConfList)) {
                UocSaleOrderPayConf payConf = saleOrderPayConfList.get(0);
                rspBo.setPayRatio(payConf.getPrePayFee().multiply(BigDecimal.valueOf(0.2))
                        .subtract(payConf.getVerPayFee().multiply(BigDecimal.valueOf(0.4)))
                        .subtract(payConf.getPilPayFee().multiply(BigDecimal.valueOf(0.2)))
                        .subtract(payConf.getQuaPayFee().multiply(BigDecimal.valueOf(0.2))));
            }
        }
        //查询流程
        UocGetSaleOrderDetailServiceRspPorcBo procInst = setProcInst(uocSaleOrderDo, isSale);
        rspBo.setProcInst(procInst);
        //查询订单主体
        UocOrderDo uocOrderDo = new UocOrderDo();
        uocOrderDo.setOrderId(reqBo.getOrderId());
        uocOrderDo = iUocOrderModel.qryOrderBy(uocOrderDo);
        if (ObjectUtil.isNotNull(uocOrderDo)) {
            rspBo.setOrderNo(uocOrderDo.getOrderNo());
            rspBo.setOrderTime(uocOrderDo.getCreateTime());
            rspBo.setRemark(uocOrderDo.getRemark());
        }
        //协议订单，需要查询协议信息
        if (UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(uocSaleOrderDo.getOrderSource())) {
            UocOrderAgreementQryBo uocOrderAgreementQryBo = new UocOrderAgreementQryBo();
            uocOrderAgreementQryBo.setOrderId(reqBo.getOrderId());
            uocOrderAgreementQryBo.setId(uocSaleOrderDo.getAgrDataId());
            List<UocOrderAgreement> agreementOrderList = iUocSaleOrderModel.getAgreementOrderList(uocOrderAgreementQryBo);
            if (ObjectUtil.isNotEmpty(agreementOrderList)) {
                rspBo.setAgreementInfo(new UocGetSaleOrderDetailServiceRspAgreementInfoBo());
                rspBo.getAgreementInfo().setAgreementCode(agreementOrderList.get(0).getAgreementCode());
                rspBo.getAgreementInfo().setPlaAgreementCode(agreementOrderList.get(0).getPlaAgreementCode());
                rspBo.getAgreementInfo().setEntAgreementCode(agreementOrderList.get(0).getEntAgreementCode());
                rspBo.getAgreementInfo().setProducerName(agreementOrderList.get(0).getProducerName());
                rspBo.getAgreementInfo().setAgreementName(agreementOrderList.get(0).getAgreementName());
                rspBo.getAgreementInfo().setAdjustPrice(agreementOrderList.get(0).getAdjustPrice());
            }
        }
        //查询订单核实信息
        UocChngOrderQryBo uocChngOrderQryBo = new UocChngOrderQryBo();
        uocChngOrderQryBo.setOrderId(reqBo.getOrderId());
//        uocChngOrderQryBo.setBusiType(UocConstant.BUSI_TYPE.ADJUST_PRICE);
        uocChngOrderQryBo.setBusiTypeList(Arrays.asList(UocConstant.BUSI_TYPE.ADJUST_PURCHASE_PRICE,UocConstant.BUSI_TYPE.ADJUST_PRICE));
        List<UocChngOrderDo> listChngOrder = iUocChngOrderModel.getListChngOrder(uocChngOrderQryBo);
        if (ObjectUtil.isNotEmpty(listChngOrder)) {
            rspBo.setOrderVerifyInfo(new UocGetSaleOrderDetailServiceRspVerifyInfoBo());
            rspBo.getOrderVerifyInfo().setAdjustName(listChngOrder.get(0).getCreateOperName());
            rspBo.getOrderVerifyInfo().setAdjustTime(listChngOrder.get(0).getCreateTime());
            rspBo.getOrderVerifyInfo().setRemark(listChngOrder.get(0).getRemark());
        }else {
            UocSaleOrderMapQryBo uocSaleOrderMapQryBo = UocRu.js(reqBo, UocSaleOrderMapQryBo.class);
            String FIELD_CODE = "SKIP_ADJUST_PRICE_MEN";
            uocSaleOrderMapQryBo.setFieldCode(FIELD_CODE);
            List<UocSaleOrderMap> saleOrderExpandList = iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
            if (!CollectionUtils.isEmpty(saleOrderExpandList)){
                rspBo.setOrderVerifyInfo(new UocGetSaleOrderDetailServiceRspVerifyInfoBo());
                rspBo.getOrderVerifyInfo().setAdjustName(saleOrderExpandList.get(0).getFieldValue());
                rspBo.getOrderVerifyInfo().setAdjustTime(saleOrderExpandList.get(0).getCreateTime());
                rspBo.getOrderVerifyInfo().setRemark(saleOrderExpandList.get(0).getRemark());
            }
        }
        //查询收获人地址信息
        UocOrdLogisticsRelaQryBo relaQryBo = new UocOrdLogisticsRelaQryBo();
        relaQryBo.setOrderId(uocSaleOrderDo.getOrderId());
        relaQryBo.setContactId(uocOrderDo.getContactId());
        UocOrdLogisticsRela uocOrdLogisticsRela = iUocOrderModel.qryOrderLogisticsRela(relaQryBo);
        rspBo.setReceiverAddressBo(UocRu.js(uocOrdLogisticsRela, UocGetSaleOrderDetailServiceRspReceiverAddressBo.class));
        //查询发票信息
        UocOrdInvoiceQryBo invoiceQryBo = new UocOrdInvoiceQryBo();
        invoiceQryBo.setOrderId(uocSaleOrderDo.getOrderId());
        UocOrdInvoice uocOrdInvoice = iUocOrderModel.qryOrderInvoice(invoiceQryBo);
        rspBo.setInvoiceBo(UocRu.js(uocOrdInvoice, UocGetSaleOrderDetailServiceRspInvoiceBo.class));
        //查询发票邮寄信息
        UocGetSaleOrderDetailServiceRspReceiverAddressBo invoiceAddressBo = new UocGetSaleOrderDetailServiceRspReceiverAddressBo();
        if (ObjectUtil.isNotEmpty(uocOrdInvoice)) {
            relaQryBo = new UocOrdLogisticsRelaQryBo();
            relaQryBo.setContactId(uocOrdInvoice.getContactId());
            relaQryBo.setOrderId(uocOrdInvoice.getOrderId());
            invoiceAddressBo = UocRu.js(iUocOrderModel.qryOrderLogisticsRela(relaQryBo), UocGetSaleOrderDetailServiceRspReceiverAddressBo.class);
        }
        rspBo.setInvoiceAddressBo(invoiceAddressBo);
        //查询销售单附件
        UocOrderAccessoryQryBo uocOrderAccessoryQryBo = new UocOrderAccessoryQryBo();
        uocOrderAccessoryQryBo.setObjId(uocSaleOrderDo.getOrderId());
        uocOrderAccessoryQryBo.setOrderId(uocSaleOrderDo.getOrderId());
        uocOrderAccessoryQryBo.setObjType(UocDicConstant.OBJ_TYPE.ORDER);
        List<UocOrderAccessory> saleOrderAccessoryList = iUocSaleOrderModel.getSaleOrderAccessoryList(uocOrderAccessoryQryBo).getSaleOrderAccessoryList();
        if (ObjectUtil.isNotEmpty(saleOrderAccessoryList)) {
            List<UocBaseOrderAccessoryDetailBo> accessoryDetailBos = UocRu.jsl(saleOrderAccessoryList, UocBaseOrderAccessoryDetailBo.class);
            Map<Integer, List<UocBaseOrderAccessoryDetailBo>> accessoryDetailMap =
                    accessoryDetailBos.stream().collect(Collectors.groupingBy(UocBaseOrderAccessoryDetailBo::getAttachmentType));
            Iterator<Integer> iterator = accessoryDetailMap.keySet().iterator();
            while (iterator.hasNext()) {
                UocBaseOrderAccessoryTypeDetailBo accessoryTypeDetailBo = new UocBaseOrderAccessoryTypeDetailBo();
                Integer attachmentType = iterator.next();
                accessoryTypeDetailBo.setAttachmentType(attachmentType);
                accessoryTypeDetailBo.setAttchList(accessoryDetailMap.get(attachmentType));
                accessoryDetailBoList.add(accessoryTypeDetailBo);
            }
        }
        //查询销售单主体扩展
        UocSaleOrderMapQryBo uocSaleOrderMapQryBo = UocRu.js(reqBo, UocSaleOrderMapQryBo.class);
        List<UocSaleOrderMap> saleOrderExpandList = iUocSaleOrderModel.getSaleOrderExpandList(uocSaleOrderMapQryBo);
        if (ObjectUtil.isNotEmpty(saleOrderExpandList)) {
            uocBaseExtParallelBoList = UocRu.jsl(saleOrderExpandList, UocBaseExtParallelBo.class);
        }
        //查询发货单
        Map<Long, UocShipOrderItem> shipOrderItemMap = new HashMap<>();
        UocShipOrderQryBo uocShipOrderQryBo = new UocShipOrderQryBo();
        uocShipOrderQryBo.setOrderId(reqBo.getOrderId());
        uocShipOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocShipOrderDo> shipOrderList = iUocShipOrderModel.getListShipOrder(uocShipOrderQryBo);
        if (ObjectUtil.isNotEmpty(shipOrderList)) {
            for (UocShipOrderDo each : shipOrderList) {
                UocGetSaleOrderDetailServiceRspShipOrderInfoBo shipOrderInfoBo = UocRu.js(each, UocGetSaleOrderDetailServiceRspShipOrderInfoBo.class);
                //查询发货单明细
                UocShipOrderItemQryBo uocShipOrderItemQryBo = new UocShipOrderItemQryBo();
                uocShipOrderItemQryBo.setOrderId(each.getOrderId());
                uocShipOrderItemQryBo.setShipOrderId(each.getShipOrderId());
                UocShipOrderDo listShipOrderItem = iUocShipOrderModel.getListShipOrderItem(uocShipOrderItemQryBo);
                if (ObjectUtil.isNotEmpty(listShipOrderItem.getShipOrderItemBoList())) {
                    shipOrderInfoBo.setShipOrderItemInfo(UocRu.jsl(listShipOrderItem.getShipOrderItemBoList(), UocGetSaleOrderDetailServiceRspShipOrderItemBo.class));
                    shipOrderItemMap = listShipOrderItem.getShipOrderItemBoList().stream().collect(Collectors.toMap(UocShipOrderItem::getSaleOrderItemId, o -> o));
                }
                shipOrderInfo.add(shipOrderInfoBo);
            }
        }
        //查询验收单
        UocInspOrderQryBo uocInspOrderQryBo = new UocInspOrderQryBo();
        uocInspOrderQryBo.setOrderId(reqBo.getOrderId());
        uocInspOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocInspOrderDo> inspOrderList = iUocInspOrderModel.getListInspOrder(uocInspOrderQryBo);
        if (ObjectUtil.isNotEmpty(inspOrderList)) {
            for (UocInspOrderDo each : inspOrderList) {
                UocGetSaleOrderDetailServiceRspInspOrderInfoBo inspOrderInfoBo = UocRu.js(each, UocGetSaleOrderDetailServiceRspInspOrderInfoBo.class);
                //查询验收单明细
                UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
                uocInspOrderItemQryBo.setOrderId(each.getOrderId());
                uocInspOrderItemQryBo.setInspOrderId(each.getInspOrderId());
                UocInspOrderDo listInspOrderItem = iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
                if (null != listInspOrderItem && ObjectUtil.isNotEmpty(listInspOrderItem.getUocInspOrderItemList())) {
                    inspOrderInfoBo.setInspOrderItemInfo(UocRu.jsl(listInspOrderItem.getUocInspOrderItemList(), UocGetSaleOrderDetailServiceRspInspOrderItemInfoBo.class));
                }
                inspOrderInfo.add(inspOrderInfoBo);
            }
        }
        //查询支付单
        UocPayOrderQryBo uocPayOrderQryBo = new UocPayOrderQryBo();
        uocPayOrderQryBo.setOrderId(reqBo.getOrderId());
        List<UocPayOrder> listPayOrder = iUocPayOrderModel.getListPayOrder(uocPayOrderQryBo);
        if (ObjectUtil.isNotEmpty(listPayOrder)) {
            rspBo.setPayOrderInfo(UocRu.jsl(listPayOrder, UocGetSaleOrderDetailServiceRspPayOrderBo.class));
        }
        //查询销售单明细
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = UocRu.js(reqBo, UocSaleOrderItemQryBo.class);
        List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        if (ObjectUtil.isNotEmpty(saleOrderItemList)) {
            for (UocSaleOrderItem item : saleOrderItemList) {
                UocGetSaleOrderDetailServiceRspItemBo rspItemBo = UocRu.js(item, UocGetSaleOrderDetailServiceRspItemBo.class);
                //发货数量
                if (ObjectUtil.isNotEmpty(shipOrderItemMap) && shipOrderItemMap.containsKey(item.getSaleOrderItemId())) {
                    rspItemBo.setSendCount(shipOrderItemMap.get(item.getSaleOrderItemId()).getSendCount());
                }
                //验收数量
                if (ObjectUtil.isNotEmpty(shipOrderItemMap) && shipOrderItemMap.containsKey(item.getSaleOrderItemId())) {
                    rspItemBo.setAcceptanceCount(shipOrderItemMap.get(item.getSaleOrderItemId()).getInspCount());
                }
                if (null == rspItemBo.getPurchaseFee()) {
                    //采购金额
                    if (null != rspItemBo.getPurchasePrice() && null != rspItemBo.getPurchaseCount()) {
                        rspItemBo.setPurchaseFee(rspItemBo.getPurchasePrice().multiply(rspItemBo.getPurchaseCount()));
                    }
                }
                if (null == rspItemBo.getSaleFee()) {
                    //销售金额
                    if (null == rspItemBo.getSalePrice()) {
                        rspItemBo.setSalePrice(rspItemBo.getPurchasePrice());
                    }
                    if (null != rspItemBo.getSalePrice() && null != rspItemBo.getPurchaseCount()) {
                        rspItemBo.setSaleFee(rspItemBo.getSalePrice().multiply(rspItemBo.getPurchaseCount()));
                    }
                }
                if (null == rspItemBo.getMarkUpRate()) {
                    rspItemBo.setMarkUpRate(BigDecimal.ZERO.doubleValue());
                }
                //调价后销售价
                rspItemBo.setSalePriceRear(rspItemBo.getSalePrice());
                //调价后采购价
                rspItemBo.setPurchasePriceRear(rspItemBo.getPurchasePrice());
                //调价后加价率
                if (null != rspItemBo.getSalePriceRear() && null != rspItemBo.getPurchasePriceRear()) {
                    rspItemBo.setMarkUpRateRear(rspItemBo.getSalePriceRear().subtract(rspItemBo.getPurchasePriceRear()).abs().divide(rspItemBo.getPurchasePriceRear(), 2).doubleValue());
                }
                //设置铺货单位
                rspItemBo.setDistirbutionId(uocSaleOrderDo.getStakeholder().getProId());
                rspItemBo.setDistirbutionName(uocSaleOrderDo.getStakeholder().getProName());
                //查询销售单明细扩展
                UocSaleItemMapQryBo uocSaleItemMapQryBo = new UocSaleItemMapQryBo();
                uocSaleItemMapQryBo.setSaleOrderItemId(item.getSaleOrderItemId());
                List<UocSaleItemMap> saleOrderItemMapList = iUocSaleOrderModel.getSaleOrderItemMapList(uocSaleItemMapQryBo);
                if (ObjectUtil.isNotEmpty(saleOrderItemMapList)) {
                    List<UocBaseExtParallelBo> uocBaseExtParallelBos = UocRu.jsl(saleOrderItemMapList, UocBaseExtParallelBo.class);
                    rspItemBo.setItemExtParallelBos(uocBaseExtParallelBos);
                    if (ObjectUtil.equal(rspItemBo.getItemType(), UocDicConstant.ITEM_TYPE.COMMODITY_SKU)) {
                        rspItemBo.setCommExtParallelBos(uocBaseExtParallelBos);
                    }
                }
                uocGetSaleOrderDetailServiceRspItemBos.add(rspItemBo);
            }
        }
        //查询外部电商信息
        if (UocDicConstant.ORDER_SOURCE.E_COMMERCE_IMPORT.equals(uocSaleOrderDo.getOrderSource())) {
            UocOrderQueryIndexQryBo queryIndexQryBo = new UocOrderQueryIndexQryBo();
            queryIndexQryBo.setOrderId(reqBo.getOrderId());
            queryIndexQryBo.setObjId(reqBo.getSaleOrderId());
            queryIndexQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            List<UocOrderQueryIndex> uocOrderQueryIndices = iUocOrderModel.qryOrderQueryIndexList(queryIndexQryBo);
            if (ObjectUtil.isNotEmpty(uocOrderQueryIndices)) {
                rspBo.setOutOrderId(uocOrderQueryIndices.get(0).getOutObjId());
            }
        }
        //查询审批单
        List<UocAuditOrderDo> auditOrderList = getAuditOrderList(reqBo.getOrderId(), reqBo.getSaleOrderId(), UocDicConstant.OBJ_TYPE.SALE);
        rspBo.setAuditOrderBoList(UocRu.jsl(auditOrderList, UocSaleOrderAuditBO.class));
        //查询整单审批单
        List<UocAuditOrderDo> wholeAuditOrderList = getAuditOrderList(reqBo.getOrderId(), reqBo.getOrderId(), UocDicConstant.OBJ_TYPE.ORDER);
        rspBo.setWholeAuditOrderBoList(UocRu.jsl(wholeAuditOrderList, UocSaleOrderAuditBO.class));

        rspBo.setAccessoryDetailBoList(accessoryDetailBoList);
        rspBo.setSaleOrderDetailServiceRspExtBoList(uocBaseExtParallelBoList);
        rspBo.setSaleOrderDetailServiceRspItemBoList(uocGetSaleOrderDetailServiceRspItemBos);
        rspBo.setShipOrderInfo(shipOrderInfo);
        rspBo.setInspOrderInfo(inspOrderInfo);
        //字段翻译
        translateProperties(rspBo);

        rspBo.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBo.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
        return rspBo;
    }

    private UocGetSaleOrderDetailServiceRspPorcBo setProcInst(UocSaleOrderDo uocSaleOrderDo, String isSale) {
        UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
        Boolean isSaleFlag = false;
        if (StringUtils.isNotBlank(isSale) && isSale.equals("1")) {
            procInstQryBo.setObjId(uocSaleOrderDo.getSaleOrderId());
            procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            isSaleFlag = true;
        }
        procInstQryBo.setOrderId(uocSaleOrderDo.getOrderId());
        procInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderProcInst> uocOrderProcInsts = iUocOrderModel.qryOrderProcInstList(procInstQryBo);
        UocGetSaleOrderDetailServiceRspPorcBo procInst = new UocGetSaleOrderDetailServiceRspPorcBo();
        if (ObjectUtil.isNotEmpty(uocOrderProcInsts)) {
            List<UocGetSaleOrderDetailServiceRspPorcBo> procBoList = UocRu.jsl(uocOrderProcInsts, UocGetSaleOrderDetailServiceRspPorcBo.class);
            Map<Integer, List<UocGetSaleOrderDetailServiceRspPorcBo>> procBosMap = procBoList.stream().collect(Collectors.groupingBy(UocGetSaleOrderDetailServiceRspPorcBo::getObjType));
            if (ObjectUtil.isNotEmpty(procBosMap.get(UocDicConstant.OBJ_TYPE.SALE))) {
                procInst = procBosMap.get(UocDicConstant.OBJ_TYPE.SALE).get(0);
            }
            List<UocOrderTaskInst> uocOrderTaskInsts = new ArrayList<>();
            if (isSaleFlag) {
                uocOrderTaskInsts.addAll(getOrderTaskInsts(procInst));
            } else {
                procBoList.forEach(bo -> {
                    uocOrderTaskInsts.addAll(getOrderTaskInsts(bo));
                });
            }
            List<UocGetSaleOrderDetailServiceRspTaskBo> taskBoList = new ArrayList<>();
            if (ObjectUtil.isNotEmpty(uocOrderTaskInsts)) {
                taskBoList = UocRu.jsl(uocOrderTaskInsts, UocGetSaleOrderDetailServiceRspTaskBo.class);
                Map<Integer, List<UocGetSaleOrderDetailServiceRspTaskBo>> taskBosMap = taskBoList.stream().collect(Collectors.groupingBy(UocGetSaleOrderDetailServiceRspTaskBo::getObjType));
                taskBoList.forEach(each -> {
                    UocOrderTaskDealQryBo taskDealQryBo = new UocOrderTaskDealQryBo();
                    taskDealQryBo.setTaskInstId(each.getTaskInstId());
                    taskDealQryBo.setObjId(each.getObjId());
                    taskDealQryBo.setObjType(each.getObjType());
                    List<UocOrderTaskDeal> uocOrderTaskDeals = iUocOrderModel.qryOrderTaskDealList(taskDealQryBo);
                    each.setTaskDealBo(ObjectUtil.isNotEmpty(uocOrderTaskDeals) ? UocRu.jsl(uocOrderTaskDeals, UocGetSaleOrderDetailServiceRspTaskDealBo.class) : new ArrayList<>());
                });
                //为了联调，先取第一个环节编码和任务id
                if (ObjectUtil.isNotEmpty(taskBosMap.get(UocDicConstant.OBJ_TYPE.SALE))) {
                    procInst.setProcState(taskBosMap.get(UocDicConstant.OBJ_TYPE.SALE).get(0).getProcState());
                    procInst.setTaskId(taskBosMap.get(UocDicConstant.OBJ_TYPE.SALE).get(0).getTaskInstId());
                }
            }
            procInst.setTaskList(taskBoList);
        }
        return procInst;
    }

    private List<UocOrderTaskInst> getOrderTaskInsts(UocGetSaleOrderDetailServiceRspPorcBo procInst) {
        UocOrderTaskInstQryBo taskInstQryBo = new UocOrderTaskInstQryBo();
        taskInstQryBo.setObjId(procInst.getObjId());
        taskInstQryBo.setObjType(procInst.getObjType());
        taskInstQryBo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.NO_FINISHED);
        List<UocOrderTaskInst> uocOrderTaskInsts = iUocOrderModel.qryOrderTaskInstList(taskInstQryBo);
        return uocOrderTaskInsts;
    }

    /**
     * 查询审批单
     *
     * @return java.util.List<com.tydic.dyc.oc.model.audit.sub.UocAuditOrder>
     */
    private List<UocAuditOrderDo> getAuditOrderList(Long orderId, Long objId, Integer objType) {
        UocApprovalObjQryBo obj = new UocApprovalObjQryBo();
        obj.setOrderId(orderId);
        obj.setObjId(Convert.toStr(objId));
        obj.setObjType(objType);
        List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(obj);
        if (CollectionUtils.isEmpty(uocApprovalObjs)) {
            return new ArrayList<>();
        }
        List<Long> auditOrderIdList = new ArrayList<>();
        uocApprovalObjs.forEach(uocApprovalObj -> auditOrderIdList.add(uocApprovalObj.getAuditOrderId()));
        List<UocAuditOrderDo> uocAuditOrderDoList = new ArrayList<>();
        UocAuditOrderQryBo auditOrderQryBo = new UocAuditOrderQryBo();
        auditOrderQryBo.setOrderId(orderId);
        auditOrderQryBo.setAuditOrderIdList(auditOrderIdList);
        List<UocAuditOrder> uocAuditOrders = iUocAuditOrderModel.qryAuditOrderList(auditOrderQryBo);
        if (ObjectUtil.isNotEmpty(uocAuditOrders)) {
            uocAuditOrders.forEach(uocAuditOrder -> {
                // 查询流程实例
                UocOrderProcInstQryBo procInstQryBo = new UocOrderProcInstQryBo();
                procInstQryBo.setObjId(uocAuditOrder.getAuditOrderId());
                procInstQryBo.setObjType(UocDicConstant.OBJ_TYPE.APPROVE);
                procInstQryBo.setOrderId(orderId);
                List<UocOrderProcInst> uocOrderProcInsts = iUocOrderModel.qryOrderProcInstList(procInstQryBo);
                uocAuditOrder.setProcInstId(uocOrderProcInsts.get(0).getProcInstId());
            });
            uocAuditOrderDoList = UocRu.jsl(uocAuditOrders, UocAuditOrderDo.class);
            Map<Long, List<UocApprovalObj>> approvalObjMap = uocApprovalObjs.stream().collect(Collectors.groupingByConcurrent(UocApprovalObj::getAuditOrderId));
            uocAuditOrderDoList.forEach(each -> {
                each.setApprovalObjs(approvalObjMap.get(each.getAuditOrderId()));
            });
        }
        return uocAuditOrderDoList;
    }

    /**
     * 初始化pCode集合
     */
    private static void initialize() {
        /*销售单主体*/
        //销售单状态字典
        pCodeList.add(UocDicConstant.SALE_ORD_STATE.P_CODE);
        //无协议
        pCodeList.add(UocDicConstant.SALE_ORD_STATE.P_CODE_NOAGREE);
        //协议
        pCodeList.add(UocDicConstant.SALE_ORD_STATE.P_CODE_AGREE);
        //电商
        pCodeList.add(UocDicConstant.SALE_ORD_STATE.P_CODE_ECOM);
        //订单来源字典
        pCodeList.add(UocDicConstant.ORDER_SOURCE.P_CODE);
        //付款方式字典
        pCodeList.add(UocDicConstant.PAY_TYPE.P_CODE);
        //支付状态字典
        pCodeList.add(UocDicConstant.PAY_STATE.P_CODE);
        //竣工标志字典
        pCodeList.add(UocDicConstant.FINISH_FLAG.P_CODE);
        //结算模式字典
        pCodeList.add(UocDicConstant.MODEL_SETTLE.P_CODE);
        //采购类别字典
        pCodeList.add(UocDicConstant.PURCHASE_TYPE.P_CODE);
        //采购模式字典
        pCodeList.add(UocDicConstant.PURCHASE_MODE.P_CODE);
        /*发票信息*/
        //发票类型字典
        pCodeList.add(UocDicConstant.INVOICE_TYPE.P_CODE);
        //发票类别字典
        pCodeList.add(UocDicConstant.INVOICE_CATEGORY.P_CODE);
        /*附件信息*/
        //附件类型字典
        pCodeList.add(UocDicConstant.ATTACHMENT_TYPE.P_CODE);
        //单据类型字典
        pCodeList.add(UocDicConstant.OBJ_TYPE.P_CODE);
        /*销售单明细信息*/
        //明细类型字典
        pCodeList.add(UocDicConstant.ITEM_TYPE.P_CODE);
        /*任务处理信息*/
        //处理对象类型字典
        pCodeList.add(UocDicConstant.DEAL_TYPE.P_CODE);
        //处理分类字典
        pCodeList.add(UocDicConstant.DEAL_CLASS.P_CODE);
        /*协议信息*/
        //协议模式字典
        pCodeList.add(UocDicConstant.AGREEMENT_MODE.P_CODE);
        //调价机制字典
        pCodeList.add(UocDicConstant.ADJUST_PRICE.P_CODE);
        //发货单状态字典
        pCodeList.add(UocStateConstants.ShipOrder.P_CODE);
        //验收单状态字典
        pCodeList.add(UocStateConstants.InspOrder.P_CODE);
    }

    /**
     * 翻译出参数据
     *
     * @param rspBo
     */
    private void translateProperties(UocGetSaleOrderDetailServiceRspBo rspBo) {
        //获取字典集合
        Map<String, Map<String, String>> dictionaryMap = iUocSysDictionaryModel.getDictionaryMap(pCodeList);
        if (ObjectUtil.isNotEmpty(dictionaryMap)) {
            /*销售单主体*/
            //销售单状态翻译
            Integer orderSource = rspBo.getOrderSource();
            String saleOrderState = rspBo.getSaleOrderState();
            UocGetSaleOrderDetailServiceRspPorcBo busiProcInst = rspBo.getProcInst();
            List<String> stateList = new ArrayList<>();
            if (StringUtils.isNotBlank(saleOrderState) && StringUtils.isNotBlank(busiProcInst.getProcState())) {
                if (UocStateConstants.SaleOrder.XS_FH_FHWC.equals(saleOrderState) || UocStateConstants.SaleOrder.XS_FH_FHZ.equals(saleOrderState)) {
                    stateList.add(busiProcInst.getProcState() + LINE + UocStateConstants.SaleOrder.XS_FH_FHZ);
                    stateList.add(busiProcInst.getProcState() + LINE + UocStateConstants.SaleOrder.XS_FH_FHWC);
                } else {
                    stateList.add(busiProcInst.getProcState() + LINE + saleOrderState);
                }
            } else if (StringUtils.isNotBlank(saleOrderState)) {
                stateList.add(saleOrderState);
            } else if (StringUtils.isNotBlank(busiProcInst.getProcState())) {
                stateList.add(busiProcInst.getProcState());
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_NOAGREE)) && UocConstant.SkuSource.SELF.equals(orderSource)) {
                if (ObjectUtil.isNotEmpty(stateList)) {
                    rspBo.setSaleOrderStateStr(dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_NOAGREE).get(stateList.get(0)));
                }
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_ECOM)) && UocConstant.SkuSource.ELC.equals(orderSource)) {
                if (ObjectUtil.isNotEmpty(stateList)) {
                    rspBo.setSaleOrderStateStr(dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_ECOM).get(stateList.get(0)));
                }
            }
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_AGREE)) && UocConstant.SkuSource.AGR.equals(orderSource)) {
                if (ObjectUtil.isNotEmpty(stateList)) {
                    rspBo.setSaleOrderStateStr(dictionaryMap.get(UocDicConstant.SALE_ORD_STATE.P_CODE_AGREE).get(stateList.get(0)));
                }
            }
            //订单来源翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.ORDER_SOURCE.P_CODE)) && ObjectUtil.isNotEmpty(rspBo.getOrderSource())) {
                rspBo.setOrderSourceStr(dictionaryMap.get(UocDicConstant.ORDER_SOURCE.P_CODE).get(rspBo.getOrderSource().toString()));
            }
            //付款方式翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PAY_TYPE.P_CODE))) {
                rspBo.setPayTypeStr(dictionaryMap.get(UocDicConstant.PAY_TYPE.P_CODE).get(rspBo.getPayType()));
            }
            //支付状态翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PAY_STATE.P_CODE)) && ObjectUtil.isNotEmpty(rspBo.getPayState())) {
                rspBo.setPayStateStr(dictionaryMap.get(UocDicConstant.PAY_STATE.P_CODE).get(rspBo.getPayState().toString()));
            }
            //竣工标志翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.FINISH_FLAG.P_CODE)) && ObjectUtil.isNotEmpty(rspBo.getFinishFlag())) {
                rspBo.setFinishFlagStr(dictionaryMap.get(UocDicConstant.FINISH_FLAG.P_CODE).get(rspBo.getFinishFlag().toString()));
            }
            //结算模式翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.MODEL_SETTLE.P_CODE)) && ObjectUtil.isNotEmpty(rspBo.getModelSettle())) {
                rspBo.setModelSettleStr(dictionaryMap.get(UocDicConstant.MODEL_SETTLE.P_CODE).get(rspBo.getModelSettle().toString()));
            }
            //采购类别翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PURCHASE_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(rspBo.getPurchaseType())) {
                rspBo.setPurchaseTypeStr(dictionaryMap.get(UocDicConstant.PURCHASE_TYPE.P_CODE).get(rspBo.getPurchaseType().toString()));
            }
            //采购模式翻译
            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.PURCHASE_MODE.P_CODE)) && ObjectUtil.isNotEmpty(rspBo.getPurchaseMode())) {
                rspBo.setPurchaseModeStr(dictionaryMap.get(UocDicConstant.PURCHASE_MODE.P_CODE).get(rspBo.getPurchaseMode().toString()));
            }
            /*发票信息*/
            if (ObjectUtil.isNotEmpty(rspBo.getInvoiceBo())) {
                UocGetSaleOrderDetailServiceRspInvoiceBo invoiceBo = rspBo.getInvoiceBo();
                //发票类型翻译
                if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.INVOICE_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(invoiceBo.getInvoiceType())) {
                    invoiceBo.setInvoiceTypeStr(dictionaryMap.get(UocDicConstant.INVOICE_TYPE.P_CODE).get(invoiceBo.getInvoiceType().toString()));
                }
                //发票类别翻译
                if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.INVOICE_CATEGORY.P_CODE)) && ObjectUtil.isNotEmpty(invoiceBo.getInvoceCategory())) {
                    invoiceBo.setInvoceCategoryStr(dictionaryMap.get(UocDicConstant.INVOICE_CATEGORY.P_CODE).get(invoiceBo.getInvoceCategory().toString()));
                }
            }
            /*附件信息*/
            if (ObjectUtil.isNotEmpty(rspBo.getAccessoryDetailBoList())) {
                rspBo.getAccessoryDetailBoList().forEach(each -> {
                    //附件类型翻译
                    if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.ATTACHMENT_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(each.getAttachmentType())) {
                        each.setAttachmentTypeStr(dictionaryMap.get(UocDicConstant.ATTACHMENT_TYPE.P_CODE).get(each.getAttachmentType().toString()));
                    }
                    if (ObjectUtil.isNotEmpty(each.getAttchList())) {
                        for (UocBaseOrderAccessoryDetailBo accessoryDetailBo : each.getAttchList()) {
                            //单据类型翻译
                            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(accessoryDetailBo.getObjType())) {
                                accessoryDetailBo.setObjTypeStr(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE).get(accessoryDetailBo.getObjType().toString()));
                            }
                            //附件类型翻译
                            if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.ATTACHMENT_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(accessoryDetailBo.getAttachmentType())) {
                                accessoryDetailBo.setAttachmentTypeStr(dictionaryMap.get(UocDicConstant.ATTACHMENT_TYPE.P_CODE).get(accessoryDetailBo.getAttachmentType().toString()));
                            }
                        }
                    }
                });
            }
            /*销售单明细信息*/
            if (ObjectUtil.isNotEmpty(rspBo.getSaleOrderDetailServiceRspItemBoList())) {
                rspBo.getSaleOrderDetailServiceRspItemBoList().forEach(each -> {
                    //明细类型翻译
                    if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.ITEM_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(each.getItemType())) {
                        each.setItemTypeStr(dictionaryMap.get(UocDicConstant.ITEM_TYPE.P_CODE).get(each.getItemType().toString()));
                    }
                });
            }
            /*协议信息*/
            if (ObjectUtil.isNotNull(rspBo.getAgreementInfo())) {
                UocGetSaleOrderDetailServiceRspAgreementInfoBo agreementInfo = rspBo.getAgreementInfo();
                //协议模式翻译
                if (null != agreementInfo.getAgreementCode()) {
                    agreementInfo.setAgreementCodeStr(dictionaryMap.get(UocDicConstant.AGREEMENT_MODE.P_CODE).get(agreementInfo.getAgreementCode().toString()));
                }
                //调价机制翻译
                if (null != agreementInfo.getAdjustPrice()) {
                    agreementInfo.setAdjustPriceStr(dictionaryMap.get(UocDicConstant.ADJUST_PRICE.P_CODE).get(agreementInfo.getAdjustPrice().toString()));
                }
            }
            /*流程数据*/
            if (ObjectUtil.isNotEmpty(rspBo.getProcInst())) {
                UocGetSaleOrderDetailServiceRspPorcBo procInst = rspBo.getProcInst();
                //流程单据类型翻译
                if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(procInst.getObjType())) {
                    procInst.setObjTypeStr(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE).get(procInst.getObjType().toString()));
                }
                if (ObjectUtil.isNotEmpty(procInst.getTaskList())) {
                    procInst.getTaskList().forEach(each -> {
                        //任务单据类型翻译
                        if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(each.getObjType())) {
                            each.setObjTypeStr(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE).get(each.getObjType().toString()));
                        }
                        if (ObjectUtil.isNotEmpty(each.getTaskDealBo())) {
                            for (UocGetSaleOrderDetailServiceRspTaskDealBo taskDealBo : each.getTaskDealBo()) {
                                //任务处理单据类型翻译
                                if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(taskDealBo.getObjType())) {
                                    taskDealBo.setObjTypeStr(dictionaryMap.get(UocDicConstant.OBJ_TYPE.P_CODE).get(taskDealBo.getObjType().toString()));
                                }
                                //处理对象类型翻译
                                if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.DEAL_TYPE.P_CODE)) && ObjectUtil.isNotEmpty(taskDealBo.getDealType())) {
                                    taskDealBo.setDealTypeStr(dictionaryMap.get(UocDicConstant.DEAL_TYPE.P_CODE).get(taskDealBo.getDealType().toString()));
                                }
                                //处理分类翻译
                                if (ObjectUtil.isNotEmpty(dictionaryMap.get(UocDicConstant.DEAL_CLASS.P_CODE))) {
                                    taskDealBo.setDealClassStr(dictionaryMap.get(UocDicConstant.DEAL_CLASS.P_CODE).get(taskDealBo.getDealClass()));
                                }
                            }
                        }
                    });
                }
            }
            /*发货单信息*/
            if (ObjectUtil.isNotEmpty(rspBo.getShipOrderInfo())) {
                rspBo.getShipOrderInfo().forEach(each -> {
                    //发货单状态翻译
                    each.setShipOrderStateStr(dictionaryMap.get(UocStateConstants.ShipOrder.P_CODE).get(each.getShipOrderState()));
                    if (ObjectUtil.isNotEmpty(each.getShipOrderItemInfo())) {
                        each.getShipOrderItemInfo().forEach(item -> {
                            //明细状态翻译
                            item.setShipItemStateStr(dictionaryMap.get(UocStateConstants.ShipOrder.P_CODE).get(item.getShipItemState()));
                        });
                    }
                });
            }
            /*验收单信息*/
            if (ObjectUtil.isNotEmpty(rspBo.getInspOrderInfo())) {
                rspBo.getInspOrderInfo().forEach(each -> {
                    //发货单状态翻译
                    each.setInspOrderStateStr(dictionaryMap.get(UocStateConstants.InspOrder.P_CODE).get(each.getInspOrderState()));
                    if (ObjectUtil.isNotEmpty(each.getInspOrderItemInfo())) {
                        each.getInspOrderItemInfo().forEach(item -> {
                            //明细状态翻译
                            item.setInspItemStatusStr(dictionaryMap.get(UocStateConstants.ShipOrder.P_CODE).get(item.getInspItemStatus()));
                        });
                    }
                });
            }
        }
    }

    private void validateParam(UocGetSaleOrderDetailServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参不能为空");
        }
        if (reqBo.getSaleOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "销售单ID不能为空");
        }
        if (reqBo.getOrderId() == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "订单ID不能为空");
        }
    }
}