package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderObjQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderObj;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.domainservice.UocCancelSaleOrderConfirmOrRefuseService;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderConfirmOrRefuseReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderConfirmOrRefuseRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocCancelSaleOrderConfirmOrRefuseServiceImpl
 * 说明:销售单取消申请同意/拒绝
 * 时间:2022/2/25 11:24
 * 作者:罗有
 */

@HTServiceImpl
public class UocCancelSaleOrderConfirmOrRefuseServiceImpl implements UocCancelSaleOrderConfirmOrRefuseService {
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;

    private static final Integer OP_FLAG_CONFIRM = 1;
    private static final Integer OP_FLAG_REFUSE = 0;

    @Override
    public UocCancelSaleOrderConfirmOrRefuseRspBo cancelSaleOrderConfirmOrRefuse(UocCancelSaleOrderConfirmOrRefuseReqBo reqBo) {
        //参数校验
        validateArg(reqBo);
        Date now = new Date();
        iUocChngOrderModel.updateChngOrderMain(convertChngOrderDo(now, reqBo));
        iUocSaleOrderModel.modifySaleOrderMain(convertSaleOrderDo(now, reqBo));
        //保存附件
        if (ObjectUtil.isNotEmpty(reqBo.getAccessoryAddBoList())) {
            iUocOrderModel.createOrderAccessory(convertSaleOrderAccessory(now, reqBo));
        }
        //处理扩展属性
        dealMap(now, reqBo);
        return UocRu.success(UocCancelSaleOrderConfirmOrRefuseRspBo.class);
    }

    private UocChngOrderDo convertChngOrderDo(Date now, UocCancelSaleOrderConfirmOrRefuseReqBo reqBo) {
        UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
        uocChngOrderDo.setChngOrderId(reqBo.getChngOrderId());
        uocChngOrderDo.setOrderId(reqBo.getOrderId());
        if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
            uocChngOrderDo.setChngOrderState(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.CHNG_XS_YQR);
        } else {
            uocChngOrderDo.setChngOrderState(UocStateConstants.ChngOrder.SALE_ORDER_CANCEL.CHNG_XS_YJJ);
        }
        uocChngOrderDo.setRejectReason(reqBo.getCancelReplyContent());
        uocChngOrderDo.setRejectTime(now);
        uocChngOrderDo.setUpdateOperName(reqBo.getName());
        uocChngOrderDo.setUpdateTime(now);
        uocChngOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        return uocChngOrderDo;
    }

    private List<UocOrderAccessory> convertSaleOrderAccessory(Date now, UocCancelSaleOrderConfirmOrRefuseReqBo reqBo) {
        List<UocOrderAccessory> uocOrderAccessoryList = UocRu.jsl(reqBo.getAccessoryAddBoList(), UocOrderAccessory.class);
        uocOrderAccessoryList.forEach(each -> {
            each.setId(IdUtil.nextId());
            each.setObjId(reqBo.getChngOrderId());
            each.setObjType(UocDicConstant.OBJ_TYPE.CHNG);
            each.setOrderId(reqBo.getOrderId());
            each.setCreateTime(now);
            each.setCreateOperId(reqBo.getUserId().toString());
        });
        return uocOrderAccessoryList;
    }

    private UocSaleOrderDo convertSaleOrderDo(Date now, UocCancelSaleOrderConfirmOrRefuseReqBo reqBo) {
        UocSaleOrderDo uocSaleOrderDo = UocRu.js(reqBo, UocSaleOrderDo.class);
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
        uocSaleOrderDo.setCancelReplyContent(reqBo.getCancelReplyContent());
        uocSaleOrderDo.setCancelReplyTime(now);
        if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
            uocSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_QX_QX);
        } else {
            UocChngOrderObjQryBo uocChngOrderObjQryBo = new UocChngOrderObjQryBo();
            uocChngOrderObjQryBo.setOrderId(reqBo.getOrderId());
            uocChngOrderObjQryBo.setSaleOrderId(reqBo.getSaleOrderId());
            uocChngOrderObjQryBo.setChngOrderId(reqBo.getChngOrderId());
            List<UocChngOrderObj> chngOrderObj = iUocChngOrderModel.getListChngOrderObj(uocChngOrderObjQryBo);
            if (CollectionUtils.isEmpty(chngOrderObj)) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_CANCEL_APPLY_ERROR, "查询变更单对象为空");
            }
            UocChngOrderObj uocChngOrderObj = chngOrderObj.get(0);
            uocSaleOrderDo.setSaleOrderState(uocChngOrderObj.getOtherChngValue());
        }
        return uocSaleOrderDo;
    }


    /**
     * 扩展属性处理
     */
    private void dealMap(Date now, UocCancelSaleOrderConfirmOrRefuseReqBo reqBo) {
        if (ObjectUtil.isNotEmpty(reqBo.getExtDeleteList())) {
            UocChngOrderDo delChngOrderDo = new UocChngOrderDo();
            List<UocChngOrderMap> extParallelBoList = new ArrayList<>();
            reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                UocChngOrderMap uocChngOrderMap = new UocChngOrderMap();
                uocChngOrderMap.setOrderId(reqBo.getOrderId());
                uocChngOrderMap.setChngOrderId(uocBaseExtParallelDeleteBo.getObjId());
                uocChngOrderMap.setFieldCode(uocBaseExtParallelDeleteBo.getFieldCode());
                uocChngOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                uocChngOrderMap.setUpdateTime(now);
                extParallelBoList.add(uocChngOrderMap);
            });
            delChngOrderDo.setUocChngOrderMapList(extParallelBoList);
            iUocChngOrderModel.updateInvalid(delChngOrderDo);
        }
        if (ObjectUtil.isNotEmpty(reqBo.getExtEditList())) {
            UocChngOrderDo add = new UocChngOrderDo();
            UocChngOrderDo modify = new UocChngOrderDo();
            List<UocChngOrderMap> addList = new ArrayList<>();
            List<UocChngOrderMap> modifyList = new ArrayList<>();
            reqBo.getExtEditList().forEach(uocBaseExtParallelEditBo -> {
                if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelEditBo.getOpFlag())) {
                    UocChngOrderMap addShipOrderMap = new UocChngOrderMap();
                    addShipOrderMap.setChngOrderId(uocBaseExtParallelEditBo.getObjId());
                    addShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                    addShipOrderMap.setFieldName(uocBaseExtParallelEditBo.getFieldName());
                    addShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                    addShipOrderMap.setOrderId(reqBo.getOrderId());
                    addShipOrderMap.setId(IdUtil.nextId());
                    addShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
                    addShipOrderMap.setCreateTime(now);
                    addList.add(addShipOrderMap);
                } else {
                    UocChngOrderMap updateShipOrderMap = new UocChngOrderMap();
                    updateShipOrderMap.setChngOrderId(uocBaseExtParallelEditBo.getObjId());
                    updateShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                    updateShipOrderMap.setOrderId(reqBo.getOrderId());
                    updateShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                    updateShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                    updateShipOrderMap.setUpdateTime(now);
                    modifyList.add(updateShipOrderMap);
                }
            });
            if (!CollectionUtils.isEmpty(addList)) {
                add.setUocChngOrderMapList(addList);
                iUocChngOrderModel.addChngOrderMap(add);
            }
            if (!CollectionUtils.isEmpty(modifyList)) {
                modify.setUocChngOrderMapList(modifyList);
                iUocChngOrderModel.updateBatchValue(modify);
            }
        }
    }

    private void validateArg(UocCancelSaleOrderConfirmOrRefuseReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象不能为空");
        }
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参用户ID不能为空");
        }
        if (null == reqBo.getOpFlag()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参操作类型不能为空");
        }
        if (!OP_FLAG_REFUSE.equals(reqBo.getOpFlag()) && !OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "操作只能是接受或拒绝");
        }
        if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag()) && StringUtils.isBlank(reqBo.getCancelReplyContent())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "拒绝时，回复内容不能为空");
        }
        if (null == reqBo.getOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参订单ID不能为空");
        }
        if (null == reqBo.getChngOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更单ID不能为空");
        }
        if (null == reqBo.getSaleOrderId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参销售单ID不能为空");
        }
        if (ObjectUtil.isNotEmpty(reqBo.getExtDeleteList())) {
            reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性对象ID不能为空");
                }
                if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性编码不能为空");
                }
            });
        }
        if (ObjectUtil.isNotEmpty(reqBo.getExtEditList())) {
            reqBo.getExtEditList().forEach(uocBaseExtParallelDeleteBo -> {
                if (null == uocBaseExtParallelDeleteBo.getOpFlag()) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型不能为空");
                }
                if (!UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag()) && !UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型仅支持新增和修改");
                }
                if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，对象ID不能为空");
                    }
                    if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，属性编码不能为空");
                    }
                }
                if (UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，对象ID不能为空");
                    }
                    if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性编码不能为空");
                    }
                    if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldValue())) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性值不能为空");
                    }
                }
            });
        }
    }
}
