package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.components.es.UocEsSyncManager;
import com.tydic.dyc.oc.components.es.UocEsSyncManagerSaveDataReqBo;
import com.tydic.dyc.oc.config.UocIndexConfig;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.payorder.IUocPayOrderModel;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderPayConfQryBo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderMap;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderPayConf;
import com.tydic.dyc.oc.model.payorder.sub.UocOrderShouldPay;
import com.tydic.dyc.oc.model.sysdictionary.IUocSysDictionaryModel;
import com.tydic.dyc.oc.service.domainservice.UocCancelSaleOrderService;
import com.tydic.dyc.oc.service.saleorder.bo.UocCancelSaleOrderBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocCancelSaleOrderServiceRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 标题:UocCancelSaleOrderServiceImpl
 * 说明:销售单取消
 * 时间:2022/2/25 10:33
 * 作者:田坤林
 */
@Slf4j
@HTServiceImpl
public class UocCancelSaleOrderServiceImpl implements UocCancelSaleOrderService {

    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocPayOrderModel iUocPayOrderModel;
	@Autowired
	private UocIndexConfig uocIndexConfig;
	@Autowired
	private UocEsSyncManager uocEsSyncManager;
	@Autowired
	private IUocSysDictionaryModel iUocSysDictionaryModel;

    @Override
    public UocCancelSaleOrderServiceRspBo cancelSaleOrder(UocCancelSaleOrderServiceReqBo reqBo) {
        UocCancelSaleOrderServiceRspBo rspBo = new UocCancelSaleOrderServiceRspBo();
		List<UocCancelSaleOrderBo> uocCancelSaleOrderBoList = new ArrayList<>();
        //1.参数校验
        validateArg(reqBo);
		//2.收集数据、标记应付单为删除状态
		collectData(reqBo, uocCancelSaleOrderBoList);
		Date now = new Date();
		//3.修改销售单状态
		UocSaleOrderDo uocSaleOrderDo = UocRu.js(reqBo, UocSaleOrderDo.class);
		uocSaleOrderDo.setUpdateTime(now);
		uocSaleOrderDo.setUpdateOperId(reqBo.getUserId().toString());
		uocSaleOrderDo.setCancelTime(now);
		uocSaleOrderDo.setCancelReason(reqBo.getCancelReason());
		uocSaleOrderDo.setCancelOperName(reqBo.getName());
		uocSaleOrderDo.setSaleOrderState(UocStateConstants.SaleOrder.XS_QX_QX);
        iUocSaleOrderModel.modifySaleOrderMain(uocSaleOrderDo);
        //4.保存附件
        if (ObjectUtil.isNotEmpty(reqBo.getAccessoryAddBoList())) {
            iUocOrderModel.createOrderAccessory(convertSaleOrderAccessory(reqBo, now));
        }
		//5.扩展属性处理
		dealMap(reqBo, now);
		rspBo.setUocCancelSaleOrderBoList(uocCancelSaleOrderBoList);
		//6.同步ES
//		syncEs(uocSaleOrderDo);
        return rspBo;
    }

	/**
	 * 收集数据、标记应付单为删除状态
	 * @param reqBo 获取订单id和销售单id
	 * @param uocCancelSaleOrderBoList 待填充的返回数据集合：用于返回给应用层，调用其他中心层
	 */
	private void collectData(UocCancelSaleOrderServiceReqBo reqBo, List<UocCancelSaleOrderBo> uocCancelSaleOrderBoList) {
		//1.查询销售单（三方信息）
		UocSaleOrderQryBo uocSaleOrderQryBo = new UocSaleOrderQryBo();
		uocSaleOrderQryBo.setOrderId(reqBo.getOrderId());
		uocSaleOrderQryBo.setSaleOrderId(reqBo.getSaleOrderId());
		UocSaleOrderDo uocSaleOrderDo = iUocSaleOrderModel.qrySaleOrder(uocSaleOrderQryBo);
		if (uocSaleOrderDo == null) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_ORDER_NULL_ERROR, "销售单查询为空");
		}
		//供应商ID
		Long supId = Long.valueOf(uocSaleOrderDo.getStakeholder().getSupId());
		//采购商ID
		Long creditOrgId = Long.valueOf(uocSaleOrderDo.getStakeholder().getPurCompanyId());
		//销售单ID
		Long saleOrderId = uocSaleOrderDo.getSaleOrderId();
		//销售单号
		String saleOrderNo = uocSaleOrderDo.getSaleOrderNo();
		//2.查询销售单支付配置
		List<UocSaleOrderPayConf> uocSaleOrderPayConfList = qrySaleOrderPayConf(reqBo);
		for (UocSaleOrderPayConf uocSaleOrderPayConf : uocSaleOrderPayConfList) {
			UocCancelSaleOrderBo uocCancelSaleOrderBo = new UocCancelSaleOrderBo();
			//获取付款方式pay_type
			Integer payType = uocSaleOrderPayConf.getPayType();
			//获取使用类型user_type
			Integer userType = uocSaleOrderPayConf.getUserType();
			//3.查询是否生成了应付单
			UocOrderShouldPay where = new UocOrderShouldPay();
			where.setOrderId(reqBo.getOrderId());
			where.setObjectId(reqBo.getSaleOrderId());
			where.setObjectType(UocDicConstant.OBJ_TYPE.SALE);
			List<UocOrderShouldPay> listOrderShouldPay = iUocPayOrderModel.getListOrderShouldPay(where);
			//**设置供应商ID
			uocCancelSaleOrderBo.setSupId(supId);
			//**设置采购商ID
			uocCancelSaleOrderBo.setCreditOrgId(creditOrgId);
			//**设置销售单ID
			uocCancelSaleOrderBo.setSaleOrderId(saleOrderId);
			//**设置销售单号
			uocCancelSaleOrderBo.setSaleOrderNo(saleOrderNo);
			//**设置应付单IDs
			uocCancelSaleOrderBo.setShouldPayIds(listOrderShouldPay.stream().map(UocOrderShouldPay::getShouldPayId).collect(Collectors.toList()));
			//**设置支付类型
			uocCancelSaleOrderBo.setPayType(payType);
			//**设置使用类型
			uocCancelSaleOrderBo.setUserType(userType);
			//**设置扣减金额
			if (UocDicConstant.USE_TYPE.PUR.equals(userType)) {
				uocCancelSaleOrderBo.setAmount(uocSaleOrderDo.getTotalSaleFee());
			} else {
				uocCancelSaleOrderBo.setAmount(uocSaleOrderDo.getTotalPurchaseFee());
			}
			uocCancelSaleOrderBoList.add(uocCancelSaleOrderBo);
			if (UocDicConstant.PAY_TYPE.ADVANCE_PAYMENT_PRORATED.equals(payType) || UocDicConstant.PAY_TYPE.PAY_BY_AGR_CONSTRAINT.equals(payType)) {
				if (!CollectionUtils.isEmpty(listOrderShouldPay)) {
					//2.取消应付单(状态标记为删除)
					for (UocOrderShouldPay uocOrderShouldPay : listOrderShouldPay) {
						UocOrderShouldPay whereInner = new UocOrderShouldPay();
						whereInner.setShouldPayId(uocOrderShouldPay.getShouldPayId());
						UocOrderShouldPay set = new UocOrderShouldPay();
						set.setDelTag(UocDicConstant.DELETE_TAG.DELETED);
						iUocPayOrderModel.modifyOrderShouldPayMain(set, whereInner);
					}
				}
			}
		}
	}

	/**
     * 查询销售单支付配置
     */
    private List<UocSaleOrderPayConf> qrySaleOrderPayConf(UocCancelSaleOrderServiceReqBo reqBo) {
        UocSaleOrderPayConfQryBo uocSaleOrderPayConfQryBo = new UocSaleOrderPayConfQryBo();
        uocSaleOrderPayConfQryBo.setOrderId(reqBo.getOrderId());
        uocSaleOrderPayConfQryBo.setSaleOrderId(reqBo.getSaleOrderId());
        List<UocSaleOrderPayConf> saleOrderPayConfList = iUocSaleOrderModel.getSaleOrderPayConfList(uocSaleOrderPayConfQryBo);
        if (CollectionUtils.isEmpty(saleOrderPayConfList)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_SALE_ORDER_PAY_CONF_NULL_ERROR, "销售单支付配置查询为空");
        }
        return saleOrderPayConfList;
    }

    private List<UocOrderAccessory> convertSaleOrderAccessory(UocCancelSaleOrderServiceReqBo reqBo, Date now) {
        List<UocOrderAccessory> uocOrderAccessoryList = UocRu.jsl(reqBo.getAccessoryAddBoList(), UocOrderAccessory.class);
        uocOrderAccessoryList.forEach(each -> {
            each.setId(IdUtil.nextId());
            each.setObjId(reqBo.getSaleOrderId());
            each.setObjType(UocDicConstant.OBJ_TYPE.SALE);
            each.setOrderId(reqBo.getOrderId());
            each.setCreateTime(now);
            each.setCreateOperId(reqBo.getUserId().toString());
        });
        return uocOrderAccessoryList;
    }

	/**
	 * 扩展属性处理
	 */
	private void dealMap(UocCancelSaleOrderServiceReqBo reqBo, Date now) {
		if (!CollectionUtils.isEmpty(reqBo.getExtDeleteList())) {
			UocSaleOrderDo delSaleOrderDo = new UocSaleOrderDo();
			List<UocSaleOrderMap> extParallelBoList = new ArrayList<>();
			reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
				UocSaleOrderMap uocSaleOrderMap = new UocSaleOrderMap();
				uocSaleOrderMap.setOrderId(reqBo.getOrderId());
				uocSaleOrderMap.setSaleOrderId(uocBaseExtParallelDeleteBo.getObjId());
				uocSaleOrderMap.setFieldCode(uocBaseExtParallelDeleteBo.getFieldCode());
				uocSaleOrderMap.setUpdateOperId(reqBo.getUserId().toString());
				uocSaleOrderMap.setUpdateTime(now);
				extParallelBoList.add(uocSaleOrderMap);
			});
			delSaleOrderDo.setSaleOrderMapList(extParallelBoList);
			iUocSaleOrderModel.updateInvalid(delSaleOrderDo);
		}
		if (!CollectionUtils.isEmpty(reqBo.getExtEditList())) {
			UocSaleOrderDo add = new UocSaleOrderDo();
			UocSaleOrderDo modify = new UocSaleOrderDo();
			List<UocSaleOrderMap> addList = new ArrayList<>();
			List<UocSaleOrderMap> modifyList = new ArrayList<>();
			reqBo.getExtEditList().forEach(uocBaseExtParallelEditBo -> {
				if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelEditBo.getOpFlag())) {
					UocSaleOrderMap addShipOrderMap = new UocSaleOrderMap();
					addShipOrderMap.setSaleOrderId(uocBaseExtParallelEditBo.getObjId());
					addShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
					addShipOrderMap.setFieldName(uocBaseExtParallelEditBo.getFieldName());
					addShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
					addShipOrderMap.setOrderId(reqBo.getOrderId());
					addShipOrderMap.setId(IdUtil.nextId());
					addShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
					addShipOrderMap.setCreateTime(now);
					addList.add(addShipOrderMap);
				} else {
					UocSaleOrderMap updateShipOrderMap = new UocSaleOrderMap();
					updateShipOrderMap.setSaleOrderId(uocBaseExtParallelEditBo.getObjId());
					updateShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
					updateShipOrderMap.setOrderId(reqBo.getOrderId());
					updateShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
					updateShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
					updateShipOrderMap.setUpdateTime(now);
					modifyList.add(updateShipOrderMap);
				}
			});
			if (!CollectionUtils.isEmpty(addList)) {
				add.setSaleOrderMapList(addList);
				iUocSaleOrderModel.addSaleOrderMap(add);
			}
			if (!CollectionUtils.isEmpty(modifyList)) {
				modify.setSaleOrderMapList(modifyList);
				iUocSaleOrderModel.updateBatchValue(modify);
			}
		}
	}

	private void validateArg(UocCancelSaleOrderServiceReqBo reqBo) {
		if (reqBo == null) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocCancelSaleOrderServiceReqBo]不能为空");
		}
		if (ObjectUtil.isEmpty(reqBo.getSaleOrderId())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[销售单id]不能为空");
		}
		if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[订单id]不能为空");
		}
		if (ObjectUtil.isEmpty(reqBo.getCancelReason())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[取消原因]不能为空");
		}
		if (ObjectUtil.isEmpty(reqBo.getUserId())) {
			throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象属性[用户ID]不能为空");
		}

		if (!CollectionUtils.isEmpty(reqBo.getExtDeleteList())) {
			reqBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
				if (null == uocBaseExtParallelDeleteBo.getObjId()) {
					throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性对象ID不能为空");
				}
				if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
					throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性编码不能为空");
				}
			});
		}
		if (!CollectionUtils.isEmpty(reqBo.getExtEditList())) {
			reqBo.getExtEditList().forEach(uocBaseExtParallelDeleteBo -> {
				if (null == uocBaseExtParallelDeleteBo.getOpFlag()) {
					throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型不能为空");
				}
				if (!UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag()) && !UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
					throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型仅支持新增和修改");
				}
				if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
					if (null == uocBaseExtParallelDeleteBo.getObjId()) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，对象ID不能为空");
					}
					if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，属性编码不能为空");
					}
				}
				if (UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
					if (null == uocBaseExtParallelDeleteBo.getObjId()) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，对象ID不能为空");
					}
					if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性编码不能为空");
					}
					if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldValue())) {
						throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性值不能为空");
					}
				}
			});
		}
	}

	/**
	 * 同步ES
	 */
	private void syncEs(UocSaleOrderDo uocSaleOrderDo) {
		UocEsSyncManagerSaveDataReqBo uocEsSyncManagerSaveDataReqBo = new UocEsSyncManagerSaveDataReqBo();
		//objId
		uocEsSyncManagerSaveDataReqBo.setObjId(uocSaleOrderDo.getSaleOrderId());
		//indexName
		uocEsSyncManagerSaveDataReqBo.setIndexName(uocIndexConfig.getSaleOrderIndex());
		JSONObject jsonObj = new JSONObject();
		//更新时间
//		jsonObj.put(UocConstant.ES_MAIN_OTHER.UPDATE_TIME,new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(uocSaleOrderDo.getUpdateTime()));
		jsonObj.put(UocConstant.ES_MAIN_OTHER.UPDATE_TIME,uocSaleOrderDo.getUpdateTime().getTime());
		//取消时间
//		jsonObj.put(UocConstant.ES_MAIN_OTHER.CANCEL_TIME,new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(uocSaleOrderDo.getCancelTime()));
		jsonObj.put(UocConstant.ES_MAIN_OTHER.CANCEL_TIME,uocSaleOrderDo.getCancelTime().getTime());
		//更新工号
		jsonObj.put(UocConstant.ES_MAIN_OTHER.UPDATE_OPER_ID,uocSaleOrderDo.getUpdateOperId());
		//撤单原因
		jsonObj.put(UocConstant.ES_MAIN_OTHER.CANCEL_REASON,uocSaleOrderDo.getCancelReason());
		//订单状态
		jsonObj.put(UocConstant.ES_MAIN_OTHER.SALE_ORD_STATE,uocSaleOrderDo.getSaleOrderState());
		//订单状态Str
		Map<String, String> saleOrdStateMap = getDic().get(UocDicConstant.SALE_ORD_STATE.P_CODE);
		jsonObj.put(UocConstant.ES_MAIN_OTHER.SALE_ORD_STATE_STR,saleOrdStateMap.get(Convert.toStr(uocSaleOrderDo.getSaleOrderState())));

		//jsonObj
		uocEsSyncManagerSaveDataReqBo.setJsonObj(jsonObj);
		log.info("uocEsSyncManagerSaveDataReqBo为{}",JSONObject.toJSONString(uocEsSyncManagerSaveDataReqBo));
		uocEsSyncManager.updateData(uocEsSyncManagerSaveDataReqBo);
	}

	private Map<String, Map<String, String>> getDic() {
		List<String> pCodes = new ArrayList<>();
		pCodes.add(UocDicConstant.SALE_ORD_STATE.P_CODE);
		return iUocSysDictionaryModel.getDictionaryMap(pCodes);
	}

}
