package com.tydic.dyc.oc.service.domainservice;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.constants.UocStateConstants;
import com.tydic.dyc.oc.model.chngorder.IUocChngOrderModel;
import com.tydic.dyc.oc.model.chngorder.UocChngOrderDo;
import com.tydic.dyc.oc.model.chngorder.qrybo.UocChngOrderItemObjQryBo;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderItemObj;
import com.tydic.dyc.oc.model.chngorder.sub.UocChngOrderMap;
import com.tydic.dyc.oc.model.common.IUocCommonModel;
import com.tydic.dyc.oc.model.common.UocCommonDo;
import com.tydic.dyc.oc.model.insporder.IUocInspOrderModel;
import com.tydic.dyc.oc.model.insporder.UocInspOrderDo;
import com.tydic.dyc.oc.model.insporder.qrybo.UocInspOrderItemQryBo;
import com.tydic.dyc.oc.model.insporder.sub.UocInspOrderItem;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.model.saleorder.qrybo.UocSaleOrderItemQryBo;
import com.tydic.dyc.oc.model.saleorder.sub.UocSaleOrderItem;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseHRReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseHRReqItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocChngOrderConfirmOrRefuseHRRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 标题：类名称:UocChngOrderConfirmOrRefuseHRServiceImpl
 * 说明：描述一下类的作用TODO
 * 时间：2022/5/23 14:59
 * 作者 @author 尹栋梁
 */
@HTServiceImpl
public class UocChngOrderConfirmOrRefuseHRServiceImpl implements UocChngOrderConfirmOrRefuseHRService{
    @Autowired
    private IUocChngOrderModel iUocChngOrderModel;
    @Autowired
    private IUocInspOrderModel iUocInspOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;


    private static final Integer OP_FLAG_CONFIRM = 1;

    private static final Integer OP_FLAG_REFUSE = 0;
    @Autowired
    private IUocCommonModel iUocCommonModel;


    @Override
    public UocChngOrderConfirmOrRefuseHRRspBo dealConfirmOrRefuse(UocChngOrderConfirmOrRefuseHRReqBo reqBo) {
        UocChngOrderConfirmOrRefuseHRRspBo rsp = UocRu.success(UocChngOrderConfirmOrRefuseHRRspBo.class);

        validateArg(reqBo);
        String operId = reqBo.getUserId().toString();
        Date now = new Date();
        //获取变更对象信息
        List<UocChngOrderItemObj> uocChngOrderItemObjList = getListChngOrderItemObj(reqBo);
        //数量变更
        iUocChngOrderModel.modifyBatchChngOrderState(convertChngOrderDo(reqBo, now, operId));
        if (OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())) {
            confirm(reqBo, operId, now, uocChngOrderItemObjList);
        }
        if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            refuse(reqBo, operId, now, uocChngOrderItemObjList);
        }
        reqBo.getChngOrderList().forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
            // 提交任务
            UocCommonDo uocCommonDo = new UocCommonDo();
            List<UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo> taskBos = new ArrayList<>();
            UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo taskBo = new UocCreateSaleProcInsUpdateStatusDomainServiceReqTaskBo();
            taskBo.setTaskId(uocChngOrderConfirmOrRefuseReqItemBo.getTaskId());
            taskBos.add(taskBo);
            uocCommonDo.setCompleteTaskInfos(taskBos);
            uocCommonDo.setUserId(11111L);
            uocCommonDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
            iUocCommonModel.dealTask(uocCommonDo);
        });
        dealMap(reqBo, now);
        //封装出参对象 (查询销售单明细 ，验收单明细)
        buildSyncRsp(reqBo,rsp,uocChngOrderItemObjList);
        return rsp;
    }

    private void buildSyncRsp(UocChngOrderConfirmOrRefuseHRReqBo reqBo, UocChngOrderConfirmOrRefuseHRRspBo rspBo, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        List<Long> saleOrderItemIds = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getSaleOrderItemId).collect(Collectors.toList());
        List<Long> inspOrderItemIds = uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getInspOrderItemId).collect(Collectors.toList());
        UocSaleOrderItemQryBo uocSaleOrderItemQryBo = new UocSaleOrderItemQryBo();
        uocSaleOrderItemQryBo.setSaleOrderItemIdList(saleOrderItemIds);
        List<UocSaleOrderItem> saleOrderItemList = iUocSaleOrderModel.getSaleOrderItemList(uocSaleOrderItemQryBo);
        rspBo.getSaleOrderIdList().addAll(saleOrderItemList.stream().map(x -> x.getSaleOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList()));

        UocInspOrderItemQryBo uocInspOrderItemQryBo = new UocInspOrderItemQryBo();
        uocInspOrderItemQryBo.setInspOrderItemIdList(inspOrderItemIds);
        UocInspOrderDo uocInspOrderDo = iUocInspOrderModel.getListInspOrderItem(uocInspOrderItemQryBo);
        rspBo.getInspOrderIdList().addAll(uocInspOrderDo.getUocInspOrderItemList().stream().map(x -> x.getInspOrderId() + "-" + x.getOrderId()).distinct().collect(Collectors.toList()));

        reqBo.getChngOrderList().forEach(x->{
            rspBo.getChngOrderIdList().add(x.getChngOrderId() + "-" + x.getOrderId());
        });
    }


    private void refuse(UocChngOrderConfirmOrRefuseHRReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        iUocInspOrderModel.modifyItemChngCountRefuse(convertInspOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
        iUocSaleOrderModel.modifyItemChngCountRefuse(convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
    }

    private void confirm(UocChngOrderConfirmOrRefuseHRReqBo reqBo, String operId, Date now, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        iUocInspOrderModel.modifyItemChngCountConfirm(convertInspOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
        iUocSaleOrderModel.modifyItemChngCountConfirm(convertSaleOrderDo(reqBo, now, operId, uocChngOrderItemObjList));
    }


    /**
     * 查询执行单信息
     */
    private UocSaleOrderDo convertSaleOrderDo(UocChngOrderConfirmOrRefuseHRReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
        uocSaleOrderDo.setUpdateOperId(operId);
        uocSaleOrderDo.setUpdateTime(now);
        uocSaleOrderDo.setOrderIdList(reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseHRReqItemBo::getOrderId).collect(Collectors.toList()));
        uocSaleOrderDo.setSaleOrderItemsIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getSaleOrderItemId).collect(Collectors.toList()));
        return uocSaleOrderDo;
    }

    /**
     * 查询发货单信息信息
     */
    private UocInspOrderDo convertInspOrderDo(UocChngOrderConfirmOrRefuseHRReqBo reqBo, Date now, String operId, List<UocChngOrderItemObj> uocChngOrderItemObjList) {
        List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseHRReqItemBo::getOrderId).collect(Collectors.toList());
        UocInspOrderDo uocInspOrderDo = new UocInspOrderDo();
        uocInspOrderDo.setInspOrderItemsIdList(uocChngOrderItemObjList.stream().map(UocChngOrderItemObj::getInspOrderItemId).collect(Collectors.toList()));
        uocInspOrderDo.setOrderIdList(orderIdList);
        uocInspOrderDo.setUpdateTime(now);
        uocInspOrderDo.setUpdateOperId(operId);
        return uocInspOrderDo;
    }

    /**
     * 组装变更单信息
     */
    private List<UocChngOrderDo> convertChngOrderDo(UocChngOrderConfirmOrRefuseHRReqBo reqBo, Date now, String operId) {
        String state = getState(reqBo);
        return reqBo.getChngOrderList().stream().map(uocChngOrderConfirmOrRefuseReqItemBo -> {
            UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
            uocChngOrderDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
            uocChngOrderDo.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
            uocChngOrderDo.setChngOrderState(state);
            uocChngOrderDo.setUpdateTime(now);
            uocChngOrderDo.setUpdateOperId(operId);
            uocChngOrderDo.setUpdateOperName(reqBo.getName());
            uocChngOrderDo.setRejectReason(reqBo.getRejectRemark());
            return uocChngOrderDo;
        }).collect(Collectors.toList());
    }

    /**
     * 获取对应状态
     * @param reqBo
     */
    private String getState(UocChngOrderConfirmOrRefuseHRReqBo reqBo) {
        if (OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            return UocStateConstants.ChngOrder.NUM.CHNG_CHNG_JJ;
        }
        return UocStateConstants.ChngOrder.NUM.CHNG_CHNG_QR;
    }

    /**
     * 查询变更对象明细信息
     * @param reqBo
     */
    private List<UocChngOrderItemObj> getListChngOrderItemObj(UocChngOrderConfirmOrRefuseHRReqBo reqBo){
        List<Long> orderIdList = reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseHRReqItemBo::getOrderId).collect(Collectors.toList());
        UocChngOrderItemObjQryBo uocChngOrderItemObjQryBo = new UocChngOrderItemObjQryBo();
        uocChngOrderItemObjQryBo.setChngOrderIdList(reqBo.getChngOrderList().stream().map(UocChngOrderConfirmOrRefuseHRReqItemBo::getChngOrderId).collect(Collectors.toList()));
        uocChngOrderItemObjQryBo.setOrderIdList(orderIdList);
        List<UocChngOrderItemObj> uocChngOrderItemObjList = iUocChngOrderModel.getListChngOrderItemObj(uocChngOrderItemObjQryBo);
        if (CollectionUtils.isEmpty(uocChngOrderItemObjList)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_CHNG_ORDER_CONFIRM_OR_REFUSE_ERROR, "查询变更明细对象为空");
        }
        return uocChngOrderItemObjList;
    }


    /**
     * 扩展属性处理
     */
    private void dealMap(UocChngOrderConfirmOrRefuseHRReqBo reqBo, Date now) {
        List<UocChngOrderConfirmOrRefuseHRReqItemBo> chngOrderList = reqBo.getChngOrderList();
        chngOrderList.forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
            if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList())) {
                UocChngOrderDo delChngOrderDo = new UocChngOrderDo();
                List<UocChngOrderMap> extParallelBoList = new ArrayList<>();
                uocChngOrderConfirmOrRefuseReqItemBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                    UocChngOrderMap uocChngOrderMap = new UocChngOrderMap();
                    uocChngOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
                    uocChngOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
                    uocChngOrderMap.setFieldCode(uocBaseExtParallelDeleteBo.getFieldCode());
                    uocChngOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                    uocChngOrderMap.setUpdateTime(now);
                    extParallelBoList.add(uocChngOrderMap);
                });
                delChngOrderDo.setUocChngOrderMapList(extParallelBoList);
                iUocChngOrderModel.updateInvalid(delChngOrderDo);
            }
            if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList())) {
                UocChngOrderDo add = new UocChngOrderDo();
                UocChngOrderDo modify = new UocChngOrderDo();
                List<UocChngOrderMap> addList = new ArrayList<>();
                List<UocChngOrderMap> modifyList = new ArrayList<>();
                uocChngOrderConfirmOrRefuseReqItemBo.getExtEditList().forEach(uocBaseExtParallelEditBo -> {
                    if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelEditBo.getOpFlag())) {
                        UocChngOrderMap addShipOrderMap = new UocChngOrderMap();
                        addShipOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
                        addShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                        addShipOrderMap.setFieldName(uocBaseExtParallelEditBo.getFieldName());
                        addShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                        addShipOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
                        addShipOrderMap.setId(IdUtil.nextId());
                        addShipOrderMap.setCreateOperId(reqBo.getUserId().toString());
                        addShipOrderMap.setCreateTime(now);
                        addList.add(addShipOrderMap);
                    } else {
                        UocChngOrderMap updateShipOrderMap = new UocChngOrderMap();
                        updateShipOrderMap.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
                        updateShipOrderMap.setFieldCode(uocBaseExtParallelEditBo.getFieldCode());
                        updateShipOrderMap.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
                        updateShipOrderMap.setFieldValue(uocBaseExtParallelEditBo.getFieldValue());
                        updateShipOrderMap.setUpdateOperId(reqBo.getUserId().toString());
                        updateShipOrderMap.setUpdateTime(now);
                        modifyList.add(updateShipOrderMap);
                    }
                });
                if (!CollectionUtils.isEmpty(addList)) {
                    add.setUocChngOrderMapList(addList);
                    iUocChngOrderModel.addChngOrderMap(add);
                }
                if (!CollectionUtils.isEmpty(modifyList)) {
                    modify.setUocChngOrderMapList(modifyList);
                    iUocChngOrderModel.updateBatchValue(modify);
                }
            }
            UocChngOrderDo uocChngOrderDo = new UocChngOrderDo();
            uocChngOrderDo.setChngOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId());
            uocChngOrderDo.setOrderId(uocChngOrderConfirmOrRefuseReqItemBo.getOrderId());
            uocChngOrderDo.setChngOrderState(OP_FLAG_CONFIRM.equals(reqBo.getOpFlag())?UocStateConstants.ChngOrder.NUM.CHNG_CHNG_QR:UocStateConstants.ChngOrder.NUM.CHNG_CHNG_JJ);
            uocChngOrderDo.setUpdateTime(now);
            uocChngOrderDo.setUpdateOperId(reqBo.getUserId().toString());
            iUocChngOrderModel.updateChngOrderMain(uocChngOrderDo);
        });
    }

    private void validateArg(UocChngOrderConfirmOrRefuseHRReqBo reqBo) {
        if (null == reqBo) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象为空");
        }
        if (!OP_FLAG_CONFIRM.equals(reqBo.getOpFlag()) && !OP_FLAG_REFUSE.equals(reqBo.getOpFlag())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参操作只支持确认或拒绝为空");
        }
        if (CollectionUtils.isEmpty(reqBo.getChngOrderList())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更信息列表不能为空");
        }
        reqBo.getChngOrderList().forEach(uocChngOrderConfirmOrRefuseReqItemBo -> {
            if (null == uocChngOrderConfirmOrRefuseReqItemBo.getOrderId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更信息的订单ID不能为空");
            }
            if (null == uocChngOrderConfirmOrRefuseReqItemBo.getChngOrderId()) {
                throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参变更信息的变更单ID不能为空");
            }
        });
        if (null == reqBo.getUserId()) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参用户ID不能为空");
        }
        List<UocChngOrderConfirmOrRefuseHRReqItemBo> chngOrderList = reqBo.getChngOrderList();
        chngOrderList.forEach(uocChngOrderConfirmOrRefuseHRReqItemBo -> {

            if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseHRReqItemBo.getExtDeleteList())) {
                uocChngOrderConfirmOrRefuseHRReqItemBo.getExtDeleteList().forEach(uocBaseExtParallelDeleteBo -> {
                    if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性对象ID不能为空");
                    }
                    if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "要删除的扩展属性编码不能为空");
                    }
                });
            }
            if (!CollectionUtils.isEmpty(uocChngOrderConfirmOrRefuseHRReqItemBo.getExtEditList())) {
                uocChngOrderConfirmOrRefuseHRReqItemBo.getExtEditList().forEach(uocBaseExtParallelDeleteBo -> {
                    if (null == uocBaseExtParallelDeleteBo.getOpFlag()) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型不能为空");
                    }
                    if (!UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag()) && !UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                        throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做编辑操作时，操作类型仅支持新增和修改");
                    }
                    if (UocConstant.MAP_OP_FLAG.ADD.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                        if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，对象ID不能为空");
                        }
                        if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做新增操作时，属性编码不能为空");
                        }
                    }
                    if (UocConstant.MAP_OP_FLAG.UPDATE.equals(uocBaseExtParallelDeleteBo.getOpFlag())) {
                        if (null == uocBaseExtParallelDeleteBo.getObjId()) {
                            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，对象ID不能为空");
                        }
                        if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldCode())) {
                            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性编码不能为空");
                        }
                        if (StringUtils.isBlank(uocBaseExtParallelDeleteBo.getFieldValue())) {
                            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "对扩展属性做修改操作时，属性值不能为空");
                        }
                    }
                });
            }
        });
    }
}
