package com.tydic.dyc.oc.service.order;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.aforder.IUocAfOrderModel;
import com.tydic.dyc.oc.model.aforder.qrybo.UocAfOrderQryBo;
import com.tydic.dyc.oc.model.aforder.sub.UocAfOrder;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocDMsgPoolQryBo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.service.order.bo.UocCreatMsgPoolServiceReqBO;
import com.tydic.dyc.oc.service.order.bo.UocCreatMsgPoolServiceRspBO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

@Slf4j
@HTServiceImpl
public class UocCreatMsgPoolServiceImpl implements UocCreatMsgPoolService{
    
    @Autowired
    private IUocOrderModel iUocOrderModel;

    @Autowired
    private IUocAfOrderModel uocAfOrderModel;
    
    @Override
    public UocCreatMsgPoolServiceRspBO creatMsg(UocCreatMsgPoolServiceReqBO reqBO) {
        UocCreatMsgPoolServiceRspBO rspBO = new UocCreatMsgPoolServiceRspBO();
        rspBO.setRespCode(UocRspConstants.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(UocRspConstants.RSP_DESC_SUCCESS);
    
        if(reqBO == null){
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_METHOD_ARG_EMPTY_ERROR, "方法入参对象不能为空");
        }
        if (ObjectUtil.isNotEmpty(reqBO.getMsgType()) && (102 == reqBO.getMsgType())) {
            UocAfOrderQryBo uocAfOrderQryBo = new UocAfOrderQryBo();
            uocAfOrderQryBo.setExtAfId(reqBO.getServiceid());
            List<UocAfOrder> afOrderList = uocAfOrderModel.getAfOrderList(uocAfOrderQryBo);
            if (CollectionUtil.isNotEmpty(afOrderList)) {
                UocOrderQueryIndexQryBo uocOrderQueryIndexQryBo = new UocOrderQueryIndexQryBo();
                UocAfOrder uocAfOrder = afOrderList.get(0);
                Long saleOrderId = uocAfOrder.getSaleOrderId();
                uocOrderQueryIndexQryBo.setOrderId(uocAfOrder.getOrderId());
                uocOrderQueryIndexQryBo.setObjId(saleOrderId);
                uocOrderQueryIndexQryBo.setObjType(2);
                List<UocOrderQueryIndex> uocOrderQueryIndexList = iUocOrderModel.qryOrderQueryIndexList(uocOrderQueryIndexQryBo);
                if (ObjectUtil.isNotEmpty(uocOrderQueryIndexList)) {
                    String outObjId = uocOrderQueryIndexList.get(0).getOutObjId();
                    reqBO.setOutOrderId(outObjId);
                }
            }
        }
        reqBO.setId(IdUtil.nextId());
        iUocOrderModel.insertMsgPool(UocRu.js(reqBO, UocDMsgPoolQryBo.class));
        return rspBO;
    }
}
