package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.qrybo.UocConfAuditQryBo;
import com.tydic.dyc.oc.model.order.sub.UocConfAudit;
import com.tydic.dyc.oc.service.order.bo.UocQryAuditConfListBo;
import com.tydic.dyc.oc.service.order.bo.UocQryAuditConfListReqBo;
import com.tydic.dyc.oc.service.order.bo.UocQryAuditConfListRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题:UocQryAuditConfListServiceImpl
 * 说明:审批配置查询列表
 * 时间:2022-05-20 10:16:24
 * 作者:luoyou
 */

@HTServiceImpl
public class UocQryAuditConfListServiceImpl implements UocQryAuditConfListService {
	@Autowired
	private IUocOrderModel iUocOrderModel;

	@Override
	public UocQryAuditConfListRspBo qryAuditConfList(UocQryAuditConfListReqBo reqBo) {
		List<UocConfAudit> uocConfAuditList = iUocOrderModel.qryListAuditConf(convertDo(reqBo));
		UocQryAuditConfListRspBo uocQryAuditConfListRspBo = UocRu.success(UocQryAuditConfListRspBo.class);
		uocQryAuditConfListRspBo.setRows(UocRu.jsl(uocConfAuditList, UocQryAuditConfListBo.class));

		// 翻译
		for (UocQryAuditConfListBo row : uocQryAuditConfListRspBo.getRows()) {
			if (UocConstant.SYS_ATTR.SYSTEM.equals(row.getSysAttr())){
				row.setSysAttrStr("系统");
			}
			if (UocConstant.SYS_ATTR.CUSTOMIZE.equals(row.getSysAttr())){
				row.setSysAttrStr("自定义");
			}
		}
		return uocQryAuditConfListRspBo;
	}

	private UocConfAuditQryBo convertDo(UocQryAuditConfListReqBo reqBo) {
		UocConfAuditQryBo uocConfAuditQryBo = UocRu.js(reqBo, UocConfAuditQryBo.class);
		uocConfAuditQryBo.setOrgId(reqBo.getOrgIdWeb());
		uocConfAuditQryBo.setOrgName(reqBo.getOrgNameWeb());
		uocConfAuditQryBo.setOrgType(reqBo.getOrgTypeWeb());
		return uocConfAuditQryBo;
	}
}
