/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.model.cmporder.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.model.cmporder.IUocCmpOrderModel;
import com.tydic.dyc.oc.model.cmporder.UocCmpOrderDo;
import com.tydic.dyc.oc.model.cmporder.qrybo.UocCmpOrderQryBo;
import com.tydic.dyc.oc.model.cmporder.sub.UocCmpItemMap;
import com.tydic.dyc.oc.model.cmporder.sub.UocCmpOrderItem;
import com.tydic.dyc.oc.model.cmporder.sub.UocCmpOrderMap;
import com.tydic.dyc.oc.repository.UocCmpOrderRepository;
import com.tydic.dyc.oc.utils.IdUtil;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocCmpOrderModelImpl
implements IUocCmpOrderModel {
    @Autowired
    private UocCmpOrderRepository uocCmpOrderRepository;

    @Override
    public UocCmpOrderDo createCmpOrder(UocCmpOrderDo uocCmpOrderDo) {
        this.valCreateCmpOrderDo(uocCmpOrderDo);
        long cmpId = IdUtil.nextId();
        String no = this.biuldNo("", "BJ-");
        uocCmpOrderDo.setCmpOrderId(cmpId);
        uocCmpOrderDo.setCmpOrderNo(no);
        List<UocCmpOrderItem> uocCmpOrderItemList = uocCmpOrderDo.getUocCmpOrderItemList();
        if (CollectionUtil.isNotEmpty(uocCmpOrderItemList)) {
            for (int i = 0; i < uocCmpOrderItemList.size(); ++i) {
                UocCmpOrderItem uocCmpOrderItem = uocCmpOrderItemList.get(i);
                uocCmpOrderItem.setCmpOrderId(cmpId);
                uocCmpOrderItem.setCmpOrderItemId(IdUtil.nextId());
                if (CollectionUtils.isEmpty(uocCmpOrderItem.getUocCmpItemMapList())) continue;
                for (UocCmpItemMap uocCmpItemMap : uocCmpOrderItem.getUocCmpItemMapList()) {
                    uocCmpItemMap.setOrderId(uocCmpOrderDo.getOrderId());
                    uocCmpItemMap.setId(IdUtil.nextId());
                    uocCmpItemMap.setCmpOrderItemId(uocCmpOrderItem.getCmpOrderItemId());
                    uocCmpItemMap.setCreateOperId(uocCmpOrderDo.getCreateOperId());
                    uocCmpItemMap.setCreateTime(uocCmpOrderDo.getCreateTime());
                }
            }
        }
        if (!CollectionUtils.isEmpty(uocCmpOrderDo.getUocCmpOrderMapList())) {
            for (UocCmpOrderMap uocCmpOrderMap : uocCmpOrderDo.getUocCmpOrderMapList()) {
                uocCmpOrderMap.setId(IdUtil.nextId());
                uocCmpOrderMap.setCmpOrderId(cmpId);
                uocCmpOrderMap.setOrderId(uocCmpOrderDo.getOrderId());
                uocCmpOrderMap.setCreateOperId(uocCmpOrderDo.getCreateOperId());
                uocCmpOrderMap.setCreateTime(uocCmpOrderDo.getCreateTime());
            }
        }
        this.uocCmpOrderRepository.createCmpOrder(uocCmpOrderDo);
        return uocCmpOrderDo;
    }

    @Override
    public UocCmpOrderQryBo qryCmpOrder(UocCmpOrderQryBo uocCmpOrderDo) {
        this.valQryCmpOrderDetail(uocCmpOrderDo);
        return this.uocCmpOrderRepository.qryCmpOrder(uocCmpOrderDo);
    }

    private void valQryCmpOrderDetail(UocCmpOrderQryBo uocCmpOrderDo) {
        if (null == uocCmpOrderDo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == uocCmpOrderDo.getCmpOrderNo()) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u6bd4\u4ef7\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void valCreateCmpOrderDo(UocCmpOrderDo uocCmpOrderDo) {
        if (null == uocCmpOrderDo) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty(uocCmpOrderDo.getUocCmpOrderItemList())) {
            throw new BaseBusinessException("102001", "\u5165\u53c2\u6bd4\u4ef7\u5355\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String biuldNo(String planNo, String pro) {
        String date = DateUtils.dateToStr((Date)new Date()).replaceAll("-", "");
        String time = String.valueOf(System.currentTimeMillis());
        String no = "";
        if (StringUtils.isNotBlank((CharSequence)pro)) {
            no = no + pro;
        }
        if ((no = no + date + time.substring(time.length() - 6)).equals(planNo)) {
            this.biuldNo(no, pro);
        }
        UocCmpOrderDo uocCmpOrderDo = new UocCmpOrderDo();
        uocCmpOrderDo.setCmpOrderNo(no);
        int count = this.uocCmpOrderRepository.getCheckBy(uocCmpOrderDo);
        if (count > 0) {
            this.biuldNo(no, pro);
        }
        return no;
    }
}

