/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.service.order;

import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.order.IUocOrderModel;
import com.tydic.dyc.oc.model.order.UocOrderDo;
import com.tydic.dyc.oc.model.order.qrybo.UocOrderQueryIndexQryBo;
import com.tydic.dyc.oc.model.order.sub.UocOrderCancelAdvanceOrderTask;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.saleorder.IUocSaleOrderModel;
import com.tydic.dyc.oc.model.saleorder.UocSaleOrderDo;
import com.tydic.dyc.oc.service.order.UocLastEsPreOrderDealService;
import com.tydic.dyc.oc.service.order.bo.UocCancelOrderBo;
import com.tydic.dyc.oc.service.order.bo.UocLastEsPreOrderDealReqBo;
import com.tydic.dyc.oc.service.order.bo.UocLastEsPreOrderDealRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"OC_GROUP_DEV/2.0.0/com.tydic.dyc.oc.service.order.UocLastEsPreOrderDealService"})
public class UocLastEsPreOrderDealServiceImpl
implements UocLastEsPreOrderDealService {
    @Autowired
    private IUocOrderModel iUocOrderModel;
    @Autowired
    private IUocSaleOrderModel iUocSaleOrderModel;

    @PostMapping(value={"dealLastEsPreOrder"})
    public UocLastEsPreOrderDealRspBo dealLastEsPreOrder(@RequestBody UocLastEsPreOrderDealReqBo reqBo) {
        UocLastEsPreOrderDealRspBo rsp = UocRu.success(UocLastEsPreOrderDealRspBo.class);
        UocOrderDo selectDo = new UocOrderDo();
        selectDo.setOrderId(reqBo.getOrderId());
        UocOrderDo resultDo = this.iUocOrderModel.qryOrderBy(selectDo);
        if (null == resultDo) {
            throw new BaseBusinessException("100100", "\u8be5\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        if ("ZD_SP_QX".equals(resultDo.getOrderState())) {
            UocSaleOrderDo uocSaleOrderDo = new UocSaleOrderDo();
            uocSaleOrderDo.setOrderId(reqBo.getOrderId());
            List<UocSaleOrderDo> saleOrderList = this.iUocSaleOrderModel.qrySaleOrderList(uocSaleOrderDo);
            ArrayList cancelSaleOrderList = new ArrayList();
            cancelSaleOrderList.addAll(saleOrderList.stream().filter(bo -> bo.getOrderSource().equals(UocConstant.SkuSource.ELC) && bo.getCreatedResult().equals(UocConstant.CREATED_RESULT.SUCCESS)).collect(Collectors.toList()));
            if (!CollectionUtils.isEmpty(cancelSaleOrderList)) {
                UocOrderQueryIndexQryBo uocOrderQueryIndexQryBo = new UocOrderQueryIndexQryBo();
                uocOrderQueryIndexQryBo.setOrderId(reqBo.getOrderId());
                uocOrderQueryIndexQryBo.setObjType(UocDicConstant.OBJ_TYPE.SALE);
                List<UocOrderQueryIndex> uocOrderQueryIndexs = this.iUocOrderModel.qryOrderQueryIndexList(uocOrderQueryIndexQryBo);
                if (CollectionUtils.isEmpty(uocOrderQueryIndexs)) {
                    throw new BaseBusinessException("100100", "\u67e5\u8be2\u8ba2\u5355\u5173\u8054\u5916\u90e8\u5355\u53f7\u4e3a\u7a7a\uff01");
                }
                Map<Long, String> saleOrderOutOrderMap = uocOrderQueryIndexs.stream().collect(Collectors.toMap(UocOrderQueryIndex::getObjId, UocOrderQueryIndex::getOutObjId));
                ArrayList<UocOrderCancelAdvanceOrderTask> advanceOrderTaskList = new ArrayList<UocOrderCancelAdvanceOrderTask>();
                for (UocSaleOrderDo bo2 : cancelSaleOrderList) {
                    UocOrderCancelAdvanceOrderTask uocOrderCancelAdvanceOrderTask = new UocOrderCancelAdvanceOrderTask();
                    uocOrderCancelAdvanceOrderTask.setId(IdUtil.nextId());
                    uocOrderCancelAdvanceOrderTask.setOrderId(bo2.getOrderId());
                    uocOrderCancelAdvanceOrderTask.setSaleOrderId(bo2.getSaleOrderId());
                    uocOrderCancelAdvanceOrderTask.setSaleOrderNo(bo2.getSaleOrderNo());
                    uocOrderCancelAdvanceOrderTask.setCreateTime(new Date());
                    uocOrderCancelAdvanceOrderTask.setStatus(UocDicConstant.ORDER_CANCEL_ADVANCE_ORDER_TASK_STATUS.TO_DO);
                    if (null != saleOrderOutOrderMap.get(bo2.getSaleOrderId())) {
                        uocOrderCancelAdvanceOrderTask.setOutObjId(saleOrderOutOrderMap.get(bo2.getSaleOrderId()));
                    }
                    advanceOrderTaskList.add(uocOrderCancelAdvanceOrderTask);
                }
                this.iUocOrderModel.batchCreateCancelAdvanceOrderTask(advanceOrderTaskList);
            }
            cancelSaleOrderList.addAll(saleOrderList.stream().filter(bo -> bo.getOrderSource().equals(UocConstant.SkuSource.AGR)).collect(Collectors.toList()));
            if (!CollectionUtils.isEmpty(cancelSaleOrderList)) {
                List<UocCancelOrderBo> uocCancelOrderBos = UocRu.jsl(cancelSaleOrderList, UocCancelOrderBo.class);
                rsp.setUocCancelOrderBoList(uocCancelOrderBos);
            }
            rsp.setIsStartProcess(Boolean.valueOf(false));
        } else {
            rsp.setOrderNo(resultDo.getOrderNo());
            rsp.setIsStartProcess(Boolean.valueOf(true));
        }
        return rsp;
    }
}

