package com.tydic.dyc.oc.service.domainservice;

import cn.hutool.core.util.ObjectUtil;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.oc.constants.UocRspConstants;
import com.tydic.dyc.oc.model.audit.IUocAuditOrderModel;
import com.tydic.dyc.oc.model.audit.qrybo.UocApprovalObjQryBo;
import com.tydic.dyc.oc.model.audit.sub.UocApprovalObj;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveQryServiceInfo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveQryServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApproveQryServiceRspBo;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

/**
 * 标题:UocApproveQryServiceImpl
 * 说明:
 * 时间:2022/7/8 14:41
 *
 * @author 童垣杰
 */
@HTServiceImpl
public class UocApproveQryServiceImpl implements UocApproveQryService {
    @Autowired
    private IUocAuditOrderModel iUocAuditOrderModel;

    @Override
    public UocApproveQryServiceRspBo qryApprove(UocApproveQryServiceReqBo reqBo) {
        val(reqBo);
        List<UocApprovalObj> uocApprovalObjs = iUocAuditOrderModel.qryApprovealObj(JUtil.js(reqBo, UocApprovalObjQryBo.class));
        List<UocApproveQryServiceInfo> rows = JUtil.jsl(uocApprovalObjs, UocApproveQryServiceInfo.class);
        UocApproveQryServiceRspBo rspBo = UocRu.success(UocApproveQryServiceRspBo.class);
        rspBo.setRows(rows);
        return rspBo;
    }

    private void val(UocApproveQryServiceReqBo reqBo) {
        if (ObjectUtil.isEmpty(reqBo)) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[UocApproveQryServiceReqBo]不能为空");
        }
        if (ObjectUtil.isEmpty(reqBo.getOrderId())) {
            throw new BaseBusinessException(UocRspConstants.RSP_CODE_ARG_EMPTY_ERROR, "入参对象[orderId]不能为空");
        }
    }
}
